<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Communication Center</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> Loading...
    </div>
    
    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>

    <script src="assets/js/theme-switch.js"></script> 

    <? include 'includes/top-bar.php';?>

    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa-solid fa-satellite-dish"></i>
                <h3>Communications Center</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="upload_container">
                    <div class="upload_content">
                        <div class="upload_content_left">
                            <div class="upload_tabs">
                                <button id="defaultUploadOpen" class="upload_links" onclick="openUpload(event, 'results')">
                                    Message Students
                                </button>
                                <button class="upload_links" onclick="openUpload(event, 'learning')">
                                    Message Teachers
                                </button>
                                <button  class="upload_links" onclick="openUpload(event, 'custom')">
                                    Custom Phone
                                </button>
                            </div>

                            <!-- UPLOAD TAB CONTENT -->
                            <div id="results" class="upload_tab_content results_container">
                                <!-- choose where to send message -->
                                <div class="results_top">
                                    <h5>Notify parents by sending an sms or send nottifications to students portal.</h5>
                                </div>
                                <div class="results_top">
                                    <button id="defaultSend" class="send_links" onclick="openSend(event, 'phone')">Send Sms</button>
                                    <button class="send_links" onclick="openSend(event, 'within_sys')">Send to Portal</button>
                                </div>
                                <!-- send message to via sms or email -->
                                <div id="phone" class="send_content learning_content">
                                    <form id="sms_form" method="post" enctype="multipart/form-data">
                                        <div class="sms_top">
                                            <p class="sms_title">Sms one parent at a time or multiple at once!</p>
                                        </div>

                                        <div class="radio_upload_group">
                                            <label>Send SMS to:</label>
                                            <select id="sms_select">
                                                <option value="">--Choose Receiver--</option>
                                                <<option value="one">One Student</option>
                                                <option value="class">One Class</option>
                                            </select>
                                        </div>


                                        <!-- ================Sms students by class=================== -->
                                        <div id="class" class="upload_group sms_none">
                                            <label>
                                                <i class="fa fa-building"></i>
                                                Select Class
                                            </label>
                                            <p class="title">
                                                Note that Bulk sms can only be sent to 120 students per second. So send by classes.
                                            </p>
                                            <select id="class_sms">
                                                <option disabled>
                                                    --Select Class--
                                                </option>
                                                <?php 
                                                $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                                $query = $dbh->prepare($sql);
                                                $query->execute();
                                                $res = $query->fetchAll(PDO::FETCH_OBJ);
                                                if ($query->rowCount() > 0) {
                                                    foreach ($res as $key => $val) {
                                                ?>
                                                <option value="<?php echo $val->id?>">
                                                    <?php echo $val->class_name;?>      
                                                </option>
                                                <?php }}?>
                                            </select>

                                            <div class="upload_group">
                                                <label>
                                                    <i class="fa fa-envelope"></i>
                                                    Sms Message
                                                </label>
                                                <p class="title">*Message to be received by all the parents of the selected class</p>
                                                <textarea name="message" id="message" placeholder="message here.." rows="5" name="message"></textarea>
                                            </div>

                                            <button class="btn" type="submit" onclick="getSmsClass();" >
                                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                                <p id="ajax_text">Sms All</p>
                                                <img id="sms_loader" src="assets/images/blank.gif">
                                            </button>
                                        </div>
                                        <!-- ================Sms all students=================== -->

                                        <!-- ==================sms one students at a time=================== -->
                                        <div id="one">
                                            <div class="upload_group">
                                                <label>
                                                    <i class="fa fa-building"></i>
                                                    Select Class
                                                </label>
                                                <p class="title">
                                                    * select class the student is in.
                                                </p>
                                                <select name="sms_class" onchange="getSelectedClass(this.options[this.selectedIndex].value);">

                                                    <option value="">
                                                        --Select Class--
                                                    </option>
                                                    <?php 
                                                    $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                                    $query = $dbh->prepare($sql);
                                                    $query->execute();
                                                    $res = $query->fetchAll(PDO::FETCH_OBJ);
                                                    if ($query->rowCount() > 0) {
                                                        foreach ($res as $key => $val) {
                                                    ?>
                                                    <option value="<?php echo $val->id?>">
                                                        <?php echo $val->class_name;?>      
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                            </div>

                                            <div  class="upload_group">
                                                <label>
                                                    <i class="fa fa-user"></i>
                                                    Choose student
                                                </label>
                                                <p class="title">
                                                    * Choose the student you want to send message. NOTE: the message will be received by the parent.
                                                </p>
                                                <select name="sms_mobile" id="students_by_class">
                                                    <!-- display the students here -->
                                                    <option value="">
                                                        --Select a student--
                                                    </option>
                                                </select>

                                            </div>

                                            <div class="upload_group">
                                                <label>
                                                    <i class="fa fa-envelope"></i>
                                                    Sms Message
                                                </label>
                                                <textarea name="message" id="message" placeholder="message here.." rows="5" name="message"></textarea>
                                            </div>

                                            <button id="smsBtn" type="submit" onclick="sendSmsAjax();"  name="send_sms">
                                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                                <p id="ajax_text">Send Sms</p>
                                                <img id="ajax_loader" src="assets/images/blank.gif">
                                            </button>
                                        </div>
                                         <!-- ==================sms one students at a time=================== -->

                                    </form>
                                </div>

                                <!-- send message within the system -->
                                <div id="within_sys" class="send_content learning_content">
                                    

                                    <form id="portal_form" action="" method="post">   <div class="radio_upload_group">
                                            <label>Send Message to:</label>
                                            <select id="portal_select" name="portal_receiver">
                                                <option value="">--Choose receiver--</option>
                                                <option value="one_sdt">One Student</option>
                                                <option value="one_class">One Class</option>
                                                <option value="all_sdt">All Students</option>
                                            </select>
                                        </div>

                                        <!-- one student sms -->
                                        <div id="one_sdt">
                                            <div class="upload_group">
                                                <label>
                                                    <i class="fa fa-building" aria-hidden="true"></i>
                                                    Choose Class
                                                </label>
                                                <p class="title">
                                                    * Choose the class student is in.
                                                </p>
                                                <select name="sdt_class" onchange="getSelectedPortalClass(this.options[this.selectedIndex].value);">
                                                    <option value="">--Choose Class--</option>
                                                    <?php 
                                                    $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                                    $query = $dbh->prepare($sql);
                                                    $query->execute();
                                                    $res = $query->fetchAll(PDO::FETCH_OBJ);
                                                    if ($query->rowCount() > 0) {
                                                        foreach ($res as $key => $val) {
                                                    ?>
                                                    <option value="<?php echo $val->id?>">
                                                        <?php echo $val->class_name;?>      
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                            </div>
                                            <div class="upload_group">
                                                <label>
                                                    <i class="fa fa-user" aria-hidden="true"></i>
                                                    Choose student.
                                                </label>
                                                <select name="portal_mobile" id="portal_std_notify">
                                                    <!-- display the students -->
                                                    <option value="">--choose student below--</option>
                                                </select>
                                            </div>                                      
                                        </div>

                                        <!-- portal class -->
                                        <div id="one_class" class="upload_group">
                                            <label>
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                                Choose  class
                                            </label>
                                            <p class="title">
                                                * Choose a class which will receive this message in their portal.
                                            </p>
                                            <select name="portal_class">
                                                <option value="">--Choose class--</option>

                                                <?php 
                                                $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                                $query = $dbh->prepare($sql);
                                                $query->execute();
                                                $res = $query->fetchAll(PDO::FETCH_OBJ);
                                                if ($query->rowCount() > 0) {
                                                    foreach ($res as $key => $val) {
                                                ?>
                                                <option value="<?php echo $val->id?>">
                                                    <?php echo $val->class_name;?>      
                                                </option>
                                                <?php }}?>
                                            </select>
                                        </div>

                                        <div id="all_sdt" class="upload_group">
                                            <h3 class="title"
                                            style="
                                                color: var(--btn-blue);
                                                font-weight: 700;
                                                font-size: 16px;
                                            " >
                                                <i class="fa fa-exclamation-circle" aria-hidden="true"></i>
                                                All Students Will receive this Message!
                                                <input type="checkbox" name="all_sdt">
                                            </h3>
                                        </div>

                                        <div class="upload_group">
                                            <label>
                                                <i class="fa fa-comments" aria-hidden="true"></i>
                                                Message
                                            </label>
                                            <textarea placeholder="Describe the the content you want to send..." type="text" name="portal_msg" rows="5"></textarea>
                                        </div>

                                        <div class="upload_group">
                                            <label>
                                                <i class="fa fa-upload"></i>
                                                Document
                                            </label>
                                            <small style="margin-bottom:10px;font-weight: 500;"><code><p style="color: red;">NOTE:</p> Select the pdf or word document from where you have saved it. This is for the notes that students can download or read from the site.</code></small>
                                            <input type="file" name="portal_doc">
                                        </div>

                                        <button id="portalBtn" type="submit" onclick="portalAjax();" >
                                            <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                            <p id="ajax_text_p">Notify</p>
                                            <img id="ajax_loader_p" src="assets/images/blank.gif">
                                        </button>
                                    </form>
                                </div>
                            </div>

                            <div id="learning" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <h5>Choose Teacher</h5>
                                    <button>Send Within System</button>
                                </div>
                                <span>
                                    <small style="margin-bottom:10px;font-weight: 500;"><code><p style="color: red;">NOTE:</p> You can send one or all the teachers an SMS here below!</code></small>
                                <span>
                                <div class="learning_content">
                                    <form id="teacher_sms_form" method="post">
                                        <div class="upload_group">
                                            <label>Choose Teacher</label>
                                            <select id="t_phone">
                                                <option>--Choose Teacher--</option>
                                                <?php 
                                                $retriveTeacher = $dbh->query("SELECT * FROM staff WHERE role = 'Teacher' ORDER BY id DESC");
                                                $results = $retriveTeacher->fetchAll(PDO::FETCH_OBJ);
                                                if ($retriveTeacher->rowCount() > 0) {
                                                    foreach ($results as $key => $val) {                                                       
                                                   
                                                ?>
                                                <option value="<? echo $val->phone; ?>">
                                                    <?php echo htmlentities($val->first_name);?>&nbsp;
                                                    <?php echo htmlentities($val->last_name);?>
                                                        
                                                </option>
                                                <?php 
                                                     }
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <div class="upload_group">
                                            <label>Message</label>
                                            <textarea rows="6" id="t_message" placeholder="Your message here"></textarea>
                                        </div>
                                        <button onclick="javascript:teacherSms();">Notify</button>
                                    </form>
                                </div>
                            </div>

                            <!-- custom  -->
                            <div id="custom" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <button>Send message below</button>
                                </div>
                                <span>
                                    <small style="margin-bottom:10px;font-weight: 500;"><code><p style="color: red;">NOTE:</p> Please ensure you enter the phone number correctly!</code></small>
                                <span>

                                <div class="learning_content">
                                    <form id="custom_form" action="" method="post">

                                        <div class="upload_group">
                                            <label>Phone</label>
                                            <input type="text" id="custom_phone" placeholder="254...">
                                        </div>

                                        <div class="upload_group">
                                            <label>Message</label>
                                            <textarea rows="5" id="custom_message" placeholder="Yor message here."></textarea>
                                        </div>
    
                                        <button onclick="javascript:sendCustom();">
                                            Send
                                        </button>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <div class="upload_content_right">
                            <h3>Communication History</h3>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>


    <div class="fancy_loader" id="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Sending...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>   

    <script type="text/javascript">
        // click on the the button with defaultOpen on page load
        document.getElementById('defaultUploadOpen').click();
        document.getElementById('defaultSend').click();


        $(document).ready(function() {
          $("#class").hide();
          $("#one").hide();
          $("#fancy_loader").hide();
          $("#sms_loader").hide();
        });
        $("#sms_select").on("change", function() {

            if ($(this).val() == 'class') {
                $("#" + $(this).val()).show();
                $("#one").hide();
            }else{
                $("#" + $(this).val()).show();
                $("#class").hide();
            }
            
        });

        $(document).ready(function() {
          $("#one_class").hide();
          $("#one_sdt").hide();
          $("#all_sdt").hide();
          $("#ajax_loader").hide();
          $("#ajax_loader_p").hide();
        });

        $("#portal_select").on("change", function() {

            if ($(this).val() == 'one_class') {
                $("#" + $(this).val()).show();
                $("#one_sdt").hide();
                $("#all_sdt").hide();
            }else if ($(this).val() == 'one_sdt') {
                $("#" + $(this).val()).show();
                $("#one_class").hide();
                $("#all_sdt").hide();
            }else{
                $("#" + $(this).val()).show();
                $("#one_sdt").hide();
                $("#one_class").hide();
            }
            
        });

        function getSmsClass() {
            let class_sms_form = document.querySelector("#sms_form");
            let err = document.querySelector("#error");
            let suc = document.querySelector("#success");

            let class_id = $("#class_sms").val();
            let message = $("#message").val();

            let data = { class_id, message }

            class_sms_form.onsubmit = (e) => { e.preventDefault();}

            // ajax
            $.ajax({
                url: 'includes/sms-class.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    if (response.status == true) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else{

                        err.textContent = response.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#fancy_loader").show();
                    $("#sms_loader").show();

                },
                complete: function() {

                    $("#fancy_loader").hide();
                    $("#sms_loader").hide();

                }
            })
            
        }

        function teacherSms() {

            let teacher_form = document.getElementById("teacher_sms_form"),
            err = document.querySelector("#error"),
            suc = document.querySelector("#success");

            teacher_form.onsubmit = (e) => {  e.preventDefault(); }

            let mobile = $("#t_phone").val();
            let message = $("#t_message").val();

            let data = { mobile, message }

            // ajax
            $.ajax({
                url: 'includes/custom-sms.php',
                method: 'POST',
                data: data,
                success: function (data) {

                    let response = JSON.parse(data);

                    if (response.status == true) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else{

                        err.textContent = response.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#fancy_loader").show();

                },
                complete: function() {

                    $("#fancy_loader").hide();

                }
            });

        }

        function sendCustom(){

            let custom_form = document.querySelector("#custom_form"),
            err = document.querySelector("#error"),
            suc = document.querySelector("#success");

            custom_form.onsubmit = (e) => { e.preventDefault(); }

            let mobile = $("#custom_phone").val();
            let message = $("#custom_message").val();

            let data = { mobile, message }

            // ajax
            $.ajax({
                url: 'includes/custom-sms.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    // receive response
                    let response = JSON.parse(data);

                    if (response.status == true ) {

                       suc.textContent = response.message;
                        suc.style.display = "block";
                        error.style.display = "none"; 

                    }else{

                        error.textContent = response.message;
                        error.style.display = "block";
                        suc.style.display = "none";
                    }


                },
                beforeSend: function() {

                    $("#fancy_loader").show();

                },
                complete: function() {

                    $("#fancy_loader").hide();

                }
            });
        }

        function getSelectedClass(value) {

            let selectedClass = value;

            let holdContainer = document.querySelector("#students_by_class");

            let xhr = new XMLHttpRequest();

            xhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#fancy_loader").show();

                }
                if (this.readyState == 4 && this.status == 200) {

                    $("#fancy_loader").hide();

                    let response = JSON.parse(this.responseText);
                    let output = "";

                    if (response == null) {
                        output += `
                            <option value="">
                                --No students found--
                            </option>
                        `;
                    }else{

                        for(let item of response) {
                            output += `
                                <option value="${item.Phone}">
                                    ${item.First_Name} ${item.Last_Name}
                                </option>
                            `;
                        }
                    }

                    holdContainer.innerHTML = output;
                }
            }
            xhr.open("POST", "includes/script.php");
            xhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            xhr.send("classId="+selectedClass);

        }

        function getSelectedPortalClass(value) {

            let selectedPortalClass = value;

            let portalContainer = document.querySelector("#portal_std_notify");

            let portalXhr = new XMLHttpRequest();

            portalXhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#fancy_loader").show();

                }

                if (this.readyState == 4 && this.status == 200) {

                    $("#fancy_loader").hide();

                    let response = JSON.parse(this.responseText);
                    let portalOutPut = "";

                    if (response == null) {
                        portalOutPut += `
                            <option value="">
                                --No students found in this class--
                            </option>
                        `;
                    }else{

                        for(let item of response) {
                            portalOutPut += `
                                <option value="${item.Phone}">
                                    ${item.First_Name} ${item.Last_Name}
                                </option>
                            `;
                        }
                    }

                    portalContainer.innerHTML = portalOutPut;
                }
            }
            portalXhr.open("POST", "includes/script.php");
            portalXhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            portalXhr.send("classId="+selectedPortalClass);

        }

        function sendSmsAjax() {

            const smsForm = document.querySelector("#sms_form"),
            smsBtn =  document.querySelector("#smsBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");

            sms = $('#smsBtn').val();

            smsForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let smsXhr = new XMLHttpRequest(); //creating xml object

            smsXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                  $("#fancy_loader").show();
                }

                if (smsXhr.readyState === XMLHttpRequest.DONE) {
                    if (smsXhr.status === 200) {

                        $("#ajax_loader").hide();
                        $("#fancy_loader").hide();

                        let response = JSON.parse(this.responseText);                        

                        if (response !== undefined && response !== null && response !== "") {

                            if (response.status == 'true') {
                               sucText.textContent = response.message;
                                sucText.style.display = "block";
                                errorText.style.display = "none"; 
                            }else{
                                errorText.textContent = response.message;
                                errorText.style.display = "block";
                                sucText.style.display = "none";
                            }
                                
                            
                        }else{
                            errorText.textContent = response;
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                    }
                }
            }
            
  

            smsXhr.open("POST", "includes/sms.php");
            let smsFormData = new FormData(smsForm);
           
            smsXhr.send(smsFormData);

        }

        function portalAjax() {

            const portalForm = document.querySelector("#portal_form"),
            portalBtn =  document.querySelector("#portalBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");


            portalForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let portalXhr = new XMLHttpRequest(); //creating xml object

            portalXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader_p").show();
                  $("#ajax_text_p").hide();
                }

                if (portalXhr.readyState === XMLHttpRequest.DONE) {
                    if (portalXhr.status === 200) {

                        $("#ajax_loader_p").hide();
                        $("#ajax_text_p").show();

                        let response = JSON.parse(this.responseText);            

                        if (response !== undefined && response !== null && response !== "") {

                            if (response.status == "true") {
                                sucText.textContent = response.message;
                                sucText.style.display = "block";
                                errorText.style.display = "none";
                            }else{
                                errorText.textContent = response.error;
                                errorText.style.display = "block";
                                sucText.style.display = "none";
                            }
                            
                        }else{
                            errorText.textContent = response;
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                    }
                }
            }            
  

            portalXhr.open("POST", "includes/portal.php");
            let portalFormData = new FormData(portalForm);
           
            portalXhr.send(portalFormData);

        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
    </script>
</body>
</html>

<?php }}?>