<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $statusMsg = NULL;
        $error = NULL;
        $create = $_GET['create'];
        $year = date("Y");
        
        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        if (isset($_POST['create_class'])) {
            $class = $_POST['class_name'];

            $checkDup = "SELECT class_name FROM tbl_class WHERE class_name = :c";
            $checkQ = $dbh->prepare($checkDup);
            $checkQ->execute(array(
                ':c' => $class
            ));
            $checkRes = $checkQ->fetchAll(PDO::FETCH_OBJ);
            if ($checkQ->rowCount() > 0) {
                $error = "Duplicate class! You already have a class named ".$class."";
            }else{
                $insertClass = "INSERT INTO tbl_class(class_name) VALUES(:c)";
                $iQ = $dbh->prepare($insertClass);
                $iQ->bindParam(':c', $class, PDO::PARAM_STR);
                $iQ->execute();

                $lastInsertId = $dbh->lastInsertId();
                if ($lastInsertId) {
                    $statusMsg = "You created a class called ".$class."";
                }else{
                    $error = "Something Went wrong! Check the fields and try again";
                }
            }          

        }elseif(isset($_POST['create_subjects'])){
            $sbj = $_POST['sbj_name'];
            $class = $_POST['sbj_class'];

            $checkDup = "SELECT subject_name,class FROM subjects WHERE subject_name = :sbj and class = :c or subject_name = :sbj and class = 'All'"
            ;
            $checkQ = $dbh->prepare($checkDup);
            $checkQ->execute(array(
                ':sbj' => $sbj,
                ':c' => $class
            ));
            $checkRes = $checkQ->fetchAll(PDO::FETCH_OBJ);
            if ($checkQ->rowCount() > 0) {
                $error = "Duplicate Subject! You already have a subject called ".$sbj."";
            }else{
                $insertSbj = "INSERT INTO subjects(subject_name, class)VALUES(:s, :c)";
                $sbjQ = $dbh->prepare($insertSbj);
                $sbjQ->bindParam(':s', $sbj, PDO::PARAM_STR);
                $sbjQ->bindParam(':c', $class, PDO::PARAM_STR);
                $sbjQ->execute();

                $lastInsertId = $dbh->lastInsertId();
                if ($lastInsertId) {
                    $statusMsg = "You successfully created a subject called ".$sbj."";
                }else{
                    $error = "System could not create subjcet! Check the fields and try again";
                }
            }
        }elseif (isset($_POST['create_term'])) {
            $term = $_POST['term'];
            $sDate = $_POST['s_date'];
            $eDate = $_POST['e_date'];

            $checkDup = "SELECT term FROM tbl_term WHERE term = :t";
            $checkQ = $dbh->prepare($checkDup);
            $checkQ->execute(array(
                ':t' => $term
            ));
            $checkRes = $checkQ->fetchAll(PDO::FETCH_OBJ);
            if ($checkQ->rowCount() > 0) {
                $error = "Duplicate term! You already have a term named ".$term."";
            }else{
                $insertTerm = "INSERT INTO tbl_term(term, start_date, end_date, year)VALUES(:t, :sd, :ed, :y)";
                $tQ = $dbh->prepare($insertTerm);
                $tQ->execute(
                    array(
                        ':t'=> $term, 
                        ':sd'=> $sDate, 
                        ':ed'=> $eDate,
                        ':y'=> $year
                    )
                );
                $lI = $dbh->lastInsertId();
                if ($lI) {
                    $statusMsg = "Term for year ".$year." created successfully";
                }else{
                    $error = "could not create term, ckeck you fields and try again";
                }
            }            
        }elseif (isset($_POST['create_role'])) {
            $role = $_POST['role'];

            $insertRole = "INSERT INTO tbl_roles(role, year)
            VALUES(:r, :y)";
            $rQ = $dbh->prepare($insertRole);
            $rQ->execute(array(
                ':r'=> $role,
                'y'=> $year
            ));
            $inserted = $dbh->lastInsertId();
            if ($inserted) {
                $statusMsg = "You have successfully created a role called ".$role."";
            }else{
                $error = "This role ".$role." could not be inserted, try again!";
            }
        }elseif (isset($_POST['create_prefix'])) {
            $prefix = $_POST['prefix_name'];

            $insertPrefix = "INSERT INTO tbl_prefix(prefix_name)
            VALUES(:pn)";
            $rQ = $dbh->prepare($insertPrefix);
            $rQ->execute(array(
                ':pn'=> $prefix
            ));
            $inserted = $dbh->lastInsertId();
            if ($inserted) {
                $statusMsg = "You have successfully created a prefix '".$prefix."'";

            }else{
                $error = "This prefix ".$prefix." could not be inserted, try again!";
            }
        }elseif (isset($_POST['create_section'])) {
            $section = $_POST['section'];
            $class = $_POST['class'];

            $insertSection = "INSERT INTO sections(section_name, class)
            VALUES(:sn, :c)";
            $sQ = $dbh->prepare($insertSection);
            $sQ->execute(array(
                ':sn' => $section,
                ':c' => $class
            ));
            $inserted = $dbh->lastInsertId();
            if ($inserted) {
                $statusMsg = "You have successfully created a section called ".$section." for ".$class."";
            }
        }elseif(isset($_GET['c_del'])) {
            $c_id = $_GET['c_del'];

            $del_class = "DELETE FROM tbl_class WHERE tbl_class.id = :cd";
            $cQ = $dbh->prepare($del_class);
            $cQ->execute(array(
                ':cd' => $c_id
            ));
            $d_res = $cQ->fetchAll(PDO::FETCH_OBJ);
            if ($cQ->rowCount() > 0) {
                $statusMsg = "Class deleted successfully";
                header("Refresh:2; url=create-init.php?create=class");

            }else{
                $error = "Something went wrong!";
            }
        }elseif (isset($_GET['t_del'])) {
            $t_del = $_GET['t_del'];

            $del_term = "DELETE FROM tbl_term WHERE tbl_term.id = :td";
            $tQ = $dbh->prepare($del_term);
            $tQ->execute(array(
                ':td' => $t_del
            ));
            $t_res = $tQ->fetchAll(PDO::FETCH_OBJ);
            if ($tQ->rowCount() > 0) {
                $statusMsg = "Term Deleted successfully";
                header("Refresh:2; url=create-init.php?create=term");
            }
        }elseif (isset($_GET['sbj_del'])) {
            $sbj_del = $_GET['sbj_del'];

            $del_sbj = "DELETE FROM subjects WHERE subjects.id = :sbj";
            $sbjQ = $dbh->prepare($del_sbj);
            $sbjQ->execute(array(
                ':sbj' => $sbj_del
            ));
            $sbj_res = $sbjQ->fetchAll(PDO::FETCH_OBJ);
            if ($sbjQ->rowCount() > 0) {
                $statusMsg = "Subject Deleted successfully";
                header("Refresh:2; url=create-init.php?create=subjects");
            }
        }elseif (isset($_GET['role_del'])) {
            $role_del = $_GET['role_del'];

            $role_sbj = "DELETE FROM tbl_roles WHERE tbl_roles.id = :role_id";
            $roleQ = $dbh->prepare($role_sbj);
            $roleQ->execute(array(
                ':role_id' => $role_del
            ));
            $role_res = $roleQ->fetchAll(PDO::FETCH_OBJ);
            if ($roleQ->rowCount() > 0) {
                $statusMsg = "ROLE Deleted successfully";
                header("Refresh:2; url=create-init.php?create=roles");
            }
        }elseif (isset($_GET['section_del'])) {
            $section_del = $_GET['section_del'];

            $section = "DELETE FROM sections WHERE sections.id = :section_id";
            $sectionQ = $dbh->prepare($section);
            $sectionQ->execute(array(
                ':section_id' => $section_del
            ));
            $section_res = $sectionQ->fetchAll(PDO::FETCH_OBJ);
            if ($sectionQ->rowCount() > 0) {
                $statusMsg = "Section deleted successfully";
                header("Refresh:2; url=create-init.php?create=streams");
            }
        }elseif (isset($_GET['prefix_del'])) {
            $prefix_del = $_GET['prefix_del'];

            $prefix_d = "DELETE FROM tbl_prefix WHERE tbl_prefix.id = :p_id";
            $pQ = $dbh->prepare($prefix_d);
            $pQ->execute(array(
                ':p_id' => $prefix_del
            ));
            $role_res = $pQ->fetchAll(PDO::FETCH_OBJ);
            if ($pQ->rowCount() > 0) {
                $statusMsg = "Prefix Deleted successfully";
                header("Refresh:2; url=create-init.php?create=prefix");
            }
        }          
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Getting started - Initilization</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
    <script>
        if ( window.history.replaceState ) {
            window.history.replaceState( null, null, window.location.href );
        }
    </script>
</head>

<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>
    
    <!-- //Status Wrap -->
    <?php if($statusMsg){?>
    <div onclick="this.style.display='none'" class="success_wrap">
        <?php echo htmlentities($statusMsg); ?>
    </div><?php }elseif ($error) {?>

    <div onclick="this.style.display='none'" class="error_wrap">
        <?php echo htmlentities($error); ?>
    </div><?php }?>
    <!-- //status Wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-cog"></i>
                <h3>Get Started</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, initilize system!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Initialization</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- CREATE INITIALIZATION -->
            <div class="student_container">
                <div class="upload_container">
                    <!-- <div class="upload_top">
                        <h3>Initilization</h3>
                        <h5>Create</h5>
                    </div> -->
                    <?php if ($create == 'year') {?>
                    <!-- ====ACADEMIC YEAR==== -->
                    <div id="acd_y" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Create Academic Year</h2>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Enter Year</label>
                                        <code>Simply enter the year how it is from the ministry of education. Example: 2021/2022... OR 2023...</code>
                                        <input placeholder="eg. 2021/2022..." type="text" name="y_title" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Start Date</label>
                                        <input placeholder="08/03/2022" id="start_date" type="text" name="s_date" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>End Date</label>
                                        <input placeholder="08/03/2023" id="end_date" type="text" name="e_date" required>
                                    </div>


                                    <button type="submit" name="create_structure">
                                        <i class="fa-solid fa-plus"></i>Create
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">

                        </div>
                    </div>
                    <!-- //====ACADEMIC YEAR==== -->
                    <?php }elseif ($create == 'term') {?>
                    <!-- ====ACADEMIC TERM==== -->
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Term</h2>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Enter Term</label>
                                        <input placeholder="Term" type="text" name="term" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Start Date</label>
                                        <input placeholder="MM/DD/YYYY" id="start_date" type="text" name="s_date" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>End Date</label>
                                        <input placeholder="MM/DD/YYYY" id="end_date" type="text" name="e_date" required>
                                    </div>


                                    <button type="submit" name="create_term">
                                        <i class="fa-solid fa-check"></i>
                                        Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            <td>Term</td>
                                            <td>Start Date</td>
                                            <td>End Date</td>
                                            <td>Year</td>
                                            <td>Added ON</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchClass = "SELECT * FROM tbl_term order by id";
                                        $fetchQ = $dbh->prepare($fetchClass);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($classCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td>#<?php echo $cnt; ?></td>
                                            <td><?php echo $r->term; ?></td>
                                            <td><?php echo $r->start_date; ?></td>
                                            <td><?php echo $r->end_date; ?></td>
                                            <td><?php echo $r->year; ?></td>
                                            <td><?php echo $r->creation_date; ?></td>
                                            <td class="student_edit">
                                                <a class="delete" onclick="return confirm('Are you sure you want to delete this term?');" href="?t_del=<?php echo $r->id; ?>">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====ACADEMIC TERM==== -->
                    <?php }elseif ($create == 'class') {?>
                    <!-- ====ACADEMIC TERM==== -->
                    <p class="title">
                        <a href="create-init.php?create=streams">
                            <button class="btn">
                                <i class="fa-solid fa-plus"></i>
                                Add Sections
                            </button>
                        </a>
                    </p>
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Class</h2>
                                
                                <form action="" method="post">
                                    <p class="title">
                                        Here we Add classes to get started with the initilization. NOTE: When you have created all the classes in the school, you don't need to add them again the future.
                                    </p>
                                    <div class="upload_group">
                                        <label>Class Name</label>
                                        <input placeholder="eg. grade 1.."  type="text" name="class_name" required>
                                    </div>

                                    <button type="submit" name="create_class">
                                        <i class="fa-solid fa-check"></i>
                                        Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            
                                            <td>Class Name</td>
                                            <td>Added On</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchClass = "SELECT * FROM tbl_class order by id";
                                        $fetchQ = $dbh->prepare($fetchClass);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($classCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td><?php echo $cnt; ?></td>
                                            
                                            <td><?php echo $r->class_name; ?></td>
                                            <td><?php echo $r->creation_date; ?></td>
                                            <td class="student_edit">
                                                <a class="delete" onclick="return confirm('Are you sure you want to delete this class?');" href="?c_del=<?php echo $r->id; ?>">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>                            
                        </div>
                    </div>
                    <!-- //====ACADEMIC TERM==== -->
                    <?php }elseif ($create == 'subjects') {?>
                    <!-- ====ACADEMIC TERM==== -->
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add subjects</h2>
                                <form id="form" action="" method="post">
                                   
                                    <div class="upload_group">
                                        <label>Subject Name</label>
                                        <input placeholder="eg. Arts, English, Maths" type="text" name="sbj_name" required>
                                    </div>
                                    <div class="upload_group">
                                        <label>Class</label>
                                        <select name="sbj_class">
                                            <option value="">--Select Class--</option>
                                            <option style="color: var(--bl-color);" value="All">All Classes</option>
                                            <?php 
                                            $fetchClass = "SELECT * FROM tbl_class order by id";
                                            $fetchQ = $dbh->prepare($fetchClass);
                                            $fetchQ->execute();
                                            $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);

                                            if ($classCnt = $fetchQ->rowCount() > 0) {
                                                foreach ($res as $key => $val) {
                                            ?>
                                            <option value="<?php echo $val->id; ?>"><?php echo $val->class_name; ?></option>
                                            <?php }}?>
                                        </select>
                                    </div>              

                                    <button type="submit" name="create_subjects">
                                        <i class="fa-solid fa-check"></i>
                                        Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            <td>Subject Name</td>
                                            <td>Class</td>
                                            <td>Added On</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchClass = "SELECT * FROM subjects order by id";
                                        $fetchQ = $dbh->prepare($fetchClass);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($classCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td><?php echo $cnt; ?></td>
                                            <td><?php echo $r->subject_name; ?></td>
                                            <td><?php echo $r->class; ?></td>
                                            <td><?php echo $r->creation_date; ?></td>
                                            <td class="student_edit">
                                                <a class="delete" onclick="return confirm('Are you sure you want to delete this subject?');" href="?sbj_del=<?php echo $r->id; ?>">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====ACADEMIC TERM==== -->
                    <?php }elseif ($create == 'streams') {?>
                    <!-- ====STREAMS==== -->
                    <p class="title">                        
                        <button class="btn" onclick="history.back();">
                            <i class="fa-solid fa-arrow-left-long"></i>
                            Back 
                        </button>                       
                    </p>
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Section</h2>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Section Name</label>
                                        <code>Section Name for all the class in this school. Example: Hope,Joy,Peace...</code>
                                        <input placeholder="Section Name" type="text" name="section" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Class</label>
                                        <select name="class">
                                            <option disabled>
                                                --Select Class--
                                            </option>
                                            <option value="All">All</option>
                                            <?php 
                                            $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                            $query = $dbh->prepare($sql);
                                            $query->execute();
                                            $res = $query->fetchAll(PDO::FETCH_OBJ);
                                            if ($query->rowCount() > 0) {
                                                foreach ($res as $key => $val) {
                                            ?>
                                            <option value="<?php echo $val->class_name?>"><?php echo $val->class_name;?></option>
                                            <?php }}?>
                                        </select>
                                    </div>

                                    <button type="submit" name="create_section">
                                        <i class="fa-solid fa-check"></i>
                                        Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            <td>Section Name</td>
                                            <td>Class</td>
                                            <td>Added On</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchClass = "SELECT * FROM sections order by id";
                                        $fetchQ = $dbh->prepare($fetchClass);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($classCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td><?php echo $cnt; ?></td>
                                            <td><?php echo $r->section_name; ?></td>
                                            <td><?php echo $r->class; ?></td>
                                            <td><?php echo $r->creation_date; ?></td>
                                            <td class="student_edit">
                                                <p class="student_edit">
                                                    <a style="color: #222; font-weight: 700;" class="edit" href="?section_del=<?php echo $r->id;?>">
                                                        <i class="fa-solid fa-trash"></i>
                                                    </a>
                                                </p>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====ACADEMIC TERM==== -->
                    <?php }elseif ($create == 'roles') {?>
                    <!-- ====STREAMS==== -->
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Roles</h2>
                                <p class="title">
                                    Add Roles to be assigned to staff or students.                                    
                                </p>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Role</label>
                                        <code>Roles that you want to assign. EXAMPLE: Driver, Cooks...</code>
                                        <input placeholder="Role Name..." type="text" name="role" required>
                                    </div>

                                    <button type="submit" name="create_role">
                                        <i class="fa-solid fa-check"></i>
                                        Save Role
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            <td>Role</td>
                                            <td>Year</td>
                                            <td>Added On</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchClass = "SELECT * FROM tbl_roles order by id";
                                        $fetchQ = $dbh->prepare($fetchClass);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($classCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td>#<?php echo $cnt; ?></td>
                                            <td><?php echo $r->role; ?></td>
                                            <td><?php echo $r->year; ?></td>
                                            <td><?php echo $r->creation_date; ?></td>
                                            <td class="student_edit">
                                                 <a class="delete" onclick="return confirm('Are you sure you want to delete this ROLE?');" href="?role_del=<?php echo $r->id; ?>">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====ACADEMIC TERM==== -->

                    <!-- //====SCHOOL PREFIX==== -->
                    <?php }elseif ($create == 'prefix') {?>
                    <!-- ====STREAMS==== -->
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Prefix</h2>
                                <p class="title">
                                    Add prefix to be used in payment codes and employee numbers.                                    
                                </p>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Prefixs</label>
                                        <code>Prefix here. EXAMPLE: JNS, PVA ...</code>
                                        <input placeholder="Prefix Name..." type="text" name="prefix_name" required>
                                    </div>

                                    <button type="submit" name="create_prefix">
                                        <i class="fa-solid fa-check"></i>
                                        Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>#</td>
                                            <td>Prefix</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $fetchprefix = "SELECT * FROM tbl_prefix order by id";
                                        $fetchQ = $dbh->prepare($fetchprefix);
                                        $fetchQ->execute();
                                        $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                        
                                        $cnt = 1;
                                        if ($prefixCnt = $fetchQ->rowCount() > 0) {
                                            foreach ($res as $key => $r) {
                                        ?>
                                        <tr>
                                            <td>#<?php echo $cnt; ?></td>
                                            <td><?php echo $r->prefix_name; ?></td>
                                            <td class="student_edit">
                                                 <a class="delete" onclick="return confirm('Are you sure you want to delete this prefix?');" href="?prefix_del=<?php echo $r->id; ?>">
                                                    
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>
                                        </tr>

                                        <?php $cnt += 1; }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====SCHOOL PREFIX==== -->
                    <?php }?>
                    

                    
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>   

    <script>
        $(function() {
        $( "#start_date" ).datepicker();
        $( "#end_date" ).datepicker();

        });

        // logic for displaying unique content from hash
        $(function() {
        var Div1 = $('#acd_y');
        var Div2 = $('#acd_t');

        if (location.hash === "#year") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div1).removeClass('c_h').siblings().addClass('upload_content');
            }, 1);

        } else if (location.hash === "#term") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div2).removeClass('c_h').siblings().addClass('upload_content');
            }, 1);

        } else if (location.hash === "#Show_Div3") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div3).removeClass('is-visuallyhidden').siblings().addClass('is-visuallyhidden');
            }, 1);

        }
        });

    </script>

    

</body>
</html>

<?php 
// print_r($create);
    }
} 
?>