<?php
session_start();
error_reporting(E_ALL);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?php echo htmlentities($name_res->f_name);?>
        <?php echo htmlentities($name_res->l_name);?> &mdash; Dashboard
    </title>
    <link rel="stylesheet" href="assets/css/theme.css">      
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">        
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="../admin/assets/fullcalendar/fullcalendar.min.css" />
    
</head>
<body>
    <div class="page_loader">
        <img src="../admin/assets/images/blank.gif"> Loading...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="pendRemove();" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->
    
    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script> 
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa-solid fa-home"></i>
                <h3>Admin Dashboard</h3>
            </div>

            <?php require 'side.php';?>

            <?php 
            //try block for the number of logins
            try{
                $sql = "SELECT (SELECT SUM(total_logins)  FROM student) AS st_total,
                (SELECT SUM(total_logins) FROM admin) AS adm_total,
                (SELECT SUM(total_logins) FROM staff) AS ts_total";
                $result = $dbh->query($sql);

                if ($result->rowCount() > 0) {
                    while ($row = $result->fetch()) {             
                        $adm_totalArray = $row['adm_total'];

                        if (!empty($row['ts_total'])) {
                            $ts_totalArray = $row['ts_total'];
                        }else{
                            $ts_totalArray = 0;
                        }
                        if (!empty($row['st_total'])) {
                            $st_totalArray = $row['st_total'];
                        }else{
                            $st_totalArray = 0;
                        }                        
                        
                    }
                    unset($result);
                }else{
                    $adm_totalArray = 0;
                    $st_totalArray = 0;
                    $ts_totalArray = 0;
                    error_log("No logins made in the system yet!\n",3,'assets/images/student/error_log/errors.log');
                }
            }catch(PDOException $e) {
                exit("Error: " . $e->getMessage());
            }

            ?>
            <div class="chart_side">
                <span style="text-align: center;">
                    <h4 style="color: var(--bg-blue); font-weight: 700">
                        Data plot for logins on the system
                    </h4>
                </span>
                <canvas id="loginChart"></canvas>
            </div>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">

                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($name_res->f_name);?>&nbsp;
                    <?php echo htmlentities($name_res->l_name);?>, welcome to admin Panel!
                </p>

                <p name="Home" class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p name="communicate" class="controls_mobile std_chat">
                    <a class="nav_grid" href="communicate.php">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p name="Messages" class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div name="Dropdown" class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- DASHBOARD TOP CONTAINER -->
            <div class="dasboard_top">
                <div class="top_cards">
                    <a href="student/student_list.php?filter_id=0&gender=all">
                        <div class="top_card">
                            <div class="card_left">
                                <h4>Students</h4>
                                <p><i class="fa fa-user"></i>Total students</p>
                            </div>
                            <div class="card_total">
                                <?php
                                    $sql = "SELECT id FROM student";
                                    $query = $dbh->query($sql); 
                                    $students = $query->rowCount();
                                ?>
                                <p><?php echo htmlentities($students)?></p>
                            </div>
                        </div>
                    </a>

                    <a href="teacher/staff_list.php?role=teacher">
                        <div class="top_card">
                            <div class="card_left">
                                <h4>Teachers</h4>
                                <p><i class="fa-solid fa-person-chalkboard"></i>Total teachers</p>
                            </div>
                            <div class="card_total">
                                <?php
                                    $sql = "SELECT id,role FROM staff WHERE role = 'Teacher' ";
                                    $query = $dbh->query($sql);
                                    $teacher = $query->rowCount();
                                ?>
                                <p><?php echo htmlentities($teacher)?></p>
                            </div>
                        </div>
                    </a>

                    <a href="teacher/staff_list.php?role=staff">
                        <div class="top_card">
                            <div class="card_left">
                                <h4>Staff</h4>
                                <p><i class="fa-solid fa-user"></i>Total staff</p>
                            </div>
                            <div class="card_total">
                                <?php
                                    $sql = "SELECT id,role FROM staff WHERE role != 'Teacher' ";
                                    $query = $dbh->prepare($sql);
                                    $query->execute();
                                    $staff = $query->rowCount();
                                ?>
                                <p><?php echo htmlentities($staff)?></p>
                            </div>
                        </div>
                    </a>

                    <div class="top_card">
                        <div class="card_left">
                            <h4>Admins</h4>
                            <p>Total admins</p>
                        </div>
                        <div class="card_total">
                            <?php
                                $sql = "SELECT id FROM admin ";
                                $query = $dbh->query($sql);
                                $admin = $query->rowCount();
                            ?>
                            <p><?php echo htmlentities($admin)?></p>
                        </div>
                    </div>

                    <!-- <div class="last_card">
                        
                    </div> -->
                </div>
                <!-- top cards -->

                <!-- INCOME CONTAINER -->
                <div class="income_wrapper">
                    <div class="income_left">
                        <!-- todo -->
                        <div class="income_side_top">
                            <div class="todo_top">
                                <h3>To do List</h3>

                                <div id="comp_loader" class="task_loading">
                                    <div class='view_loader'>
                                        <div></div>
                                        <div></div>
                                        <div></div>
                                    </div>
                                </div>
                            </div>

                            <div class="todo_tab_toggle">
                                <button id="defaultTodoOpen" class="todo_links" onclick="openTodo(event , 'todo_incomplete');">Incomplete</button>
                                <button class="todo_links" onclick="openTodo(event , 'todo_complete')">Completed</button>
                            </div>


                            <!-- todo incomplete and add task -->
                            <div id="todo_incomplete" class="todo_content">
                                <form id="to_do_list" method="post" enctype="multipart/">
                                    <div class="todo_form">
                                        <input type="text" name="task" placeholder="Add task here">
                                    </div>

                                    <input  style="display: none" type="text" name="username" value="<? echo $_SESSION['alogin']; ?>">

                                    <div class="todo_form">
                                        <button class="todo_btn" onclick="javascript:addTask();">
                                            Add&nbsp;Task
                                            <img id="todo_loader" src="assets/images/blank.gif">
                                        </button>
                                    </div>
                                </form>

                                <div id="task_view" class="task_view">                               
                                    <!-- task here -->                                
                                </div> 
                            </div>
                            <!-- ///todo incomplete and add tasks///-->

                            <!-- todo complete -->
                            <div id="todo_complete" class="todo_content">
                                <div id="comp_view" class="comp_view">
                                    <!-- completed tasks here -->
                                    here
                                </div>
                            </div>
                            <!-- ///todo complete/// -->

                        </div>
                        <!-- todo -->                        

                        <div class="income_side_btm">
                            <button id="defaultUploadOpen" class="income_links canvas_side" onclick="openIncome(event, 'fees')">
                            Fees</button>
                            <button class="income_links canvas_side" onclick="openIncome(event, 'expenses')">
                            Expenses</button>
                            <button class="income_links canvas_side" onclick="openIncome(event, 'income')">Income</button>                            
                            <button class="income_links canvas_side" onclick="openIncome(event, 'budget')">Budget</button>
                        </div>                        
                    </div>

                    <div class="income_container">

                        <div id="fees" class="income_content">
                            <div class="income_top">
                                <span>
                                    <h2>Fees Payment this year (<?php echo date("Y");?>)</h2>
                                    <button id="toggle_income">
                                        Toggle
                                        <i class="fa fa-chevron-down"></i>
                                    </button>
                                </span>
                                
                                <p class="title">
                                    View payments by clicking 
                                    <a style="color: var(--bg-purple);" href="student/fees.php">
                                        HERE
                                    </a>
                                </p>
                            </div>

                            <?php require 'includes/feeData.php';?>

                            <div class="income_desc">
                                <div class="income_detail">
                                    <h3 style="color: var(--yellow);">
                                        Ksh <?php echo number_format($to_pay) ;?>
                                    </h3>
                                    <p>Total Amount Allocated</p>
                                </div>
                                <div class="income_detail">
                                    <h3 style="color: var(--success);">
                                        Ksh <?php echo number_format($total_paid) ;?>
                                    </h3>
                                    <p>Total Paid (<?php echo sprintf('%0.2f', round($percent_paid,2 ));?>%)</p>
                                </div>
                                <div class="income_detail">
                                   <h3 style="color: var(--danger);">Ksh <?php echo number_format($arrears) ;?></h3>
                                    <p>Total Not Paid (<?php echo sprintf('%0.2f', round($percent_arrears,2 ));?>%)</p> 
                                </div>
                            </div>
                            <!-- CHART PLOTING FROM DB FOR FEE PAYMENT PER CLASS -->
                            
                            <div id="fee_chart" class="chart_box">
                                <canvas id="feeChart"></canvas>
                            </div>
                        </div>

                        <div id="expenses" class="income_content">
                            <div class="income_top">
                                <span>
                                    <h3>Expenses for <? echo $year; ?></h3>
                                    <a href="expenses.php"><button id="toggle_income">
                                        <i class="fa fa-add"></i>
                                        Add Expenses                                    
                                    </button></a>
                                </span>
                            </div>

                            <div class="income_desc">
                                <div class="income_detail">
                                   <h3>Ksh 56,000</h3>
                                    <p>Total Expenses</p> 
                                </div>
                                <div class="income_detail">
                                    <h3>Ksh 456,890</h3>
                                    <p>Total Revenue</p>
                                </div>
                            </div>

                            <!-- CHART PLOTING FROM DB -->
                            <div class="chart_box">
                                <canvas id="myChart"></canvas>
                            </div>
                        </div>

                        <div id="income" class="income_content">
                            <div class="income_top">
                                <h3>Income for Jun 2022</h3>
                            </div>
                            <div class="income_desc">
                                <div class="income_detail">
                                    <h3>Ksh 245,000</h3>
                                    <p>Total Income</p>
                                </div>
                                <div class="income_detail">
                                    <h3>Ksh 165,250</h3>
                                    <p>Total Profit</p>
                                </div>
                            </div>
                            <!-- CHART PLOTING FROM DB -->
                            <div class="chart_box">
                                <canvas id="incomeChart"></canvas>
                            </div>
                        </div>                       

                        <div id="budget" class="income_content chart_box">
                            <canvas id="budgetChart"></canvas>
                        </div>

                        <!-- calendar -->
                        <div style="margin-top: 10px" class="timeline_info">
                            <div  id="calendar"></div>
                        </div>
                    </div>                    
                </div>
                <!-- //income wrapper -->
                
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div id="editModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Search System
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <!-- FILTER CLASSES FOR THE  STUDENT -->
                <div class="edit_all_container">
                    <div class="edit_group">
                        <label>Search</label>
                        <select id="sdt_class" onclick="getStudent(this.options[this.selectedIndex].value)">
                            <option value="" selected>--Select Student--</option>
                        </select>
                    </div>
                </div>
                <!-- FILTER CLASSES FOR THE  STUDENT -->

                <!-- FILTERED DATA APPEARS HERE -->
                <div id="filtered" class="filtered_data">
                    <!-- filtered data here -->
                </div>
                <!-- SUBMIT BUTTON -->
                <div class="edit_btn">
                    <button class="btn" type="submit" id="editProf" onclick="editProfile();">
                        <i class="fa fa-add"></i>
                        Search
                        <img id="search_loader" src="assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>

    
    <script src="assets/js/jquery-3.6.0.js"></script>         
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>    
    <script src="assets/js/chartData.js"></script>
    <script src="assets/fullcalendar/lib/moment.min.js"></script>
    <script src="assets/fullcalendar/fullcalendar.min.js"></script>
    

    <script type="text/javascript">
         // Get the element with id="defaultUploadOpen" and click on it
        document.getElementById("defaultUploadOpen").click();
        document.getElementById("defaultTodoOpen").click();

        // FUNCTION OPEN TODO FILE
        function openTodo(e, todoName) {

            var i, todocontent, todolinks;

            todocontent = document.getElementsByClassName("todo_content");

            for (i = 0; i < todocontent.length; i++) {

                todocontent[i].style.display = "none";

            }

            todolinks = document.getElementsByClassName("todo_links");

            for (i = 0; i < todolinks.length; i++) {
                todolinks[i].className = todolinks[i].className.replace(" active", "");
            }
            document.getElementById(todoName).style.display = "block";
            e.currentTarget.className += " active";
         
        }
        // FUNCTION OPEN TODO FILE

        function todoView() {
            let todo_cntnr = document.getElementById("task_view");
            let err = document.getElementById("error");
            let suc = document.getElementById("success");
            let test = 0;
            let output = '';

            let todoXhr = new XMLHttpRequest;


            todoXhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#comp_loader").show();

                }

                if (this.readyState == 4 && this.status == 200) {

                    $("#comp_loader").hide();
                    
                    let data = todoXhr.response;
                    

                    if (data !== null && data !== undefined && data !== "") {

                        let data = JSON.parse(this.responseText);

                        for(let item of data){

                            output += `                               

                                <div class="task">
                                    <p>${item.task}</p>
                                    <button value='${item.id}' onclick="javascript:todoComplete(this.value);">
                                        Mark
                                    </button>
                                </div>
                            `;
                        }
                    }else{

                        output += `
                            <div class="task">
                                <p>Nothing to show in todo-list. Add a task in the field above!</p>
                            </div>
                        `;
                    }

                    todo_cntnr.innerHTML = output;

                }
            }
            todoXhr.open('POST', 'includes/todo_view.php');
            todoXhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            todoXhr.send("test="+test);           
        }

        function todoViewComplete() {
            let todo_comp_cntnr = document.getElementById("comp_view");
            let err = document.getElementById("error");
            let suc = document.getElementById("success");
            let test = 1;
            let comp_output = '';

            let todo_comp_xhr = new XMLHttpRequest;


            todo_comp_xhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#comp_loader").show();

                }

                if (this.readyState == 4 && this.status == 200) {

                    $("#comp_loader").hide();
                    
                    let data = todo_comp_xhr.response;
                    

                    if (data !== null && data !== undefined && data !== "") {

                        let data = JSON.parse(this.responseText);

                        for(let item of data){

                            comp_output += `                               

                                <div class="task">
                                    <p>${item.task}</p>
                                    <i class='fa fa-check'></i>
                                </div>
                            `;
                        }
                    }else{

                        comp_output += `
                            <div class="task">
                                <p>Nothing to show in todo-list. Nothing in completed tasks!</p>
                            </div>
                        `;
                    }

                    todo_comp_cntnr.innerHTML = comp_output;

                }
            }
            todo_comp_xhr.open('POST', 'includes/todo_view.php');
            todo_comp_xhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            todo_comp_xhr.send("test="+test); 

        }

        $(document).ready(function(){
            let calendar = $('#calendar').fullCalendar({
                editable: false,
                displayEventTime: true,
                responsive: true
               
            });

            $("#todo_loader").hide();
            $("#comp_loader").hide();

            todoView();
            todoViewComplete();
        });

        function todoComplete(value) {
            let err = document.getElementById("error");
            let suc = document.getElementById("success");
            let t_id = document.querySelectorAll(".todo_id");

            let id = value;

            let todoCompXhr = new XMLHttpRequest;


            todoCompXhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#comp_loader").show();

                }

                if (this.readyState == 4 && this.status == 200) {

                    $("#comp_loader").hide();
                    
                    let data = todoCompXhr.response;                    

                    if (data !== null && data !== undefined && data !== "") {

                        let data = JSON.parse(this.responseText);

                         for(let item of data){

                            suc.textContent = item.true;
                            suc.style.display = "block";
                            err.style.display = "none";
                         }

                        todoView();
                        todoViewComplete();

                    }else{

                        err.textContent = "Unable to mark complete on that task!";
                        err.style.display = "block";
                        suc.style.display = "none";
                    }

                }
            }
            todoCompXhr.open('POST', 'includes/todo_comp.php');
            todoCompXhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            todoCompXhr.send("comp_id="+id); 

        }

        

        

        function getModal() {
            // Get the modal
            var modal = document.getElementById("editModal");

            // Get the button that opens the modal
            var search = document.getElementById("search");

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks the button, open the modal 
              modal.style.display = "block";
            

            // When the user clicks on <span> (x), close the modal
            span.onclick = function() {
              modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function(event) {
              if (event.target == modal) {
                modal.style.display = "none";
              }
          }
        }


        function addTask(){
            let todo_form = document.getElementById("to_do_list");
            let err = document.getElementById("error");
            let suc = document.getElementById("success");

            todo_form.onsubmit = (e) => {
                e.preventDefault();
            }

            let todoXhr = new XMLHttpRequest;

            todoXhr.onreadystatechange = function() {
                if (this.readyState !== 'complete') {

                    $("#todo_loader").show();
                    
                }

                if (this.readyState === XMLHttpRequest.DONE) {
                    $("#todo_loader").hide();

                    if (todoXhr.status == 200) {
                        // let response = todoXhr.response;
                        let response = JSON.parse(this.responseText);

                        if (response !== undefined && response !== null && response !== "") {
                            
                            for(let item of response){
                                if ( item.status == "true") {

                                    //call todoView to reload the list
                                    todoView();

                                    suc.textContent = item.message;
                                    suc.style.display = "block";
                                    err.style.display = "none";
                                    err.style.display = "none";
                                    clearForm();                            

                                }else{
                                    err.textContent = item.message;
                                    err.style.display = "block";
                                    suc.style.display = "none";
                                    suc.style.display = "none";
                                }
                            }
                        }else{
                            err.textContent = "Response is null or undefined!";
                            err.style.display = "block";
                        }
                    }else{
                        err.textContent = "Server responded with a status of 404!";
                        err.style.display = "block";
                    }
                }
            }

            todoXhr.open("POST", "includes/todo.php");
            let todoFormData = new FormData(todo_form);
           
            todoXhr.send(todoFormData);
        }


        // toggle income container
        function incomeHidden() {

            return localStorage.getItem("income-hidden");

        }

        function toggleIncomeView() {

            cont = document.querySelector("#fee_chart");

            cont.classList.toggle("fee_chart_active");

        }

        function checkLocalStorage() {
            if (incomeHidden()) {
                localStorage.removeItem("income-hidden");
            }else{
                localStorage.setItem("income-hidden", "set");
            }
        }

        if (incomeHidden()) {
            toggleIncomeView();
        }

        document.getElementById("toggle_income").addEventListener('click', () => {
            toggleIncomeView();
            checkLocalStorage();
        });



        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
        function clearForm() {
            // sessionStorage.clear();
            $('#to_do_list').trigger("reset");
            // console.log("session cleared");
        }
    </script>

    <? require 'includes/chartData.php'; ?>
    


</body>
</html>

<?php 
// print_r($feeClassArray);

    }
}
?>