<?php
session_start();
error_reporting(E_ALL);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $suc = NULL;
        $error = NULL;
        // $create = $_GET['create'];
        $fgId = $_GET['fee_group_id'];
        $clId = $_GET['fee_cluster_id'];
        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }
         
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Allocate Fee for the students.</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
    <script>
        if ( window.history.replaceState ) {
            window.history.replaceState( null, null, window.location.href );
        }
    </script>
</head>

<body>
    <!-- <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div> -->
    
    <!-- //Status Wrap -->
    <?php if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?></div><?php }elseif ($error) {?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }?>
    <!-- //status Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="errRemove();" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="pendRemove();" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa-solid fa-coins"></i>
                <h3>Fees Edit</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, edit fees settings!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span>
                        <a href="dashboard.php">
                            <i class="fa-solid fa-home"></i> Home
                        </a>
                    </span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- ALLOCATE FEE -->
            <div class="student_container">
                <!-- body -->
                <div class="promote_container">
                    <div class="promote_header">
                        <h3>Select Criteria</h3>
                    </div>
                    <div class="promote_content">

                        <div class="select_group">
                            <label>Select Term</label>
                            <code>Select term to allocate for this year &mdash; <? echo $year; ?></code>
                            <select id="list_term" name="term">

                                <option disabled selected>--Select Term--</option>
                                <?

                                $termSQL = "SELECT id,term, year FROM tbl_term WHERE year = :y ORDER BY id ASC";
                                $termQuery =$dbh->prepare($termSQL);
                                $termQuery->execute(array(':y' => $year));
                                $termResult = $termQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($termResult)) {
                                    foreach ($termResult as $key => $val) {
                                ?>
                                <option value="<?php echo $val->term; ?>">
                                    [Term<?php echo $val->term; ?>] -
                                    <?php echo $val->year; ?>
                                </option>

                                <?php }}?>
                            </select>
                        </div>

                        <div class="select_group">
                            <label>Select Class</label>
                            <code>Select class to allocate for.</code>
                            <select id="list" onchange="getSelected(this.options[this.selectedIndex].value);">

                                <option disabled selected>--Select Class--</option>


                                <?php 
                                $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                                $classQuery =$dbh->prepare($classSQL);
                                $classQuery->execute();
                                $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($classResult)) {
                                    foreach ($classResult as $key => $value) {
                                        // code...
                                ?>
                                <option value="<?php echo $value->cid; ?>">
                                    <?php echo $value->class_name; ?>
                                </option>
                                <?php }}?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="student_list">
                    <div class="student_list_header">
                        <h3>
                            <a href="">
                                <label>Select All</label>
                                <input type="checkbox" name="check_all">
                            </a>
                        </h3>
                    </div>
                    <form id="allocateForm" method="post" action="" enctype="multipart/form-data">
                        <div style="display:none;">
                            <input type="text" value="<? echo $fgId;?>" name="fee_group_id">
                            <input type="text" value="<? echo $clId;?>" name="cluster_id">
                        </div>
                        <table id="student-list-allocate" class="display table">

                            <thead>
                                <tr>
                                    <td>Adm No</td>
                                    <td>Name</td>
                                    <td>Class</td>
                                    <td>Status</td>                                
                                    <td>SELECT</td>
                                </tr>
                            </thead>
                            <!-- TABLE BODY -->
                            <tbody class="classRow">
                                <!-- AJAX content here -->
                            </tbody>                        
                        </table>
                        <div class="allocate_container">
                            <button id="allocateBtn" type="submit" onclick="allocateAjax();"  name="allocate_fee">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                <p id="ajax_text">Allocate</p>
                                <img id="ajax_loader" src="assets/images/blank.gif">
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>   

    <script>
        $(document).ready(function(){
            $("#ajax_loader").hide();

            let allocateTable = $("#student-list-allocate").DataTable();

            $("#list").change(function() {
                allocateTable.draw();
            });
        });
        function getSelected(value) {

            let classFilter = value;
            let container = document.querySelector(".classRow");
            let allocateTable = $("#allocate-table").dataTable();

            let http = new XMLHttpRequest();

            http.onload = function() {
                if (this.readyState == 4 && this.status == 200) {

                    let response = JSON.parse(this.responseText);
                    let output = "";

                    if (response === null) {
                        output += `
                            <tr class = "odd">
                                <td valign="top" colspan="5" class= "dataTables_empty">
                                    No student data for this class!
                                </td>
                            </tr>
                        `;
                    }else{     



                        for(let item of response) {
                            output += `
                                <tr>
                                    <td>${item.Admission_No}</td>
                                    <td>${item.First_Name} ${item.Last_Name}</td>
                                    <td>${item.class_name}</td>
                                    <td>${item.Status}</td>
                                    <td class='atd_status'>
                                        <label>
                                            <input value='${item.s_id}' type='checkbox' name='allocate[]'>
                                            <span>
                                                <i class="fa-solid fa-check"></i>
                                                <p>Allocate</p>
                                            </span>
                                        </label>
                                    </td>
                                </tr>      
                                
                            `;
                        }
                        
                    }   
                    container.innerHTML = output;                     
                    
                }
                
            }

            http.open("POST", "includes/script.php");
            http.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            http.send("classId="+classFilter);           
        }

        function allocateAjax() {

            const form = document.querySelector("#allocateForm"),
            btn =  document.querySelector("#allocateBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");
            pendText = document.querySelector("#pending");

            sms = $('#allocateBtn').val();

            form.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let alctXhr = new XMLHttpRequest(); //creating xml object

            alctXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                  $("#ajax_text").hide();
                }

                if (alctXhr.readyState === XMLHttpRequest.DONE) {
                    $("#ajax_loader").hide();
                    $("#ajax_text").show();
                    if (alctXhr.status === 200) {                     

                        let response = JSON.parse(this.responseText);
                        if (response !== undefined && response !== null && response !== "") {

                            for(let item of response){
                                if (item.status == "true") {
                                    pendText.textContent = item.message;
                                    pendText.style.display = "block";
                                    errorText.style.display = "none";
                                    sucText.style.display = "none";
                                    clearForm();
                                }else{
                                    errorText.textContent = item.message;
                                    errorText.style.display = "block";
                                    sucText.style.display = "none";
                                }
                            }                            
                        }else{
                            errorText.textContent = "Response is null or undefined!";
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                    }
                }
            }
            
  

            alctXhr.open("POST", "includes/allocate.php");
            let alctFormData = new FormData(form);
           
            alctXhr.send(alctFormData);

        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function pendRemove() {
            pend = document.querySelector('#pending');

            pend.style.display = "none";
        }
        function clearForm() {
            // sessionStorage.clear();
            $('#allocateForm').trigger("reset");
            // console.log("session cleared");
        }
        
    </script>

    

</body>
</html>

<?php 
// print_r($student);
    }
} 
?>