<?php
session_start();
error_reporting(E_ALL);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        $suc = NULL;
        $error = NULL;
        $create = $_GET['create'];
        $year = date("Y");

        if (isset($_POST['save_group'])) {
            $group = $_POST['group_name'];
            $detail = $_POST['detail'];

            $feeGroup = "SELECT * FROM fee_group WHERE :g = group_name";
            $gQuery = $dbh->prepare($feeGroup);
            $gQuery->bindParam(':g', $group, PDO::PARAM_STR);
            $gQuery->execute();
            $res = $gQuery->fetchAll(PDO::FETCH_OBJ);
            $gCnt = $gQuery->rowCount() > 0;

            if ($gCnt) {
                $error = "Fees Group With this name - $group, already exists!";
            }else{
                $insertGroup = "INSERT INTO fee_group(group_name, description)
                VALUES(:g, :d)";
                $insertG = $dbh->prepare($insertGroup);
                $insertG->bindParam(':g', $group, PDO::PARAM_STR);
                $insertG->bindParam(':d', $detail, PDO::PARAM_STR);
                $insertG->execute();
                $lastInsert = $dbh->lastInsertId();
                if ($lastInsert) {
                    $suc = "Fee group inserted successfully";
                }else{
                    $error = "Something is not right! Check the fields and try again.";
                }
            }

        }elseif (isset($_POST['create_cluster_name'])) {
            $name = $_POST['cluster_name'];
            $desc = $_POST['desc'];
            $amount = $_POST['amount'];
            $n_g = $_POST['name_group'];

            $nameInsert = "INSERT INTO fee_cluster(cluster_name, description, amount, fee_group_id, year)VALUES(:fn, :dsc, :am, :fg, :y)";
            $insertQ = $dbh->prepare($nameInsert);
            $insertQ->bindParam(':fn', $name, PDO::PARAM_STR);
            $insertQ->bindParam(':dsc', $desc, PDO::PARAM_STR);
            $insertQ->bindParam(':am', $amount, PDO::PARAM_STR);
            $insertQ->bindParam(':fg', $n_g, PDO::PARAM_STR);
            $insertQ->bindParam(':y', $year, PDO::PARAM_STR);
            $insertQ->execute();
            $lastInsertQ = $dbh->lastInsertId();

            if ($lastInsertQ) {
                $suc = "Fee cluster created successfully";
            }else{
                $error = "Something is wrong! check the fields and try again";
            }
        }elseif(isset($_GET['group_del'])){
            $g_del = $_GET['group_del'];

            $g_del_sql = "DELETE FROM fee_group WHERE id = :gid";
            $gQ = $dbh->prepare($g_del_sql);
            $gQ->execute(array(
                ':gid' => $g_del
            ));
            $gRes = $gQ->fetchAll(PDO::FETCH_OBJ);
            if ($gQ->rowCount() > 0) {
                $suc = "Fee Group deleted successfully";
                header("Refresh:2; url=fee-edit.php?create=fee-group");
            }else{
                $error = "Something is wrong! Try again later";
                header("Refresh:2; url=fee-edit.php?create=fee-group");
            }
        }elseif(isset($_GET['fee_cluster_del'])){
            $c_del = $_GET['fee_cluster_del'];

            $c_del_sql = "DELETE FROM fee_cluster WHERE id = :cid";
            $cQ = $dbh->prepare($c_del_sql);
            $cQ->execute(array(
                ':cid' => $c_del
            ));
            $cRes = $cQ->fetchAll(PDO::FETCH_OBJ);
            if ($cQ->rowCount() > 0) {
                $suc = "Fee cluster deleted successfully";
                header("Refresh:2; url=fee-edit.php?create=fee-name");
            }else{
                $error = "Something is wrong! Try again later";
                header("Refresh:2; url=fee-edit.php?create=fee-name");
            }
        }
         
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Getting started with the acedemics</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
    <script>
        if ( window.history.replaceState ) {
            window.history.replaceState( null, null, window.location.href );
        }
    </script>
</head>

<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>
    
    <!-- //Status Wrap -->
    <?php if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?></div><?php }elseif ($error) {?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }?>
    <!-- //status Wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa-solid fa-coins"></i>
                <h3>Fees Edit</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, edit fees settings!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span>
                        <a href="dashboard.php">
                            <i class="fa-solid fa-home"></i> Home
                        </a>
                    </span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- CREATE INITIALIZATION -->
            <div class="student_container">
                <div class="upload_container">
                    <?php if ($create == 'fee-group') {?>
                    <!-- ====ACADEMIC YEAR==== -->
                    <div id="acd_y" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Create Fee Group</h2>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Group Name</label>
                                        <code>Fee group will help allocate fee for different section of the school: example: Grade-1 to Grade-2...</code>
                                        <input placeholder="eg. fees per term.." type="text" name="group_name" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Description</label>
                                        <input placeholder="Enter a detail for this grop..." type="text" name="detail" required>
                                    </div>

                                    <button type="submit" name="save_group">
                                        <i class="fa-solid fa-plus"></i>Save
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <p class="title">
                                <a href="fee-edit.php?create=fee-name">
                                    <button class="btn">
                                        Add Cluster Name
                                        <i class="fa-solid fa-arrow-right-long"></i>
                                    </button>
                                </a>
                            </p>
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>Group Name</td>
                                            <td>Description</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $gName = "SELECT * FROM fee_group";
                                        $gQuery = $dbh->prepare($gName);
                                        $gQuery->execute();
                                        $gRes = $gQuery->fetchAll(PDO::FETCH_OBJ);
                                        $gCnt = $gQuery->rowCount() > 0 ;
                                        if ($gCnt) {
                                            foreach ($gRes as $key => $val) {
                                            
                                        ?>
                                        <tr>                                            
                                            <td><?php echo $val->group_name;?></td>
                                            <td><?php echo $val->description;?></td>
                                            <td class="td_icons">
                                                <a class="delete" onclick="return confirm('Are you sure you want to delete this fee group?');" href="?group_del=<?php echo $val->id; ?>">
                                                    Delete
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </td>                                       
                                        </tr>
                                        <?php }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- //====ACADEMIC YEAR==== -->
                    <?php }elseif ($create == 'fee-name') {?>
                    <!-- ====ACADEMIC TERM==== -->
                    <div id="acd_t" class="upload_content">
                        <!-- UPLOAD CONTENT LEFT -->
                        <div class="fee_content_left">
                            <div class="timeline_info learning_content">
                                <h2>Add Cluster Name</h2>
                                <form id="form" action="" method="post">
                                    <div class="upload_group">
                                        <label>Fee Cluster</label>
                                        <code>Enter fee cluster, example Mid-School, Pre-School...</code>
                                        <input placeholder="Fee name..." type="text" name="cluster_name" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Description</label>
                                        <input placeholder="Description"  type="text" name="desc" required>
                                    </div>
                                    <div class="upload_group">
                                        <label>Amount</label>
                                        <input placeholder="eg. 2,000" type="text" name="amount" required>
                                    </div>

                                    <div class="upload_group">
                                        <label>Fee Group</label>
                                        <select name="name_group">
                                            <?php
                                             $fee_group = "SELECT id,group_name FROM fee_group";
                                             $groupQuery = $dbh->prepare($fee_group);
                                             $groupQuery->execute();
                                             $groupResult = $groupQuery->fetchAll(PDO::FETCH_OBJ);
                                             $groupCnt = $groupQuery->rowCount() > 0;
                                             if ($groupCnt) {
                                                 foreach ($groupResult as $key => $val) {
                                                     
                                            ?>
                                            <option value="<?php echo $val->id;?>">
                                                <?php echo $val->group_name;?>
                                            </option>
                                            <?php }}?>
                                        </select>
                                    </div>


                                    <button type="submit" name="create_cluster_name">
                                        <i class="fa-solid fa-plus"></i>Save Type
                                    </button>
                                </form>
                            </div>
                        </div>
                        <!-- UPLOAD CONTENT LEFT -->

                        <!-- UPLOAD CONTENT RIGHT -->
                        <div class="fee_content_right">
                            <div class="top">
                                <p class="title">
                                    <a href="fee-edit.php?create=fee-group">
                                        <button class="btn">
                                            <i class="fa-solid fa-arrow-left-long"></i>
                                             Fee Group                                       
                                        </button>
                                    </a>
                                </p>
                                <p class="title">
                                    <a href="fee_structure.php">
                                        <button class="btn">
                                            <i class="fa fa-eye"></i>
                                            Fee Structure
                                        </button>
                                    </a>
                                </p>
                            </div>
                            <div class="timeline_info">
                                <table id="student-list" class="display">
                                    <thead>
                                        <tr>
                                            <td>Fee Group</td>
                                            <td>Fee Cluster</td>
                                            <td>Description</td>
                                            <td>Amount</td>
                                            <td>Action</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                       $gRes = "SELECT fee_cluster.*,fee_cluster.fee_group_id as fid, fee_group.group_name FROM fee_cluster JOIN fee_group ON fee_cluster.fee_group_id = fee_group.id ORDER BY id";
                                       $gQ = $dbh->prepare($gRes);
                                       $gQ->execute();
                                       $gRes = $gQ->fetchAll(PDO::FETCH_OBJ);
                                       $gCnt = $gQ->rowCount() > 0;
                                       if ($gCnt) {
                                            foreach ($gRes as $key => $val) {
                                                
                                       ?>
                                        <tr>                                           
                                           <td><?php echo $val->group_name;?></td>
                                           <td><?php echo $val->cluster_name;?></td>
                                           <td><?php echo $val->description;?></td>
                                           <td><?php echo $val->amount;?></td>
                                           <td class="td_icons">
                                               <a class="delete" onclick="return confirm('Are you sure you want to delete this fee cluster?');" href="?fee_cluster_del=<?php echo $val->id; ?>">
                                                    Delete
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                           </td>
                                           
                                        </tr>
                                        <?php }}?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <!-- //====ACADEMIC TERM==== -->
                    <?php }?>
                    

                    
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>   

    <script>
        $(function() {
        $( "#start_date" ).datepicker();
        $( "#end_date" ).datepicker();

        });

        // logic for displaying unique content from hash
        $(function() {
        var Div1 = $('#acd_y');
        var Div2 = $('#acd_t');

        if (location.hash === "#year") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div1).removeClass('c_h').siblings().addClass('upload_content');
            }, 1);

        } else if (location.hash === "#term") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div2).removeClass('c_h').siblings().addClass('upload_content');
            }, 1);

        } else if (location.hash === "#Show_Div3") {
            setTimeout(function() {
                window.scrollTo(0, 0);
                $(Div3).removeClass('is-visuallyhidden').siblings().addClass('is-visuallyhidden');
            }, 1);

        }
        });

    </script>

    

</body>
</html>

<?php 
// print_r($create);
    }
} 
?>