<?php
session_start();
// error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $suc = NULL;
        $error = NULL;

        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fee Structure</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="assets/fullcalendar/fullcalendar.min.css" />
</head>
<script>
    if ( window.history.replaceState ) {
      window.history.replaceState( null, null, window.location.href );
    }
</script>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>
    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-coins"></i>
                <h3>Fee Structure</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, view fee structure!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Fee Structure</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- FEE STRUCTURE INFORMATION -->
            <div class="student_container">
                <div class="upload_container">

                    <div class="upload_top">
                        <a href="fee-edit.php?create=fee-group">
                            <button class="btn">
                                <i class="fa-solid fa-arrow-left-long"></i>
                                 Create Fee Group                                       
                            </button>
                        </a>
                        <a href="fee-edit.php?create=fee-name">
                            <button class="btn">
                                <i class="fa-solid fa-arrow-left-long"></i>
                                Create Fee Name                                      
                            </button>
                        </a>
                    </div>

                    <div class="timeline_info">
                        <p class="title">
                            Print the fee structure for review
                        </p>
                        <table id="student-list" class="display">
                            <thead>
                                <tr>
                                    <td>Fee Group</td>
                                    <td>Fee Cluster</td>
                                    <td>Description</td>
                                    <td>Amount</td>
                                    <td>Action</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                               $gRes = "SELECT fee_cluster.*,fee_cluster.id as fid, fee_group.group_name FROM fee_cluster JOIN fee_group ON fee_cluster.fee_group_id = fee_group.id ORDER BY id";
                               $gQ = $dbh->prepare($gRes);
                               $gQ->execute();
                               $gRes = $gQ->fetchAll(PDO::FETCH_OBJ);
                               $gCnt = $gQ->rowCount() > 0;
                               if ($gCnt) {
                                    foreach ($gRes as $key => $val) {
                                        
                               ?>
                                <tr>                                           
                                   <td>
                                    <?php echo $val->group_name;?>                                       
                                   </td>
                                   <td><?php echo $val->cluster_name;?></td>
                                   <td><?php echo $val->description;?></td>
                                   <td><?php echo number_format($val->amount);?></td>
                                   <td>
                                       <p class="edit ">
                                           <a class="success" href="fee-allocate.php?fee_group_id=<?php echo $val->fee_group_id;?>&fee_cluster_id=<?php echo $val->fid;?>">
                                               <i class="fa-solid fa-plus"></i> Allocate
                                           </a>

                                           <a class="delete" href="">
                                               <i class="fa-solid fa-trash "></i> Deallocate                                          
                                           </a>

                                       </p>
                                   </td>
                                   
                                </tr>
                                <?php }}?>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>
    
    
    <script src="assets/js/jquery-3.6.0.js"></script>         
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  
    <script src="assets/fullcalendar/lib/moment.min.js"></script>
    <script src="assets/fullcalendar/fullcalendar.min.js"></script>
    <script src="assets/js/calendar.js"></script>  
    
    <script type="text/javascript">

    </script>
</body>
</html>

<?php }}?>