<?php
require '../../config.php';

 if (isset($_POST['create_class'])) {
    $class = $_POST['class_name'];

    $insertClass = "INSERT INTO tbl_class(class_name) VALUES(:c)";
    $iQ = $dbh->prepare($insertClass);
    $iQ->bindParam(':c', $class, PDO::PARAM_STR);
    $iQ->execute();

    $lastInsertId = $dbh->lastInsertId();
    if ($lastInsertId) {
        $statusMsg = "You created a class called ".$class."";
    }else{
        $error = "Something Went wrong! Check the fields and try again";
    }

}elseif(isset($_POST['create_subjects'])){
    $sbj = $_POST['sbj_name'];

    $insertSbj = "INSERT INTO subjects(subject_name)VALUES(:s)";
    $sbjQ = $dbh->prepare($insertSbj);
    $sbjQ->bindParam(':s', $sbj, PDO::PARAM_STR);
    $sbjQ->execute();

    $lastInsertId = $dbh->lastInsertId();
    if ($lastInsertId) {
        $statusMsg = "You successfully created a subject called ".$sbj."";
    }else{
        $error = "System could not create subjcet! Check the fields and try again";
    }
}elseif (isset($_POST['create_term'])) {
    $term = $_POST['term'];
    $sDate = $_POST['s_date'];
    $eDate = $_POST['e_date'];

    $checkDup = "SELECT term FROM tbl_term WHERE term = :t";
    $checkQ = $dbh->prepare($checkDup);
    $checkQ->execute(array(
        ':t' => $term
    ));
    $checkRes = $checkQ->fetchAll(PDO::FETCH_OBJ);
    if ($checkQ->rowCount() > 0) {
        $error = "Duplicate term! You already have a term named ".$term."";
    }else{
        $insertTerm = "INSERT INTO tbl_term(term, start_date, end_date, year)VALUES(:t, :sd, :ed, :y)";
        $tQ = $dbh->prepare($insertTerm);
        $tQ->execute(
            array(
                ':t'=> $term, 
                ':sd'=> $sDate, 
                ':ed'=> $eDate,
                ':y'=> $year
            )
        );
        $lI = $dbh->lastInsertId();
        if ($lI) {
            $statusMsg = "Term for year ".$year." created successfully";
        }else{
            $error = "could not create term, ckeck you fields and try again";
        }
    }            
}elseif (isset($_POST['create_role'])) {
    $role = $_POST['role'];

    $insertRole = "INSERT INTO tbl_roles(role, year)
    VALUES(:r, :y)";
    $rQ = $dbh->prepare($insertRole);
    $rQ->execute(array(
        ':r'=> $role,
        'y'=> $year
    ));
    $inserted = $dbh->lastInsertId();
    if ($inserted) {
        $statusMsg = "You have successfully created a role called ".$role."";
    }else{
        $error = "This role ".$role." could not be inserted, try again!";
    }
}elseif (isset($_POST['create_section'])) {
    $section = $_POST['section'];
    $class = $_POST['class'];

    $insertSection = "INSERT INTO sections(section_name, class)
    VALUES(:sn, :c)";
    $sQ = $dbh->prepare($insertSection);
    $sQ->execute(array(
        ':sn' => $section,
        ':c' => $class
    ));
    $inserted = $dbh->lastInsertId();
    if ($inserted) {
        $statusMsg = "You have successfully created a section called ".$section." for ".$class."";
    }
}elseif(isset($_GET['c_del'])) {
    $c_id = $_GET['c_del'];

    $del_class = "DELETE FROM tbl_class WHERE tbl_class.id = :cd";
    $cQ = $dbh->prepare($del_class);
    $cQ->execute(array(
        ':cd' => $c_id
    ));
    $d_res = $cQ->fetchAll(PDO::FETCH_OBJ);
    if ($cQ->rowCount() > 0) {
        $statusMsg = "Class deleted successfully";
        header("Refresh:2; url=create-init.php?create=class");

    }else{
        $error = "Something went wrong!";
    }
}elseif (isset($_GET['t_del'])) {
    $t_del = $_GET['t_del'];

    $del_term = "DELETE FROM tbl_term WHERE tbl_term.id = :td";
    $tQ = $dbh->prepare($del_term);
    $tQ->execute(array(
        ':td' => $t_del
    ));
    $t_res = $tQ->fetchAll(PDO::FETCH_OBJ);
    if ($tQ->rowCount() > 0) {
        $statusMsg = "Term Deleted successfully";
        header("Refresh:2; url=create-init.php?create=term");
    }
}    


?>