<?php

$sql = "SELECT 
student_fee.fee_cluster_id,
student_fee.student_id,
student_fee.student_id,
fee_cluster.year, 
SUM(fee_cluster.amount) as amt_p 
FROM fee_cluster 
JOIN student_fee 
ON fee_cluster.id = student_fee.fee_cluster_id 
WHERE fee_cluster.year = :y and student_fee.year = :y
GROUP BY student_fee.student_id
";

$query = $dbh->prepare($sql);
$query->bindParam(':y', $year, PDO::PARAM_STR);
$query->execute();
$result = $query->fetchAll(PDO::FETCH_OBJ);
if ($query->rowCount() > 0) {
    foreach ($result as $key => $val) {
        //total payable amount for a single student
        $total_payable = $val->amt_p;
        $year = date("Y");

        //select count all the students
        $get_st_total = "SELECT DISTINCT COUNT(student_fee.student_id) as st_id FROM student_fee WHERE year = :y";
        $st_q = $dbh->prepare($get_st_total);
        $st_q->execute(array(':y' =>$year));
        $st_r = $st_q->fetchAll(PDO::FETCH_OBJ);
        if($st_q->rowCount() > 0){
            foreach ($st_r as $key => $row) {   
                //all the total number of students                                   
                 $stid = $row->st_id;
             } 
        }

    }
}else{
    $total_payable = 0;
    $stid = 0;
}



// get balance  in the balances table
$get_bal = "SELECT sum(amount) as bal_amount, term, year, student_id FROM balances WHERE year = :y";
$balQ = $dbh->prepare($get_bal);
$balQ->execute([':y' =>$year]);
$bal_res = $balQ->fetchAll(PDO::FETCH_OBJ);

if ($balQ->rowCount() > 0 ) {

    foreach($bal_res as $key => $bal) {
        $last_bal = $bal->bal_amount;
    }
}

// get miscellaneous
$get_msc = "SELECT sum(amount) as msc_amount, term, year, student_id FROM miscellaneous WHERE year = :y";
$mscQ = $dbh->prepare($get_msc);
$mscQ->execute([':y' =>$year]);
$msc_res = $mscQ->fetchAll(PDO::FETCH_OBJ);

if ($mscQ->rowCount() > 0 ) {

    foreach($msc_res as $key => $msc) {
        $last_msc = $msc->msc_amount;
    }
}

//sum all the amount that has been paid so far
$get_paid = "SELECT payment_year, SUM(amount_paid) as paid_ampt FROM fee_receipt WHERE payment_year = :y";
$paid_q = $dbh->prepare($get_paid);
$paid_q->bindParam(':y', $year, PDO::PARAM_STR);
$paid_q->execute();
$paid_res = $paid_q->fetchAll(PDO::FETCH_OBJ);
$paid = $paid_q->rowCount() > 0;
if (!empty($paid)) {
    foreach ($paid_res as $key => $paid_val) {
        //calculate percentage paid
        $total_paid = $paid_val->paid_ampt;

        //all maths done here
        $to_pay = ($total_payable * $stid) + $last_bal + $last_msc;
        //tota percentage paid
        if (!empty($total_paid || $to_pay)) {
            $percent_paid = ($total_paid / $to_pay) * 100;
            //total amount that has yet to paid
            $arrears = $to_pay - $total_paid;
            //arrears percentage
            $percent_arrears = $arrears / $to_pay * 100;
        }else{
            $percent_paid = 0;
            $arrears = 0;
            $percent_arrears = 0;
        }
        
        
    }
        
}else{
    //all maths done here
    $to_pay = 0;
    //tota percentage paid
    $percent_paid = 0;
    //total amount that has yet to paid
    $arrears = 0;
    //arrears percentage
    $percent_arrears = 0;
}

// class count
$class_count = "SELECT COUNT(id) as dis_class FROM student WHERE disabled = 0 group by Class";
$count_query = $dbh->prepare($class_count);
$count_query->execute();
$count_result = $count_query->fetchAll(PDO::FETCH_OBJ);
$class_cnt = $count_query->rowCount() > 0;

if ($class_count) {
    foreach ($count_result as $key => $count_val) {
        //total students per class
        $std_count[] = $count_val->dis_class;
    }
}

//fee structure query
$sql = "SELECT fee_cluster.year,student_fee.year, student_fee.fee_cluster_id, SUM(fee_cluster.amount) as to_pay_amt FROM student_fee JOIN fee_cluster ON fee_cluster.id = student_fee.fee_cluster_id WHERE student_fee.year = :y and fee_cluster.year = :y";
$query = $dbh->prepare($sql);
$query->bindParam(':y', $year, PDO::PARAM_STR);
$query->execute();
$result = $query->fetchAll(PDO::FETCH_OBJ);
$row_cnt = $query->rowCount() > 0;

if ($row_cnt) {
    foreach ($result as $key => $s_val) {
        //total amount to be paid
        $to_pay_amt = $s_val->to_pay_amt;
    }
}

//fee chart query
$fee_chart = "SELECT fee_receipt.student_id, 
SUM(fee_receipt.amount_paid) AS class_amount,
fee_receipt.payment_year,
student.Class_Id,
tbl_class.class_name,
tbl_class.id,
count(DISTINCT fee_receipt.student_id) as std_id,
student.id
FROM fee_receipt 
RIGHT JOIN student ON fee_receipt.student_id = student.id
RIGHT JOIN tbl_class ON student.Class_Id = tbl_class.id
WHERE fee_receipt.payment_year = :y
GROUP BY tbl_class.id";

$fee_chart_q = $dbh->prepare($fee_chart);
$fee_chart_q->bindParam(':y', $year, PDO::PARAM_STR);
$fee_chart_q->execute();
$fee_chart_reslt = $fee_chart_q->fetchAll(PDO::FETCH_OBJ);
$fee_chart_cnt = $fee_chart_q->rowCount();

if ($fee_chart_cnt) {
    foreach ($fee_chart_reslt as $key => $fee_val) {
        
        //values                                    
        $fee_std_id = $fee_val->std_id;
        $fee_amount = $fee_val->class_amount;

        // calculations
        $required_amount = $to_pay_amt * $fee_std_id ;

        //all that is required to plot a chart
        $feePercentArray[] = $fee_amount;//($fee_amount / $required_amount) * 100;

        if (!empty($fee_val->Class_Id)) {
            $feeClassArray[] = $fee_val->class_name;
        }else{
            $feeClassArray[] = 0;
        }

    }
}else{
    $fee_class[] = 0;
    $feeClassArray[] = 0;
    $feePercentArray[] = 0;
}

// $feePerClass = "SELECT FROM 
// tbl_class.id, 
// tbl_class.class_name, 
// sum(fee_receipt.amount_paid) as amount_per_class,
// fee_receipt.student_id,
// fee_receipt.payment_year,
// student.id,
// student.Class_Id
// ";

function checkWhichClass() {

}
?>