<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }



?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Item Category</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Item Category</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="assets/images/icons/list.svg">Item List</p>        

                    <div class="top_action">
                        <button title="Add item category" id="catBtn" class="btn" title="Edit" >
                            <i class="fa-solid fa-plus"></i>
                        </button>
                    </div>
                </div>

                <div class="upload_content">
                    <div class="fee_content_left">
                        <div class="timeline_info">
                            <h3 style="color:var(--bg-purple);">Add Item</h3>

                            <div class="category">
                                <form id="itemForm">
                                    <div class="category_group">
                                        <label>Item Name</label>
                                        <p class="title">* Examples include: pencils, books etc.</p>
                                        <input type="text" id="item_name" placeholder="name of the item">
                                    </div>
                                    <div class="category_group">
                                        <label>Select Item Category</label>
                                        <select type="text" id="item_cat">
                                            <option value="">* Item Category *</option>
                                            <?php 
                                            $fetchItemCat = "SELECT * FROM inventory_category order by id";
                                            $fetchQ = $dbh->prepare($fetchItemCat);
                                            $fetchQ->execute();
                                            $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);                                     
                                            $cnt = 1;
                                            if ($ItemCatCnt = $fetchQ->rowCount() > 0) {
                                                foreach ($res as $key => $r) {
                                            ?>
                                            <option value="<? echo $r->id?>"><? echo $r->category_name; ?></option>
                                            <? }} ?>
                                        </select>
                                    </div>

                                    <div class="category_group">
                                        <label>Select Item Supplier</label>
                                        <select type="text" id="item_supplier">
                                            <option value="">* Item supplier *</option>
                                            <?php 
                                            $fetchItemSupplier = "SELECT * FROM suppliers order by id";
                                            $fetchQ = $dbh->prepare($fetchItemSupplier);
                                            $fetchQ->execute();
                                            $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);                                     
                                            $cnt = 1;
                                            if ($ItemSupplierCnt = $fetchQ->rowCount() > 0) {
                                                foreach ($res as $key => $r) {
                                            ?>
                                            <option value="<? echo $r->id?>">
                                                Contact: <? echo $r->contact_person; ?> &mdash; Company: <? echo $r->company_name; ?>
                                            </option>
                                            <? }} ?>
                                        </select>
                                    </div>

                                    <div class="category_group">
                                        <label>Quantity</label>
                                        <input type="number" id="item_quantity" placeholder="number oof items">
                                    </div>

                                    <div class="category_group">
                                        <label>Description</label>
                                        <p class="title">* Simple dscription of the item.</p>
                                        <input type="text" id="item_desc" placeholder="details about the item">
                                    </div>

                                    <div class="category_group">
                                        <button onclick="addItem();">
                                            <i class="fa fa-check"></i>
                                            Save
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="fee_content_right">
                        <div class="timeline_info">
                            <table id="student-list" class="display">
                                <thead>
                                    <tr>
                                        <td>#</td>
                                        <td>Item&nbsp;Name</td>
                                        <td>Category</td>
                                        <td>Supplier</td>
                                        <td>Quantity</td>
                                        <td>Details</td>
                                        <td>Action</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $fetchInventory = "SELECT inventory.*, inventory_category.*, suppliers.* FROM inventory JOIN inventory_category ON inventory.category_id = inventory_category.id JOIN suppliers ON suppliers.id = inventory.supplier_id order by inventory.id";
                                    $fetchQ = $dbh->prepare($fetchInventory);
                                    $fetchQ->execute();
                                    $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);                                    
                                    $cnt = 1;
                                    if ($fetchQ->rowCount() > 0) {
                                        foreach ($res as $key => $r) {
                                    ?>
                                    <tr id="<? echo $r->id; ?>">
                                        <td><?php echo $cnt; ?></td>
                                        <td class="row_data"><?php echo $r->inventory_name; ?></td>
                                        <td class="row_data"><?php echo $r->category_name; ?></td>
                                        <td class="row_data"><?php echo $r->company_name; ?></td>
                                        <td class="row_data" style="font-weight: 800;">
                                            <? if($r->quantity > 10){ ?>
                                                <p style="color: var(--success);"><? echo $r->quantity; ?></p>
                                            <? }else{?>
                                                <p style="color: var(--danger);"><? echo $r->quantity; ?> &mdash; Reorder</p>
                                            <?}?>
                                        </td>
                                        <td class="row_data"><?php echo $r->details; ?></td>
                                        <!-- action -->
                                        <td>
                                            <p class="student_edit">
                                                <a style="font-weight: 700;" class="edit" onclick="javascript:reorder();">                                                           
                                                    Reorder
                                                </a>

                                                <button title="Minus One from the Quantity" class="edit" onclick="itemRemove(this.value)" value="<?php echo $r->id; ?>">
                                                    <i class="fa fa-minus"></i>
                                                </button>

                                                <button title="Delete these items" class="delete" onclick="itemDelete(this.value)" value="<?php echo $r->id; ?>">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </p>
                                        </td>
                                    </tr>

                                    <?php $cnt += 1; }}?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            </div>
        </div>
    </div>

    <!-- item category modal -->
    <div id="catModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Add Items Category</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="catForm">

                    <div class="pay_group">
                        <label>Category Name</label>
                        <input id="cat_name" type="text" />
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:addCategory();" id="import_btn">
                            Save Category
                            <img id="item_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <div id="reorder_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Ordering...</p>
    </div>

    <div id="cat_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Adding...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  

    <script>

        $(document).ready(function(){

            $("#fancy_loader").hide();
            $("#cat_fancy_loader").hide();
            $("#student_loader").hide();
            $("#ajax_loader").hide();
            $("#teacher_t").hide();
            $("#class_t").hide();
            $("#reorder_loader").hide();


        });

        // Get the modal
        let cat_modal = document.getElementById("catModal");

        // Get the button that opens the modal
        var cat_btn = document.getElementById("catBtn");

        // Get the <span> element that closes the modal
        var cat_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        cat_btn.onclick = function() {
          cat_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        cat_span.onclick = function() {
          cat_modal.style.display = "none";
        }


        function addItem() {
            let suc = document.querySelector("#success"),
            item_form = document.querySelector("#itemForm");

            err = document.querySelector("#error");

            item_form.onsubmit = (e) => { e.preventDefault() }

            let inventory_name = $("#item_name").val();
            let category = $("#item_cat").val();
            let details = $("#item_desc").val();
            let quantity = $("#item_quantity").val();
            let supplier = $("#item_supplier").val();

            let data = { inventory_name, category, details, quantity, supplier }

                //ajax
            $.ajax({
                url: 'includes/add-inventory.php',
                method: 'POST',
                data: data,
                success: function(data) {  

                    let res = JSON.parse(data);                  

                    if (res.status == true) 
                    {
                        suc.textContent = res.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else 
                    {
                        err.textContent = res.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#cat_fancy_loader").show();

                }, 
                complete: function() {

                    $("#cat_fancy_loader").hide();

                }
            });
        }


        function addCategory() {

            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");
            cat_form = document.querySelector("#catForm");

            err = document.querySelector("#error");

            cat_form.onsubmit = (e) => { e.preventDefault() }

            let category_name = $("#cat_name").val();

            let data = { category_name }

                //ajax
            $.ajax({
                url: 'includes/add-inventory-category.php',
                method: 'POST',
                data: data,
                success: function(data) {  

                    let res = JSON.parse(data);                  

                    if (res.status == true) 
                    {
                        suc.textContent = res.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else 
                    {
                        err.textContent = res.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#cat_fancy_loader").show();

                }, 
                complete: function() {

                    $("#cat_fancy_loader").hide();

                }
            });

        }


        function reorder() {

            let proceed = confirm('Are you sure you want to reorder this item?');

            // let rowId = event.target.parentNode.parentNode.id;

              //this gives id of tr whose button was clicked
                // let row_data = document.getElementById(rowId).querySelectorAll(".row_data"); 
              /*returns array of all elements with 
              "row-data" class within the row with given id*/

                // let qty = data[0].innerHTML;
                // let item = data[1].innerHTML;
                // let contact_person = data[2].innerHTML;
                // let supplier = data[2].innerHTML;

                // alert("Name: " + qty + "\nAge: " + item);

            if (proceed) {

                let suc = document.querySelector("#success"),
                err = document.querySelector("#error");

                // let item_id = value;
                let item = 'Pens'
                let order_qty = '20 packets of';
                let contact_person = 'Martin Ndirangu';
                let supplier_phone = '0792498144';


                let data = { order_qty, item, contact_person, supplier_phone }

                $.ajax({
                    url: 'includes/reorder.php',
                    method: 'POST',
                    data: data,
                    success: function (data) {
                        //response

                        let response = JSON.parse(data);

                        if (response.status == true ) {

                            suc.textContent = response.message;
                            suc.style.display = 'block';
                            err.style.display = 'none'

                        }else{

                            err.textContent = response.message;
                            err.style.display = 'block';
                            suc.style.display = 'none'
                        }
                    },
                    beforeSend: function () {
                        
                        $('#reorder_loader').show();

                    },
                    complete: function () {

                        $('#reorder_loader').hide();

                    }
                });


            }
        }
       
    </script>
    
</html>

<?php }}?>