<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }



?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lesson Plan</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Lesson Plan</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="assets/images/icons/list.svg">Lesson Plan</p>        

                    <div class="top_action">
                        <button id="my_modal_btn" class="btn" title="Edit" >
                            <i class="fa-solid fa-plus"></i>
                        </button>
                    </div>
                </div>

                <div class="upload_content">
                    <div class="fee_content_left">
                        <div class="timeline_info">
                            <h3 style="color:var(--bg-purple)">Add Lesson Plan</h3>

                            <div class="category">
                                <form id="lessonPlan">
                                    <div class="category_group">
                                        <label>Lesson Name</label>
                                        <input type="text" id="lesson_name">
                                    </div>
                                    <div class="category_group">
                                        <label>Title</label>
                                        <input type="text" id="title">
                                    </div>
                                    <div class="category_group">
                                        <label>Subject</label>
                                        <select id="subject">
                                            <option value="">--Choose Subject--</option>
                                                <?php 
                                                $sbj = "SELECT id as sbj_id, subject_name FROM subjects";
                                                $sbj_query = $dbh->prepare($sbj);
                                                $sbj_query->execute();
                                                $sbj_res = $sbj_query->fetchAll(PDO::FETCH_OBJ);
                                                $sbj_cnt = $sbj_query->rowCount() > 0;

                                                if ($sbj_query) {
                                                    foreach ($sbj_res as $key => $sbj_val) {


                                                ?>
                                                <option value="<?php echo $sbj_val->sbj_id; ?>"><?php echo $sbj_val->subject_name; ?>
                                                </option>
                                                <?php }}?>
                                        </select>
                                    </div>
                                    <div class="category_group">
                                        <label>Teacher</label>
                                        <select id="teacher">
                                            <option value="">--Choose Teacher--</option>
                                            <?php 
                                                $tchrs = "SELECT id as ts_id, first_name, last_name FROM staff where role = 'Teacher'";
                                                $tchrs_query = $dbh->prepare($tchrs);
                                                $tchrs_query->execute();
                                                $tchrs_res =  $tchrs_query->fetchAll(PDO::FETCH_OBJ);
                                                $tchrs_cnt = $tchrs_query->rowCount() > 0;

                                                if ($tchrs_cnt) {
                                                    foreach ($tchrs_res as $key => $tc_val) {

                                                ?>
                                                <option value="<?php echo $tc_val->ts_id; ?>"><?php echo $tc_val->first_name; ?>&nbsp;<?php echo $tc_val->last_name; ?>
                                                </option>
                                                <?php }}
                                            ?>
                                        </select>
                                    </div>
                                    <div class="category_group">
                                        <button onclick="addLessonPlan();">
                                            <i class="fa fa-check"></i>
                                            Save Lesson Plan
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="fee_content_right">
                        <div class="timeline_info">
                            <table id="student-list" class="display">
                                <thead>
                                    <tr>
                                        <td>#</td>
                                        <td>Title</td>
                                        <td>Lesson Name</td>
                                        <td>Subject</td>
                                        <td>Teacher</td>
                                        <td>Action</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $fetchLessonPlan = "SELECT lesson_plan.*,subjects.*, staff.* FROM lesson_plan JOIN subjects ON lesson_plan.subject = subjects.id JOIN staff ON lesson_plan.teacher = staff.id order by lesson_plan.id";
                                    $fetchQ = $dbh->prepare($fetchLessonPlan);
                                    $fetchQ->execute();
                                    $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);
                                    
                                    $cnt = 1;
                                    if ($LessonPlanCnt = $fetchQ->rowCount() > 0) {
                                        foreach ($res as $key => $r) {
                                    ?>
                                    <tr>
                                        <td>#<?php echo $cnt; ?></td>
                                        <td><?php echo $r->title; ?></td>
                                        <td><?php echo $r->lesson_name; ?></td>
                                        <td><?php echo $r->subject_name; ?></td>
                                        <td><?php echo $r->first_name; ?> <? echo $r->last_name; ?></td>
                                        <td>
                                            <p class="student_edit">
                                                <a class="delete" onclick="return confirm('Are you sure you want to delete this lesson plan?');" href="?t_del=<?php echo $r->id; ?>">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </p>
                                        </td>
                                    </tr>

                                    <?php $cnt += 1; }}?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            </div>
        </div>
    </div>



    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <div id="cat_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Adding...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  

    <script>

        $(document).ready(function(){

            $("#fancy_loader").hide();
            $("#cat_fancy_loader").hide();
            $("#student_loader").hide();
            $("#ajax_loader").hide();
            $("#teacher_t").hide();
            $("#class_t").hide();


        });

        function addLessonPlan() {

            let lesson_plan_form = document.querySelector("#lessonPlan");
            let err = document.querySelector("#error");
            let suc = document.querySelector("#success");

            let lesson_name = $("#lesson_name").val();
            let title = $("#title").val();
            let subject = $("#subject").val();
            let teacher = $("#teacher").val();

            let data = { lesson_name, title, subject, teacher }

            lesson_plan_form.onsubmit = (e) => { e.preventDefault();}

            // ajax
            $.ajax({
                url: 'includes/lesson-plan.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    if (response.status == true) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else{

                        err.textContent = response.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#cat_fancy_loader").show();

                },
                complete: function() {

                    $("#cat_fancy_loader").hide();

                }
            });
        }
       
    </script>
    
</html>

<?php }}?>