<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View My Profile</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="assets/fullcalendar/fullcalendar.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="pendRemove();" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->


    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <img src="assets/images/icons/home.svg">
                <h3>My Profile Account</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query -> fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, welcome to admin profile!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>View Profile </span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">            
                <div class="profile_container">
                    <div class="profile_left">
                        <div class="profile_top">
                            <img src="assets/images/5.jpg">
                        </div>
                        <div class="profile_image">
                            <img src="assets/images/icons/profile.svg">
                        </div>
                        <div class="profile_details_left">
                            <?php 
                                $username = $_SESSION['alogin'];
                                $sql = "SELECT * FROM admin WHERE username = :username";
                                $query = $dbh->prepare($sql);
                                $query->bindParam(':username', $username, PDO::PARAM_STR);
                                $query->execute();
                                $results = $query -> fetchAll(PDO::FETCH_OBJ);
                                if ($query->rowCount() > 0) {
                                    foreach ($results as $key => $result) {

                            ?>                            
                            <span><h3>Role on System</h3><p>Super Admin</p></span>
                            <span><h3>Name</h3>
                                <p>
                                    <?php echo htmlentities($result->f_name);?>&nbsp;
                                    <?php echo htmlentities($result->l_name);?>
                                </p>
                            </span>       
                            <span><h3>Location</h3>
                                <p><?php echo htmlentities($result->Residence);?></p>
                            </span>                 
                        </div>
                    </div>
                    <div class="profile_right">
                        <div class="personal_info">
                            <div class="tab">
                                <div class="tabs_left">
                                    <button id="defaultOpen" class="tab_links" onclick="openProfile(event, 'profile')">Profile</button>
                                    <button class="tab_links" onclick="openProfile(event, 'documents')">Documents</button>
                                    <button class="tab_links" onclick="openProfile(event, 'timeline')">Timeline</button>
                                </div>
                                <div class="tabs_right">
                                    <button class="btn" id="profileBtn" onclick="javascript:profileEdit();">
                                        <i class="fa fa-edit"></i>
                                        Edit
                                    </button>
                                </div>
                            </div>

                            <!-- PROFILE  -->
                            <div id="profile" class="tab_content profile_content">
                                <h4>Personal Information</h4>
                                <div class="profile_details_t">
                                    <span><h3>First Name</h3>
                                        <p><?php echo htmlentities($result->f_name);?></p>
                                    </span>
                                    <span><h3>Last Name</h3>
                                        <p><?php echo htmlentities($result->l_name);?></p>
                                    </span>
                                    <span><h3>Role on system</h3><p>Super Admin</p></span>
                                    <span><h3>Gender</h3>
                                        <p><?php echo htmlentities($result->Gender);?></p>
                                    </span>
                                    <span><h3>Employee No</h3>
                                        <p><?php echo htmlentities($result->Emp_no);?></p>
                                    </span>
                                    <span><h3>Residence</h3>
                                        <p><?php echo htmlentities($result->Residence);?></p>
                                    </span>
                                    <span><h3>Enrollment Date</h3>
                                        <p><?php echo htmlentities($result->login_date);?></p>
                                    </span>                                    
                                </div>
                            </div>
                            <!-- DOCUMENTS-->
                            <div id="documents" class="tab_content profile_content">
                                <h4>My Documents</h4>
                                <div class="documents_info">
                                    <span><h3>Profile Image</h3><img src="assets/images/icons/profile.svg"></span>
                                    <span><h3>Other</h3><p> No records</p></span>
                                </div>
                            </div>
                            <!-- TIMELINE-->
                            <div id="timeline" class="tab_content profile_content">
                                <h4>My Timeline</h4>
                                <div class="timeline_info">
                                    Nothing to show in the timeline.
                                </div>
                            </div>
                            <?php 
                                    }
                                }
                            ?> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- profile edit -->
    <!-- The Modal -->
    <div id="myModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php echo $result->f_name; ?> 
                <?php echo $result->l_name; ?>'s &mdash; Profile Info!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editAdmin" method="post" enctype="multipart/form-data">
                <div class="edit_container">
                    <div class="edit_group">
                        <label>Admin First Name</label>
                        <input value="<?php echo $result->f_name; ?> " type="text" name="f_name" >
                    </div>

                    <div class="edit_group">
                        <label>Admin Last Name</label>
                        <input value="<?php echo $result->l_name; ?> " type="text" name="l_name" >
                    </div>

                    <div class="edit_group">
                        <label>Admin Username</label>
                        <input value="<?php echo $result->username; ?> " type="text" name="username" >
                    </div>

                    <div class="edit_group">
                        <label>Gender</label>
                        <input value="<?php echo $result->Gender; ?>" type="text" name="gender" >
                    </div>

                    <div class="edit_group">
                        <label>Residence</label>
                        <input value="<?php echo $result->Residence; ?>" type="text" name="residence" >
                    </div>
                    <div class="edit_group">
                        <label>Phone</label>
                        <input value="<?php echo $result->phone; ?>" type="text" name="phone" >
                    </div>
                    <div class="edit_group">
                        <label>Email</label>
                        <input value="<?php echo $result->email; ?>" type="email" name="email" >
                    </div>

                </div>
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editAdminProfile();">
                        <i class="fa fa-add"></i>
                        Update Admin
                        <img id="admin_loader" src="../assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>
    
    
    <script src="assets/js/jquery-3.6.0.js"></script>         
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  
    <script src="assets/fullcalendar/lib/moment.min.js"></script>
    <script src="assets/fullcalendar/fullcalendar.min.js"></script>
    <script src="assets/js/calendar.js"></script>
    
    <script type="text/javascript">
         // Get the element with id="defaultOpen" and click on it
        document.getElementById("defaultOpen").click();

        // Get the modal
        var modal = document.getElementById("myModal");

        // Get the button that opens the modal
        var btn = document.getElementById("profileBtn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
        }


        // editAdminProfile()

        function editAdminProfile() {

            let admin_form = document.querySelector("#editAdmin");
            let suc = document.querySelector("#success");
            let err = document.querySelector("#error");

            admin_form.onsubmit = (e) => {
                e.preventDefault();
            }

            let adminXhr = new XMLHttpRequest;

            adminXhr.onreadystatechange = function () {
                if (this.readyState !== 'complete') {
                    $("#admin_loader").show();
                }

                if (this.readyState === XMLHttpRequest.DONE) {
                    $("#admin_loader").hide();

                    if (adminXhr.status == 200) {

                        // let response = adminXhr.response;
                        let data = JSON.parse(this.responseText);

                        if (data !== null && data !== undefined && data !== "") {

                            for(let item of data){                        

                                if (item.status == "true") {
                                    suc.textContent = item.message;
                                    suc.style.display = "block";
                                    err.style.display = "none";

                                }else{
                                    err.textContent = item.message;
                                    err.style.display = "block";
                                    suc.style.display = "none";
                                }
                            }
                        }else{
                            err.textContent = "Response is null or undefined!";
                            err.style.display = "block";
                        }
                    }else{
                        err.textContent = "Server responded with a status of 404!";
                        err.style.display = "block";
                    }
                }
            }

            adminXhr.open("POST", "includes/admin_profile.php");
            let adminData = new FormData(admin_form);
            adminXhr.send(adminData);
        }

        function errRemove() {

            let err = document.querySelector('#error');            

            err.style.display = "none";
        }
        function sucRemove() {

            suc = document.querySelector('#success');

            suc.style.display = "none";
        }

    </script>
</body>
</html>

<?php }}?>