<?php
session_start();
// error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $error = null;
        $suc = null;

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }


        if (isset($_GET['del'])) {
            $id = $_GET['del'];
            $filter_id = $_GET['filter_id'];

            $del_rec = "DELETE FROM student WHERE id=:id; 
                        DELETE FROM fee_receipt WHERE student_id = :id";
            $del_query = $dbh->prepare($del_rec);
            $del_query->bindParam('id', $id, PDO::PARAM_STR);
            $del_query->execute();
            $del_res = $del_query->fetchAll(PDO::FETCH_OBJ);
            $del_cnt = $del_query->rowCount() > 0;

            if ($del_cnt) {
                $suc = "Student with ID of $id has been deleted successfully";
                header("Refresh:2; url=collect-fee.php");
            }else{
                $error = "SOMETHING WENT WRONG";
            }
        }

        
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Collect Fee for all the classes.</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">

    <script>
    if ( window.history.replaceState ) {
      window.history.replaceState( null, null, window.location.href );
    }
    </script>

</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif">COLLECT FEE LOADING...
    </div>

    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <img src="../assets/images/icons/students.svg">
                <h3>Collect Fee</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, student list!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="../dashboard.php">Dashboard</a> | </span>
                    <span>Collect Money</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="../assets/images/icons/list.svg">All Students</p>

                    <ul class="actions_center">
                        <li class="export" name="Export to PDF" export-data-type="pdf"><a href="#"><img src="../assets/images/icons/pdf.svg"></a></li>
                        <li class="export" name="Export to CSV" export-data-type="csv"><a href="#"><img src="../assets/images/icons/csv.svg"></a></li>
                        <li class="upload"  import-data-type="db"><a href="#"><img name="Save Table data" src="../assets/images/icons/db.svg"></a></li>
                    </ul>

                    <button id="editBtn" class="btn">
                        <i class="fa fa-edit"></i>
                        Collect Fee
                    </button>

                </div>

                <div class="student_list">
                    <table id="student-list" class="display table">
                        <thead>
                            <tr>
                                <td>Adm No</td>
                                <td>Name</td>
                                <td>Class</td>
                                <td>Section</td>
                                <td>Gender</td>
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- TBODY //TABLE ROW  -->
                            <?php
                                $r_id = 0;
                                $r_id_c_f = 2; 
                                
                                $sql = "SELECT student.*, tbl_class.class_name FROM student JOIN tbl_class ON tbl_class.id = student.Class_Id ORDER BY id DESC";
                                $query = $dbh->prepare($sql);
                                $query->execute();
                                $results = $query->fetchAll(PDO::FETCH_OBJ);
                                $cnt = 1;
                                if ($query->rowCount() > 0) {
                                     foreach ($results as $result) {
                                         // code...

                                ?>
                            <tr>
                                <td><?php echo htmlentities($result->Admission_No);?></td>
                                <td>
                                    <?php echo htmlentities($result->First_Name);?>&nbsp;
                                    <?php echo htmlentities($result->Last_Name);?>&nbsp;
                                    <?php echo htmlentities($result->Surname);?>
                                </td>
                                <td><?php echo htmlentities($result->class_name);?></td>
                                <td><?php echo htmlentities($result->Section);?></td>
                                <td><?php echo htmlentities($result->Gender);?></td>
                                <td>
                                    <p class="student_edit">
                                        <a id="myBtn" style="color: #222; font-weight: 700;" class="edit" href="student-view.php?s_id=<?php echo $result->id;?>&route_id=<?php echo $r_id_c_f;?>#collect_fees">
                                            Collect&nbsp;Fee
                                            <i class="fa fa-arrow-right"></i>                                      
                                        </a>
                                    </p>
                                </td>        
                            </tr>  
                            <? 
                                    }
                                }

                            ?>
                            <!-- TBODY //TABLE ROW  -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- The Modal -->
    <div id="myModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php //echo $res->First_Name; ?> 
                <?php //echo $res->Last_Name; ?> &mdash; Students Information!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="event_add" method="post" enctype="multipart/form-data">
                <div class="form_group">
                    <input type="text" name="title">
                    <label for="title">Event</label>
                </div>
                <div class="form_group">
                    <input type="date" name="title">
                    <label for="title">Date</label>
                </div>
                <div class="form_group">
                    <input type="text" name="title">
                    <label for="title">Date</label>
                </div>
            </form>
        </div>
      </div>

    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>   

    <script>
        // Get the modal
        // Get the modal
        var modal = document.getElementById("myModal");

        // Get the button that opens the modal
        var btn = document.getElementById("editBtn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
        }
    </script> 

</body>
</html>

<?php }}?>