<?php
session_start();
error_reporting(0);
include('../../includes/config.php');

if(strlen($_SESSION['alogin']) == 0)
    {
    header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $error = NULL;
        $suc = NULL;

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add students</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
</head>

<body>
    <!-- <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div> -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <!-- ajax error_wrap -->
                    
    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-edit"></i>
                <h3>Add Student</h3>
            </div>
            <?php require 'side.php';?>
        </div>
        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, Add student!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>add Student</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="container_top" style="margin-bottom: 10px;">
                    <p><img src="../assets/images/icons/list.svg">Add Student</p>

                    <a href="#">
                        <button id="importBtn">
                            <img src="../assets/images/icons/import.svg">
                            Import Student

                        </button>
                    </a>
                </div>

                <!-- CREATE STUDENT FORM -->
                <div class="create_form">                
                    
                    <form id="sdt_form" action="" method="post" enctype="multipart/form-data" >
                        <div class="content_wrap">
                            <p class="title">
                                Note: Fields marked (<span style="color:red">*</span>) are mandatory!
                            </p>
                            <p class="category">Personal Info:</p>
                            <!-- PERSONAL INFO -->
                            <div class="form_content">
                                <div class="form_group">
                                    <label><span style="color:red">*</span> First Name</label>
                                    <input id="first_name" type="text" name="first_name" placeholder="First Name" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Surname</label>
                                    <input id="surname" type="text" name="surname" placeholder="Surname" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Last Name</label>
                                    <input id="last_name" type="text" name="last_name" placeholder="Last Name" >
                                </div>

                                <!-- <div class="form_group">
                                    <label>Admission No</label>
                                    <input id="adm_no" type="number" name="adm_no" placeholder="Admission No" >
                                </div> -->

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Assessment No</label>
                                    <input id="asmt_no" type="text" name="asmt_no" placeholder="Assessment No">
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Admission Date</label>
                                    <input type="date" name="adm_date" placeholder="MM/DD/YYY" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> UPI No</label>
                                    <input id="upi_no" type="text" name="upi_no" placeholder="UPI No" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> D.O.B</label>
                                    <input type="date" name="dob" placeholder="Date of Birth" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Birth Cert No</label>
                                    <input id="birth_cert_no" type="number" name="birth_cert_no" placeholder="Birth Certificate Entry No" >
                                </div>

                                <div class="form_group">
                                    <label>Residence</label>
                                    <input id="residence" type="text" name="residence" placeholder="Area of Residence" >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Class</label>
                                    <Select id="class" name="class" >
                                        <option disabled>--Select Class--</option>
                                        <?php 
                                        $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                        $query = $dbh->prepare($sql);
                                        $query->execute();
                                        $res = $query->fetchAll(PDO::FETCH_OBJ);
                                        if ($query->rowCount() > 0) {
                                            foreach ($res as $key => $val) {
                                        ?>
                                        <option value="<?php echo $val->id?>"><?php echo $val->class_name;?></option>
                                        <?php }}?>
                                    </Select>
                                </div>

                                <div class="form_group">
                                    <label>Section</label>
                                    <Select id="section" name="section" >
                                        <option disabled>--Select Section--</option>
                                        <option value="Default">Default</option>
                                        <?php 
                                        $sql = "SELECT section_name FROM sections";
                                        $query = $dbh->prepare($sql);
                                        $query->execute();
                                        $res = $query->fetchAll(PDO::FETCH_OBJ);
                                        if ($query->rowCount() > 0) {
                                            foreach ($res as $key => $val) {
                                        ?>
                                        <option value="<?php echo $val->section_name?>"><?php echo $val->section_name;?>
                                            
                                        </option>
                                        <?php }}?>
                                    </Select>
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Gender</label>
                                    <Select id="gender" name="gender" >
                                        <option disabled value="">--Select Gender--</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </Select>
                                </div>
                            </div>
                        </div>

                        <!-- PARENTS/GURDIAN INFO -->
                        <div class="content_wrap">
                            <p class="category">Parent Info:</p>
                            <div class="form_content">

                                <div class="form_group">
                                    <label>Father Name</label>
                                    <input id="parent_first_name" type="text" name="father_name" placeholder="Father full name.." >
                                </div>

                                <div class="form_group">
                                    <label>Mother Name</label>
                                    <input id="parent_last_name" type="text" name="mother_name" placeholder="Mother full name..." >
                                </div>

                                <div class="form_group">
                                    <label>Guardian Name</label>
                                    <input id="guardian_name" type="text" name="guardian" placeholder="Gurdian name (Optional)..." >
                                </div>

                                <div class="form_group">
                                    <label><span style="color:red">*</span> Phone(1)</label>
                                    <p class="title">Note: Primary phone (receive text updates)</p>
                                    <input id="primary_phone" type="number" name="phone" placeholder="Enter primary phone" >
                                </div>

                                <div class="form_group">
                                    <label>Phone(2)</label>
                                    <p class="title">Can receive text updates occasionally.</p>
                                    <input id="sec_phone" type="number" name="sec_phone" placeholder="Optional" >
                                </div>

                                <div class="form_group">
                                    <label>Phone(3)</label>
                                    <p class="title">Can receive text updates occasionally.</p>
                                    <input id="third_phone" type="number" name="third_phone" placeholder="Optional" >
                                </div>

                                <div class="form_group">
                                    <label>Phone(4)</label>
                                    <p class="title">Can receive text updates occasionally.</p>
                                    <input id="fourth_phone" type="number" name="fourth_phone" placeholder="Optional" >
                                </div>

                                <div class="form_group">
                                    <label>Email</label>
                                    <p class="title">Might receive messages if not available from the phone.</p>
                                    <input id="parent_email" type="email" name="parent_email" placeholder="Enter parent email" >
                                </div>

                                <div class="form_group">
                                    <label>Address</label>
                                    <p class="title">Parent's address.</p>
                                    <input id="parent_address" type="text" name="parent_address" placeholder="Enter parent Address" >
                                </div>

                                <div class="form_group">
                                    <label>Additional Notes</label>
                                    <input id="notes" type="text" name="notes" placeholder="Add notes...">
                                </div>
                                
                            </div>
                        </div>

                        <!-- SIBLINGS INFO -->
                        <div class="content_wrap">
                            <p class="category">Select Sibling:</p>
                            <div class="form_content">

                                <div class="form_group">
                                    <label>Select Class</label>
                                    <select onchange="getSelectedClass(this.options[this.selectedIndex].value);">
                                        <option value="">
                                            --Select Class--
                                        </option>
                                        <?php 
                                        $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                                        $query = $dbh->prepare($sql);
                                        $query->execute();
                                        $res = $query->fetchAll(PDO::FETCH_OBJ);
                                        if ($query->rowCount() > 0) {
                                            foreach ($res as $key => $val) {
                                        ?>
                                        <option value="<?php echo $val->id?>">
                                            <?php echo $val->class_name;?>      
                                        </option>
                                        <?php }}?>
                                    </select>
                                </div>

                                <div class="form_group">
                                    <label>Select Sibling</label>
                                    <select id="sibling_list" name="sibling">
                                        <!-- display the students here -->
                                        <option value="">
                                            --Select a student--
                                        </option>
                                    </select>
                                </div>                                
                            </div>
                        </div>

                        <!-- OTHER INFO -->
                        <div class="content_wrap">
                            <p class="category">Document Images:</p>
                            <div class="form_content">
                                <div class="form_group">
                                    <label>
                                        
                                        Student Passport                                        
                                    </label>
                                    <input type="file" name="img1" />
                                </div>

                                <div class="form_group">
                                    <label>
                                        
                                        Birth Cert Image
                                    </label>                                    
                                    <input type="file" name="img2" />
                                </div>                                
                            </div>
                        </div>

                        <!-- FORM BUTTON GROUP -->
                        <div class="btn_group">
                            <!-- <button type="submit" name="st_create">
                                <img src="../assets/images/icons/white/double-tick.svg">Create Student
                            </button> -->

                            <button id="smsBtn" type="submit" onclick="addStudentAjax();"  name="send_sms">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                <p id="ajax_text">Add Student</p>
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </div>
                    </form>    
                </div>
            </div>
        </div>
    </div>


    <!-- Student import modal -->
    <div id="importModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Import Student</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="importStd" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Select File</label>
                        <input id="file" type="file" name="file" accept=".csv" />
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:importStd();" id="import_btn">
                            <i class=""></i>
                            Import Student
                            <img id="std_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- loader -->
    <div id="import_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Importing...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>
    
    <?php include '../includes/footer.php';?>

    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script> 
    <script src="includes/script.js"></script> 

    <script>


        $(document).ready(function() {

            $("#ajax_loader").hide();
            $("#import_loader").hide();
            $("#std_loader").hide();

            $('#sub').click(function() {
                $(this).css('display', 'none');
                $('<img>').attr('src', '../assets/images/blank.gif').insertAfter($(this));
            });
        });


        // Get the modal
        let std_modal = document.getElementById("importModal");

        // Get the button that opens the modal
        var std_btn = document.getElementById("importBtn");

        // Get the <span> element that closes the modal
        var std_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        std_btn.onclick = function() {
          std_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        std_span.onclick = function() {
          std_modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == std_modal) {
            std_modal.style.display = "none";
          }
        }

        function getSelectedClass(value) {

            let selectedClass = value;

            let holdContainer = document.querySelector("#sibling_list");

            let xhr = new XMLHttpRequest();

            xhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#mpesa_fancy_loader").show();

                }
                if (this.readyState == 4 && this.status == 200) {

                    $("#mpesa_fancy_loader").hide();

                    let response = JSON.parse(this.responseText);
                    let output = "";

                    if (response == null) {
                        output += `
                            <option value="">
                                --No students found--
                            </option>
                        `;
                    }else{

                        for(let item of response) {
                            output += `
                                <option value="${item.Admission_No}">
                                    ${item.First_Name} ${item.Last_Name}
                                </option>
                            `;
                        }
                    }

                    holdContainer.innerHTML = output;
                }
            }
            xhr.open("POST", "../includes/script.php");
            xhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            xhr.send("classId="+selectedClass);

        }

        function importStd() {

            let std_form = document.querySelector("#importStd");
            let suc = document.querySelector("#success");
            let err = document.querySelector("#error");


            std_form.onsubmit = (e) => {

                e.preventDefault();

            }

            //ajax 

            $.ajax({
                url: 'includes/import_std.php',
                method: 'POST',
                data: new FormData(std_form),
                contentType:false,          // The content type used when sending data to the server.  
                cache:false,                // To unable request pages to be cached  
                processData:false, 
                success: function(data) {
                    //do something 
                    $.each(JSON.parse(data), function(index, item){

                        if (item.status == 'true') {

                           suc.textContent = item.message;
                            suc.style.display = "block";
                            err.style.display = "none"; 

                        }else if(item.status == 'false'){

                            err.textContent = item.message;
                            err.style.display = "block";
                            suc.style.display = "none";


                        }else{

                            err.textContent = data;
                            err.style.display = "block";
                            suc.style.display = "none";

                        }

                    });
                },
                beforeSend: function() {

                    $("#import_loader").show();
                    $("#std_loader").show();

                },
                complete: function() {
                    //hide loaders 

                    $("#import_loader").hide();
                    $("#std_loader").hide();
                }

            });
        }


        function addStudentAjax() {

            const sdtForm = document.querySelector("#sdt_form"),
            createBtn =  document.querySelector("#createBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");

            sdtForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let sdtXhr = new XMLHttpRequest(); //creating xml object

            sdtXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_text").hide();
                  $("#ajax_loader").show();
                }

                if (sdtXhr.readyState === XMLHttpRequest.DONE) {
                    if (sdtXhr.status === 200) {

                        $("#ajax_loader").hide();
                        $("#ajax_text").show();

                        let response = sdtXhr.response;                        

                        if (response !== undefined && response !== null && response !== "") {
                            if (response == "Student added successfuly!") {

                                sucText.textContent = response;
                                sucText.style.display = "block";
                                errorText.style.display = "none";
                                clearForm();
                                

                            }else{

                                errorText.textContent = response;
                                errorText.style.display = "block";
                                sucText.style.display = "none";
                            }
                            
                            // setTimeout(function(){
                            //   sucText.style.display = "none";
                            // }, 20000000000000); 
                        }else{

                            errorText.textContent = response;
                            errorText.style.display = "block";
                            setTimeout(function(){
                              errorText.style.display = "none";
                            }, 20000); 
                            
                        }
                    }
                }
            }
            
  

            sdtXhr.open("POST", "includes/script.php");
            let sdtFormData = new FormData(sdtForm);           
            sdtXhr.send(sdtFormData);

        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
        function clearForm() {
            sessionStorage.clear();
            $('#sdt_form').trigger("reset");
            console.log("session cleared");
        }

</script>
      
</body>
</html>

<?php }}?>