<?php
session_start();
error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fees Payment</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-coins"></i>
                <h3>Fees Payment</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, view fees!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Fees</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <!-- body -->
                <div class="student_list">
                    <div class="student_list_header">
                        <h2>Students who have paid this year</h2>
                        <button class="btn" onclick="javascript:remindAll();" title="Remind all students to clear balanace">
                            Remind all
                        </button>
                    </div>
                    <table id="student-fee" class="display table">
                        <thead>
                            <tr>
                                <td>Admission No</td>
                                <td>Name</td>
                                <td>Class</td>
                                <td>Section</td>
                                <td>Required</td>
                                <td>Amount Paid</td>
                                <td>Balance</td>                                
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- TBODY //TABLE ROW  -->
                            <?php 
                            $route_h = 1;
                            $route_f = 2;

                            $year = date("Y");       
                                        


                            $sql = "SELECT student.Admission_No,
                                    student.First_Name,
                                    student.Last_Name,
                                    student.Surname,
                                    tbl_class.id,
                                    tbl_class.class_name,
                                    student.Class_Id, 
                                    student.Section,
                                    student.id as sid, 
                                    fee_receipt.student_id, 
                                    SUM(fee_receipt.amount_paid) as paid_ampt, 
                                    fee_receipt.payment_year 
                                    FROM student 
                                    JOIN tbl_class 
                                    ON tbl_class.id = student.Class_Id 
                                    LEFT JOIN fee_receipt 
                                    ON student.id = fee_receipt.student_id 
                                    WHERE fee_receipt.payment_year = :y  
                                    GROUP BY student.id";

                            $query=$dbh->prepare($sql);
                            $query->bindParam(':y', $year, PDO::PARAM_STR);
                            $query->execute();
                            $result = $query->fetchAll(PDO::FETCH_OBJ);
                            if ($result ) {
                                foreach ($result as $key => $val) {

                                    $stid = $val->sid;

                                    // get balance  in the balances table
                                    $get_bal = "SELECT sum(amount) as bal_amount, term, year, student_id FROM balances WHERE student_id = :sid AND year = :y";
                                    $balQ = $dbh->prepare($get_bal);
                                    $balQ->execute([':sid' => $stid, ':y' =>$year]);
                                    $bal_res = $balQ->fetchAll(PDO::FETCH_OBJ);

                                    if ($balQ->rowCount() > 0 ) {

                                        foreach($bal_res as $key => $bal) {
                                            $last_bal = $bal->bal_amount;
                                        }
                                    }

                                    // get miscellaneous
                                    $get_msc = "SELECT sum(amount) as msc_amount, term, year, student_id FROM miscellaneous WHERE student_id = :sid AND year = :y";
                                    $mscQ = $dbh->prepare($get_msc);
                                    $mscQ->execute([':sid' => $stid, ':y' =>$year]);
                                    $msc_res = $mscQ->fetchAll(PDO::FETCH_OBJ);

                                    if ($mscQ->rowCount() > 0 ) {

                                        foreach($msc_res as $key => $msc) {
                                            $last_msc = $msc->msc_amount;
                                        }
                                    }
                                    
                                    $get_total = "SELECT 
                                    student_fee.fee_cluster_id,
                                    student_fee.student_id,
                                    fee_cluster.year, 
                                    SUM(fee_cluster.amount) as amt_p 
                                    FROM fee_cluster 
                                    JOIN student_fee 
                                    ON fee_cluster.id = student_fee.fee_cluster_id 
                                    WHERE fee_cluster.year = :y and student_fee.student_id = :sid and student_fee.year = :y";
                                    $query1 = $dbh->prepare($get_total);
                                    $query1->bindParam(':y', $year, PDO::PARAM_STR);
                                    $query1->bindParam(':sid', $stid, PDO::PARAM_STR);
                                    $query1->execute();
                                    $total = $query1->fetchAll(PDO::FETCH_OBJ);
                                    if ($query1->rowCount() > 0) {
                                        foreach ($total as $key => $amt) {

                                            $amount_to_pay = $amt->amt_p;
                                        }
                                    }else{
                                        $amount_to_pay = 0;
                                    }

                                    $paid = $val->paid_ampt;
                                    //calculations here
                                    //balance first
                                    $bal = ($amount_to_pay - $paid) + $last_bal + $last_msc;
                                    $amount_to_pay = $amt->amt_p + ($last_bal + $last_msc)
                                    
                            ?>
                            <tr>
                                <td><?php echo htmlentities($val->Admission_No);?></td>
                                <td>
                                    <?php echo htmlentities($val->First_Name);?> &nbsp;
                                    <?php echo htmlentities($val->Surname);?> &nbsp;
                                    <?php echo htmlentities($val->Last_Name);?>
                                </td>
                                <td><?php echo htmlentities($val->class_name);?></td>
                                <td><?php echo htmlentities($val->Section);?></td>
                                <td style="font-weight: 700;">
                                    <?php if($amount_to_pay > 0){?>
                                    Ksh <?php echo number_format($amount_to_pay);?>
                                    <?php }else{?>
                                        <a style="color: var(--danger);" href="../fee_structure.php?Allocate-Fee-To-<?php echo htmlentities($val->First_Name);?>-<?php echo htmlentities($val->Last_Name);?>">
                                            Allocate
                                            <i class="fa-solid fa-arrow-right-long"></i>
                                        </a>
                                    <?php }?>
                                </td>
                                <td>
                                    <p style="font-size: 15px;color: var(--white); font-weight: 600;" class="student_edit">Ksh <?php echo number_format($paid);?></p>
                                </td>    
                                <td> 
                                    <?php if($bal > 0){?>
                                    <p style="font-size: 15px;color:var(--danger); font-weight: 600;" class="student_edit">
                                        Ksh&nbsp;<?php echo number_format($bal);?>                               
                                    </p>
                                    <?php }else{?>
                                    <p style="font-size: 15px;color:var(--yellow); font-weight: 600;" class="student_edit">
                                        Ksh&nbsp;<?php echo number_format($bal);?>                               
                                    </p>
                                    <?php }?>
                                </td>                                 
                                <td>
                                    <p class="student_edit">
                                        <a title="View <?php echo htmlentities($val->First_Name);?>-<?php echo htmlentities($val->Last_Name);?>" class="edit" href="student-view.php?s_id=<?php echo htmlentities($val->sid);?>&route_id=<?php echo $route_h;?>#fee_history">
                                            <i class="fa fa-eye" aria-hidden="true"></i>
                                            View
                                        </a>

                                        <a class="delete" href="" title="Remind <?php echo htmlentities($val->First_Name);?>-<?php echo htmlentities($val->Last_Name);?> to clear a balanece of Ksh&nbsp;<?php echo number_format($bal);?>">
                                            Remind
                                        </a>
                                    
                                    </p>

                                </td>     

                            </tr>
                            <?php // code...
                                // }}
                                }
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td>Admission No</td>
                                <td>Name</td>
                                <td>Class</td>
                                <td>Section</td>
                                <td>Required</td>
                                <td>Amount Paid</td>
                                <td>Balance</td>                                
                                <td>Action</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

     <div class="fancy_loader" id="balance_fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Working on it...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>

    <script>

        $(document).ready(function() {

            $("#balance_fancy_loader").hide();

        })
        
        function remindAll() {

            let proceed = confirm('Remind all students to clear their fees balances!');

            if (proceed) {

                let suc = document.querySelector("#success"),
                err = document.querySelector("#error");

                let id = "All";

                let data = { id }

                $.ajax({
                    url: 'includes/fee-balance-remind-all.php',
                    method: 'POST',
                    data: data,
                    success: function (data) {
                        //response

                        let response = JSON.parse(data);

                        if (response.status == true ) {

                            suc.textContent = response.message;
                            suc.style.display = 'block';
                            err.style.display = 'none'

                        }else{

                            err.textContent = response.message;
                            err.style.display = 'block';
                            suc.style.display = 'none'
                        }
                    },
                    beforeSend: function () {
                        
                        $('#balance_fancy_loader').show();

                    },
                    complete: function () {

                        $('#balance_fancy_loader').hide();

                    }
                });
            }

        }
    </script>
</body>
</html>

<?php 
 // print_r(json_encode($amount_to_pay));
}}?>