<?php 

reorder(); 

function reorder() {

	require '../../../includes/config.php';


	/*
		First we get the balances for every student using a loop
		Then get all the neccesary information of each student//
		i.e phone number, and the name of the student

		Using a loop send messages using bongatech for each student with parameter

		* Message
		* Phone
		* Balance is in the message variable

	*/

	$year = date("Y");
	$data = array();

	$sql = "SELECT
	        student.First_Name,
	        student.Last_Name,
	        student.Phone,
	        student.Surname,
	        student.id as sid, 
	        fee_receipt.student_id, 
	        SUM(fee_receipt.amount_paid) as paid_ampt, 
	        fee_receipt.payment_year 
	        FROM student 
	        JOIN tbl_class 
	        ON tbl_class.id = student.Class_Id 
	        LEFT JOIN fee_receipt 
	        ON student.id = fee_receipt.student_id 
	        WHERE fee_receipt.payment_year = :y  
	        GROUP BY student.id";

	$query=$dbh->prepare($sql);
	$query->bindParam(':y', $year, PDO::PARAM_STR);
	$query->execute();
	$result = $query->fetchAll(PDO::FETCH_OBJ);
	if ($result ) {

		// for each student

	    foreach ($result as $key => $val) {

	        $sid = $val->sid;//student id

	        // get balance  in the balances table
	        $get_bal = "SELECT sum(amount) as bal_amount, term, year, student_id FROM balances WHERE student_id = :sid AND year = :y";
	        $balQ = $dbh->prepare($get_bal);
	        $balQ->execute([':sid' => $sid, ':y' =>$year]);
	        $bal_res = $balQ->fetchAll(PDO::FETCH_OBJ);

	        if ($balQ->rowCount() > 0 ) {

	            foreach($bal_res as $key => $bal) {

	            	//get last terms balance for every student
	                $last_bal = $bal->bal_amount;
	            }
	        }

	        // get miscellaneous
	        $get_msc = "SELECT sum(amount) as msc_amount, term, year, student_id FROM miscellaneous WHERE student_id = :sid AND year = :y";
	        $mscQ = $dbh->prepare($get_msc);
	        $mscQ->execute([':sid' => $sid, ':y' =>$year]);
	        $msc_res = $mscQ->fetchAll(PDO::FETCH_OBJ);

	        if ($mscQ->rowCount() > 0 ) {

	            foreach($msc_res as $key => $msc) {

	            	//for each student get the miscellaneous
	                $last_msc = $msc->msc_amount;
	            }
	        }

	        


	        
	        //total amount to be paid by each student
	        $get_total = "SELECT 
	        student_fee.fee_cluster_id,
	        student_fee.student_id,
	        fee_cluster.year, 
	        SUM(fee_cluster.amount) as amt_p 
	        FROM fee_cluster 
	        JOIN student_fee 
	        ON fee_cluster.id = student_fee.fee_cluster_id 
	        WHERE fee_cluster.year = :y and student_fee.student_id = :sid and student_fee.year = :y";
	        $query1 = $dbh->prepare($get_total);
	        $query1->bindParam(':y', $year, PDO::PARAM_STR);
	        $query1->bindParam(':sid', $sid, PDO::PARAM_STR);
	        $query1->execute();
	        $total = $query1->fetchAll(PDO::FETCH_OBJ);
	        if ($query1->rowCount() > 0) {
	            foreach ($total as $key => $amt) {

	                $amount_to_pay = $amt->amt_p;

	            }

	        }else{

	            $amount_to_pay = 0;
	        }

	        $paid = $val->paid_ampt;
	        //calculations here
	        //balance first
	        $amount_to_pay = $amt->amt_p + ($last_bal + $last_msc);
	        $bal = ($amount_to_pay - $paid) + $last_bal + $last_msc;	        

	        // balance
	        $balance = $bal;

	        // store the info each student in a variable

	        $data[] = array(

	        	'student_name' => $val->First_Name .' '. $val->Last_Name .' '. $val->Surname,
	        	'phone' => $val->Phone,
	        	'balance' => $balance 

	        );

	        echo json_encode($data);

	    } //end of the very first foreach
	}	



}