<?php
//check if student id is empty

if (!empty($_POST['student_id'])) {
	
	getPayment();
}


function getPayment() {	

	require_once '../../../includes/config.php';

	$sid = $_POST['student_id'];
	$year = date("Y");
	$payment_per_term = array();
	$other_fee = array();
	$term_bal = array();

	///////////////////////GET LAST TERMS BALANCE/////////////////////////////
	$get_bal = "SELECT sum(amount) as bal_amount, term, year, student_id FROM balances WHERE student_id = :sid AND year = :y";
	$balQ = $dbh->prepare($get_bal);
	$balQ->execute([':sid' => $sid, ':y' =>$year]);
	$bal_res = $balQ->fetchAll(PDO::FETCH_OBJ);

	if ($balQ->rowCount() > 0 ) {

	    foreach($bal_res as $key => $bal) {
	    	//LAST TERMS BALANCE
	        $last_bal = $bal->bal_amount;
	    }
	}

	// GET OTHER FEES OR MISCELLANEOUS FEES
	$get_msc = "SELECT sum(amount) as msc_amount, term, year, student_id FROM miscellaneous WHERE student_id = :sid AND year = :y";
	$mscQ = $dbh->prepare($get_msc);
	$mscQ->execute([':sid' => $sid, ':y' =>$year]);
	$msc_res = $mscQ->fetchAll(PDO::FETCH_OBJ);

	if ($mscQ->rowCount() > 0 ) {

	    foreach($msc_res as $key => $msc) {
	    	//MISCELLANEOUS FEES
	        $last_msc = $msc->msc_amount;
	    }
	}

	//GET TOTAL AMOUNT ALLOCATED
	$get_required = "SELECT 
	sum(fee_cluster.amount) as amount_required,
	student_fee.student_id as st_sid,
	student_fee.fee_cluster_id,
	student_fee.year,
	fee_cluster.year
	FROM fee_cluster
	JOIN student_fee
	ON fee_cluster.id = student_fee.fee_cluster_id
	WHERE student_fee.student_id = :sid 
	AND student_fee.year = :y AND fee_cluster.year = :y

	";
	$rQ = $dbh->prepare($get_required);
	$rQ->execute(array(
	    ':sid' => $sid,
	    ':y' => $year
	));
	$r_t = $rQ->fetchAll(PDO::FETCH_OBJ);
	if ($rQ->rowCount()>0) {
	    foreach ($r_t as $key => $req) {

	    	////AMOUNT ALLOCATED///
	        $required = $req->amount_required;

	        //GET TOTAL AMOUNT PAID THROUGH THE SYSTEMS'S COLLECT FEE
	        $getBal = "SELECT                        
	        sum(fee_receipt.amount_paid) as amount_paid,
	        fee_receipt.student_id as fr_sid,
	        student_fee.student_id as st_sid,
	        fee_cluster.year,
	        fee_receipt.payment_year,
	        student_fee.year

	        FROM fee_cluster
	        JOIN student_fee 
	        ON fee_cluster.id = student_fee.fee_cluster_id 
	        JOIN fee_receipt 
	        ON fee_receipt.student_id = :sid 
	        AND student_fee.student_id = :sid                                           
	        WHERE fee_cluster.year = :y 
	        AND student_fee.year = :y
	        AND fee_receipt.payment_year = :y
	        GROUP BY fee_cluster.id
	        ";
	        $query = $dbh->prepare($getBal);
	        $query->bindParam(':y', $year, PDO::PARAM_STR);
	        $query->bindParam(':sid', $sid, PDO::PARAM_STR);
	        $query->execute();
	        $total = $query->fetchAll(PDO::FETCH_OBJ);
	        $cnt = $query->rowCount() ;
	        if ($query->rowCount() > 0) {
	            foreach ($total as $key => $money) {

	            	//AMOUNT PAID IN FEE_RECEIPT TABLE
	                $paid = $money->amount_paid;
	                $bal_b4 = $required - $paid;

	                $bal = $bal_b4 + $last_bal + $last_msc;//BALANCE

	            }

	        }else{
	            $paid = 0;
	            $bal = $required - $paid;
	        }
	    }
	}else{
	    $required = 0; 
	    $bal = $required - $paid;
	} 

	//get amount paid per term
    $getPerTerm = "SELECT                        
    sum(fee_receipt.amount_paid) as amount_per_term,
    fee_receipt.student_id,
    fee_receipt.payment_year,
    fee_receipt.payment_term

    FROM fee_receipt

    WHERE fee_receipt.payment_year = :y
    AND fee_receipt.student_id = :sid
    
    GROUP BY fee_receipt.payment_term
    
    ";
    $query1 = $dbh->prepare($getPerTerm);
    $query1->bindParam(':y', $year, PDO::PARAM_STR);
    $query1->bindParam(':sid', $sid, PDO::PARAM_STR);

    $query1->execute();
    $total1 = $query1->fetchAll(PDO::FETCH_OBJ);
    $cnt = $query1->rowCount() ;
    if ($query1->rowCount() > 0) {
        foreach ($total1 as $key => $m) {
        	
        	//AMOUNT PAID PER TERM THIS YEAR
        	$payment_per_term[] = ['Amount' => $m->amount_per_term, 'Term' => $m->payment_term ];
        }
    }

    //GET  PREVIOUS TERMS BALANCE
    $sql = $dbh->prepare("SELECT balances.*, sum(balances.amount) as bal FROM balances WHERE student_id = :sid GROUP BY balances.term");
    $sql->execute(array(':sid' => $sid));
    $total = $sql->fetchAll(PDO::FETCH_OBJ);
    if ($sql->rowCount() > 0) {
        foreach ($total as $key => $bal_p) {
        	//PREV YEARS BALANCE
            $p_bal = $bal_p->bal;
        }
    }else{

    	$p_bal = 0;
    }

    // PREVIOUS TERM BALANCE DETAILS
    $sql = $dbh->prepare("SELECT balances.*, sum(balances.amount) as bal FROM balances WHERE student_id = :sid GROUP BY balances.term");
    $sql->execute(array(':sid' => $sid));
    $total = $sql->fetchAll(PDO::FETCH_OBJ);
    if ($sql->rowCount() > 0) {
        foreach ($total as $key => $bal_p) {

            $term_bal[] = ['Term' => $bal_p->term, 'Amount' => $bal_p->bal ]; 
        }
    }else{

    	$term_bal = 0;
 
    }

    //GET STUDENT INFORMATION
    $sql = "SELECT student.*,
    tbl_class.class_name 
    FROM student
    JOIN tbl_class
    ON student.Class_Id = tbl_class.id
    WHERE student.id = :sid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':sid', $sid, PDO::PARAM_STR);
    $query->execute();
    $results = $query -> fetchAll(PDO::FETCH_OBJ);
    if ($query->rowCount() > 0) {
        foreach ($results as $key => $result) { 

        	$first_name = $result->First_Name;
        	$last_name = $result->Last_Name;
        	$adm_no = $result->Admission_No;
        	$section = $result->Section;
        	$class = $result->class_name;
        	$surname = $result->Surname;
        	$passport = $result->Passport;
        }
    }

    //GET OTHER FEES 

    $get_msc = "SELECT amount, term, year, student_id, details FROM miscellaneous WHERE student_id = :sid AND year = :y";
    $mscQ = $dbh->prepare($get_msc);
    $mscQ->execute([':sid' => $sid, ':y' =>$year]);
    $msc_res = $mscQ->fetchAll(PDO::FETCH_OBJ);

    if ($mscQ->rowCount() > 0 ) {

        foreach($msc_res as $key => $msc) { 

        	$other_fee[] = ['Details' => $msc->details, 'Amount' => $msc->amount];

        }
    }

    $total_paid = $paid;    
    $total_required = $p_bal + $required + $last_msc;
    $total_balance = $total_required - $total_paid;


	$data = array(
		'First_Name' => $first_name,
		'Last_Name' => $last_name,
		'Surname' => $surname,
		'Passport' => $passport,
		'Admission_No' => $adm_no,
		'Section' => $section,
		'Class' => $class,
		'Amount_Allocated' => $required,
		'Other_Fee' => $other_fee,
		'Amount_Paid' => $paid,
		'Previous_Term_Bal' => $term_bal,
		'Balance_Allocated' => $bal,		
		'Term_Payment' => $payment_per_term,
		'Total_Required' => $total_required,		
		'Total_Paid' => $total_paid,
		'Total_Balance' => $total_balance


	);

	echo json_encode($data);
}