<?php

if ($_POST['unique'] == 0) {
	
	getProfile();

}elseif ($_POST['unique'] == 1) {

	getParentInfo();

}elseif ($_POST['unique'] == 2) {
	
	getDocs();

}elseif ($_POST['unique'] == 104) {

	collectFee();

}elseif($_POST['unique'] == 1016){

    getFeeHistory();

}


function getProfile() {

	require_once '../../../includes/config.php';

	$sid = $_POST['sid'];
	$data = array();

	$sql = "SELECT First_Name, Last_Name, Surname, Gender, Dob, Admission_Date, Admission_No, UPI, Assessment_No, Residence FROM student
    WHERE student.id = :sid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':sid', $sid, PDO::PARAM_STR);
    $query->execute();
    $results = $query -> fetchAll(PDO::FETCH_OBJ);
    if ($query->rowCount() > 0) {
        foreach ($results as $key => $result) { 

        	$data = array(

        		'First_Name' => $result->First_Name,
        		'Last_Name' => $result->Last_Name,
        		'Surname' => $result->Surname,
        		'Gender' => $result->Gender,
        		'Dob' => $result->Dob,
        		'Adm_no' => $result->Admission_No,
        		'Upi' => $result->UPI,
        		'Ass_no' => $result->Assessment_No,
        		'Adm_date' => $result->Admission_Date,
        		'Residence' => $result->Residence

        	);
        }

        echo json_encode($data);

    }else{

    	echo json_encode($data);
    }
}


function getParentInfo() {

	require_once '../../../includes/config.php';

	$sid = $_POST['sid'];
	$data = array();

	$sql = "SELECT Father_Name, Mother_Name, Phone, Sec_Phone, Third_Phone, Fourth_Phone, Guardian, Parent_Email, Parent_Address FROM student
    WHERE student.id = :sid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':sid', $sid, PDO::PARAM_STR);
    $query->execute();
    $results = $query -> fetchAll(PDO::FETCH_OBJ);
    if ($query->rowCount() > 0) {
        foreach ($results as $key => $result) { 

        	$data = array(

        		'Father_Name' => $result->Father_Name,
        		'Mother_Name' => $result->Mother_Name,
        		'Guardian' => $result->Guardian,
        		'Phone' => $result->Phone,
        		'Sec_Phone' => $result->Sec_Phone,
        		'Third_Phone' => $result->Third_Phone,
        		'Fourth_Phone' => $result->Fourth_Phone,
        		'Parent_Email' => $result->Parent_Email,
        		'Parent_Address' => $result->Parent_Address
        		

        	);
        }

        echo json_encode($data);

    }else{

    	echo json_encode($data);
    }

}


function getDocs() {

	require_once '../../../includes/config.php';

	$sid = $_POST['sid'];
	$data = array();

	$sql = "SELECT Pasport, Birth_Image FROM student
    WHERE student.id = :sid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':sid', $sid, PDO::PARAM_STR);
    $query->execute();
    $results = $query -> fetchAll(PDO::FETCH_OBJ);
    if ($query->rowCount() > 0) {
        foreach ($results as $key => $result) { 

        	$data = array(

        		'Passport' => $result->Passport,
        		'Birth_Image' => $result->Birth_Image
        		

        	);
        }

        echo json_encode($data);

    }else{

    	$data = array(

    		'Passport' => "0",
    		'Birth_Image' => "0"
    		

    	);

    	echo json_encode($data);
    }

}


// collect fee

function collectFee() {

	require_once '../../../includes/config.php';

	$sid = $_POST['sid'];

	$payment_sid = sprintf('%03d', $sid);

    function generateRandomString($length = 3) {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    if (empty($_POST['amount_paid'])) {
        
        $res = array("status" => false, "message" => "Amount is required, please enter a valid amount!");

        echo json_encode($res);
    }elseif(empty($_POST['payment_mode'])) {

        $res = array("status" => false, "message" => "Please select a payment mode!");

        echo json_encode($res);

    }elseif(empty($_POST['term'])){

        $res = array("status" => false, "message" => "Please select a term!");

        echo json_encode($res);

    }elseif(empty($_POST['year'])) {

        $res = array("status" => false, "message" => "Please select an year!");

        echo json_encode($res);

    }else{

        $amount_paid = $_POST['amount_paid'];
        $payment_mode = $_POST['payment_mode'];
        $payment_term = $_POST['term'];
        $payment_year = $_POST['year'];
        $r_no = $payment_sid . generateRandomString();

        $get_remind_std = $dbh->prepare("SELECT  First_Name, Last_Name FROM student  WHERE id = :sid");
        $get_remind_std->execute([':sid' => $sid]);
        $std = $get_remind_std->fetchAll(PDO::FETCH_OBJ);
        if ($get_remind_std->rowCount() > 0) {

            foreach ($std as $key => $r_res) {

                $fn = $r_res->First_Name;
                $ln = $r_res->Last_Name;

            }
        }

        if (is_numeric($amount_paid)) {
            
            $sql = "INSERT INTO fee_receipt(student_id, amount_paid, payment_mode, payment_year, payment_term, receipt_number)VALUES(:sid, :amt_p, :p_mode, :p_year, :p_term, :r_no)";
            $query = $dbh->prepare($sql);
            $query->bindParam(':sid',$sid,PDO::PARAM_STR);
            $query->bindParam(':amt_p',$amount_paid,PDO::PARAM_STR);
            $query->bindParam(':p_mode',$payment_mode,PDO::PARAM_STR);
            $query->bindParam(':p_year',$payment_year,PDO::PARAM_STR);
            $query->bindParam(':p_term',$payment_term,PDO::PARAM_STR);
            $query->bindParam(':r_no',$r_no,PDO::PARAM_STR);
            $query->execute();
            $lastInsertId = $dbh->lastInsertId();

            if ($lastInsertId) {

                $res = array('status' => true, 'message' => 'PAYMENT: '.$r_no.' for '.$fn.' '.$ln.' was made succesfuly ');

                echo json_encode($res);

            }else{

                $res = array("status" => false, "message" => "Something Went terribly wrong, check the fields and try again!");

                echo json_encode($res);
            }
        }else{

            $res = array("status" => false, "message" => "ERROR: Amount entered should be a number! Example: 2000.");

            echo json_encode($res);

        }

    }    

}

function getFeeHistory() {

    require_once '../../../includes/config.php';

    $sid = $_POST['sid'];
    $data = array();

    ## Read value
    $draw = $_POST['draw'];
    $row = $_POST['start'];
    $rowperpage = $_POST['length']; // Rows display per page
    $columnIndex = $_POST['order'][0]['column']; // Column index
    $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
    $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
    $searchValue = $_POST['search']['value']; // Search value

    ## Search 
    $searchQuery = "";

    if($searchValue != ''){

        $searchQuery .= " and (receipt_number like '%".$searchValue."%' or 
            amount_paid '%".$searchValue."%' or 
            payment_mode like '%".$searchValue."%' or payment_term like '%".$searchValue."%' or payment_year like '%".$searchValue."%'  or payment_date like '%".$searchValue."%' ) ";

    }

    ## Total number of records without filtering
    $sel = mysqli_query($con,"SELECT count(*) as allcount from fee_receipt WHERE student_id = ".$sid."");
    $records = mysqli_fetch_assoc($sel);
    $totalRecords = $records['allcount'];

    ## Total number of records with filtering 
    $sel = mysqli_query($con,"SELECT count(*) as allcount from fee_receipt WHERE 1 ".$searchQuery." AND student_id = ".$sid."");
    $records = mysqli_fetch_assoc($sel);
    $totalRecordwithFilter = $records['allcount'];


    $viewFee = "SELECT * FROM fee_receipt WHERE student_id = ".$sid." ".$searchQuery." ORDER BY ".$columnName." ".$columnSortOrder." LIMIT ".$row.",".$rowperpage;

    $empRecords = mysqli_query($con, $viewFee);


    while ($rowData = mysqli_fetch_assoc($empRecords)) {

        $data[] = array(

            'receipt_number' => $rowData['receipt_number'],
            'amount_paid' => $rowData['amount_paid'],
            'payment_mode' => $rowData['payment_mode'],
            'payment_term' => $rowData['payment_term'],
            'payment_year' => $rowData['payment_year'],
            'payment_date' => $rowData['payment_date'],
            'Action' => $rowData['receipt_number']

        );
    }


    ## Response
    $response = array(
        "draw" => intval($draw),
        "Something" => $viewFee,
        "iTotalRecords" => $totalRecords,
        "iTotalDisplayRecords" => $totalRecordwithFilter,
        "aaData" => $data
    );

    echo json_encode($response);
}