<?php
session_start();
error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $date = date('m/d/Y h:i:s a', time());

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Attendance</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display='none'" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display='none'" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display='none'" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3>Mark Attendance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <!-- body -->                
                <div class="promote_container">
                    <div class="promote_header">
                        <h3>Select Criteria</h3>
                    </div>
                    <div class="promote_content" placeholder='Search Term..'>
                        <select id="promote_select" name="atd_term" onchange="getTerm();">
                            <option value="">--Select term --</option>
                            <?php 
                            $termSQL = "SELECT id,term, year FROM tbl_term ORDER BY id ASC";
                            $termQuery =$dbh->prepare($termSQL);
                            $termQuery->execute();
                            $termResult = $termQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($termResult)) {
                                foreach ($termResult as $key => $val) {
                                    // code...
                            ?>
                            <option value="<?php echo $val->year; ?>">
                                [Term<?php echo $val->term; ?>] -
                                <?php echo $val->year; ?>
                            </option>
                            <?php }}?>
                            
                        </select>

                        <select id="atd_class" name="atd_class" onchange="getTermClass();">
                            <?php 
                            $classSQL = "SELECT id, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->id; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>

                        

                        <select id="atd_sdt" name="atd_sdt" onchange="getTermSdt();">
                            <?php 
                            $stSQL = "SELECT id, First_Name, Last_Name FROM student ORDER BY id ASC";
                            $stQuery =$dbh->prepare($stSQL);
                            $stQuery->execute();
                            $stResult = $stQuery->fetchAll(PDO::FETCH_OBJ);
                            if (!empty($stResult)) {
                                foreach ($stResult as $key => $val) {
                                    // code...
                            ?>
                            <option value="<?php echo $val->id; ?>">
                                <?php echo $val->First_Name; ?>
                                <?php echo $val->Last_Name; ?>
                            </option>
                            <?php }}?>
                        </select>

                    </div>
                </div>

                <div class="student_list">
                    <div class="student_list_header">
                        <p class="title">Import attendance.</p>
                        <button>
                            <i class="fa fa-download"></i>
                            Import
                        </button>
                    </div>
                    <form id="atd_form" method="post" enctype="multipart/form-data">
                        <table id="student-list" class="display table">
                            <thead>
                                <tr>
                                    <td>Adm No</td>
                                    <td>Name</td>
                                    <td>Class</td>
                                    <td>Stream</td>                              
                                    <td>Attendance Status</td>
                                </tr>
                            </thead>
                            <!-- TABLE BODY -->
                            <tbody>
                                <!-- TBODY //TABLE ROW  -->
                                <?php
                                $present = 1;
                                $half_day = 2;
                                $absent = 3;                              
                                

                                $atd = "SELECT 
                                student.id,
                                student.First_Name,
                                student.Last_Name, 
                                student.Class_Id,
                                student.Section,
                                student.Admission_No,
                                student.disabled
                                FROM  student WHERE disabled = 0
                                ";
                                $atdQuery = $dbh->prepare($atd);
                                $atdQuery->execute();
                                $atdResult = $atdQuery->fetchAll(PDO::FETCH_OBJ);
                                if (!empty($atdResult)) {
                                    foreach ($atdResult as $key => $val) {

                                ?>
                                <tr>
                                    <td><?php echo $val->Admission_No; ?></td>             
                                    <td>
                                        <?php echo $val->First_Name; ?>
                                        <?php echo $val->Last_Name; ?>
                                    </td>
                                    <td>Grade <? echo $val->Class_Id; ?></td>
                                    <td><? echo $val->Section; ?></td>
                                    <td class="atd_status">
                                        
                                        <label>
                                            <input value="<? echo $present; ?>" type="checkbox" name="status[]">
                                            <span class="atd_pr">
                                                <i class="fa-solid fa-check"></i>
                                                <p class="atd_p">Present</p>
                                            </span>
                                        </label>
                                        
                                        <label>
                                            <input value="<? echo $half_day; ?>" type="checkbox" name="status[]">
                                            <span class="atd_hd">
                                                <i class="fa-solid fa-arrows-split-up-and-left"></i>
                                                <p class="atd_p">Half-Day</p>
                                            </span>
                                        </label>

                                        <label>
                                            <input value="<? echo $absent; ?>" type="checkbox" name="status[]">
                                            <span class="atd_ab">
                                                <i class="fa-solid fa-xmark"></i>
                                                <p class="atd_p">Absent</p>
                                            </span>
                                        </label>
                                        <div style="display:none;">
                                            <input value="<? echo $val->id; ?>" type="number" name="atd_std_id[]">
                                        </div>
                                    </td>
                                </tr>
                                <? }}?>
                            </tbody>
                        </table>
                        <div class="allocate_container">
                            <button id="markAtdBtn" type="submit" onclick="markAtdAjax();">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                <p id="ajax_text">Update Attendance</p>
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#ajax_loader").hide();
        });

        function markAtdAjax() {
            let atd_form = document.querySelector("#atd_form"),
            succ = document.querySelector("#success"),
            error = document.querySelector("#error"),
            pend = document.querySelector("#pending");

            atd_form.onsubmit = (e) => {
                e.preventDefault();
            }

            let atdXhr = new XMLHttpRequest;

            atdXhr.onreadystatechange = function() {
                if (this.readyState !== "complete") {
                    $("#ajax_loader").show();
                    $("#ajax_text").hide();
                }

                if (atdXhr.readyState === XMLHttpRequest.DONE) {
                    $("#ajax_loader").hide();
                    $("#ajax_text").show();

                    if (atdXhr.status == 200) {
                        let response = JSON.parse(this.responseText);

                        if (response !== null && response !== undefined && response !== "") {

                            for(let item of response){
                                if (item.status == "true") {
                                    pend.textContent = item.message;
                                    pend.style.display = "block";
                                    error.style.display = "none"
                                    succ.style.display = "none"
                                    clearForm();
                                }else{
                                    error.textContent = item.message;
                                    error.style.display = "block";
                                    succ.style.display = "none";
                                    pend.style.display = "none";
                                }
                            }

                        }else{
                            error.textContent = "Response is undefined or null!";
                            error.style.display = "block";
                            succ.style.display = "none";
                        }
                    }else{
                        error.textContent = "Responded with a status of 404";
                        error.style.display = "block";
                        succ.style.display = "none";
                    }

                }
            }

            atdXhr.open("POST", "includes/attendance.php");
            let atdFormData = new FormData(atd_form);
            atdXhr.send(atdFormData);
        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function pendRemove() {
            pend = document.querySelector('#pending');

            pend.style.display = "none";
        }
        function clearForm() {
            // sessionStorage.clear();
            $('#atd_form').trigger("reset");
            // console.log("session cleared");
        }
    </script>    
</body>
</html>

<?php }}?>