<?php
session_start();
error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        if (isset($_POST['promote_all'])) {

            $filter = "SELECT Class,disabled FROM student WHERE Class > 7 AND disabled != 1";
            $f_query = $dbh->prepare($filter);
            $f_query->execute();
            $f_query->fetchAll(PDO::FETCH_OBJ);
            if ($f_query->rowCount() > 0) {

                $sql1 = "UPDATE student SET disabled = 1 WHERE Class = 8 AND disabled = 0";
                $query1 = $dbh->prepare($sql1);

                if ($query1->execute()) {
                    
                    $sql2 = "UPDATE student SET Class = Class + 1, Year = Year + 1 WHERE disabled = 0 AND Class != 8";
                    $query2 = $dbh->prepare($sql2);
                    $ext = $query2->execute();                    

                    if ($ext) {
                        $suc = "All Students have been PROMOTED and some have been DISABLED";
                    }else{
                        $error = "Could not promote students due to some errors";
                    }
                }else{
                    $error = "Failed to add to disabled students";
                }
            }else{
                $sql = "UPDATE student SET Class = Class + 1, Year = Year + 1 WHERE disabled = 0 AND Class != 8";
                $query = $dbh->prepare($sql);
                $query->execute();
                $cnt = $query->rowCount() > 0;

                if ($cnt) {
                    $suc = "All Students have been promoted to the next Academic Year";
                }else{
                    $error = "No students were promoted. No records of students to promote.";
                }
            }

            
        } 

        if (isset($_POST['demote_all'])) {

            $demote_filter = "UPDATE student SET Class = Class - 1 WHERE disabled = 0 ";
            $demote_q = $dbh->prepare($demote_filter);
            $demote_q->execute();

            if ($demote_q) {
                $suc = "Students Demoted Successfuly";
            }else{
                $error = "Something went wrong";
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Promote Student</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-arrow-right-long"></i>
                <h3>Promote Students</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, promote student!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Promote Student</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <!-- body -->

                <div class="promote_container">
                    <div class="student_list_header">
                        <h2 style="color: var(--bg-blue);">Promote or Demote All Students.</h2>

                        <form action="" method="post">
                            <button onclick="return confirm('Are you sure you want to DEMOTE ALL THE STUDENTS? \n If you make a mistake be sure to PROMOTE all the students and try again if you already did. ')" type="submit" name="demote_all"><img src="../assets/images/icons/white/left.svg">Demote All</button>
                        </form>

                        <form action="" method="post">
                            <button onclick="return confirm('Are you sure you want to PROMOTE ALL THE STUDENTS? \n If you make a mistake be sure to DEMOTE all the students and try again if you already did. ')" type="submit" name="promote_all"><img src="../assets/images/icons/white/check.svg">Promote All</button>
                        </form>
                    </div>
                    <table id="student-list" class="display table">
                        <thead>
                            <tr>
                                <td>Adm No</td>
                                <td>Roll No</td>
                                <td>Name</td>
                                <td>Class</td>
                                <td>Section</td>
                                <td>Gender</td>
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- TBODY //TABLE ROW  -->
                            <?php 
                                $sql = "SELECT * FROM student WHERE disabled = 0 ORDER BY id DESC";
                                $query = $dbh->prepare($sql);
                                $query->execute();
                                $results = $query->fetchAll(PDO::FETCH_OBJ);
                                $cnt = 1;
                                if ($query->rowCount() > 0) {
                                     foreach ($results as $result) {
                                         // code...

                            ?>
                            <tr>
                                <td><?php echo htmlentities($result->Admission_No);?></td>
                                <td><?php echo htmlentities($result->UPI);?></td>
                                <td>
                                    <?php echo htmlentities($result->First_Name);?>&nbsp;
                                    <?php echo htmlentities($result->Last_Name);?>&nbsp;
                                    <?php echo htmlentities($result->Surname);?>
                                </td>
                                <td>CLASS <?php echo htmlentities($result->Class);?></td>
                                <td><?php echo htmlentities($result->Section);?></td>
                                <td><?php echo htmlentities($result->Gender);?></td>
                                <td>
                                    <p class="student_edit">
                                        <a class="edit" href="#">
                                            <img src="../assets/images/icons/decrease.svg">Demote
                                        </a>

                                        <a class="edit" href="#">
                                            <img src="../assets/images/icons/increase.svg">Promote
                                        </a>
                                    </p>
                                </td>        
                            </tr>
                            <?php 
                                    }
                                }
                            ?> 
                            <!-- TBODY //TABLE ROW  -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#promote_select').selectize({
                sortField: 'text'
            });
            $('#promote_select1').selectize({
                sortField: 'text'
            });
            $('#promote_select2').selectize({
                sortField: 'text'
            });
        });
    </script>

</body>
</html>

<?php }}?>