<?php
session_start();
// error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $error = NULL;
        $suc = NULL;

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        $route_id = $_GET['route_id'];
        $sid=$_GET['s_id']; 
        $year = date("Y");

    
        $get_remind_std = $dbh->prepare("SELECT  First_Name, Last_Name, Payment_Code, Phone, Admission_No FROM student  WHERE id = :sid");
        $get_remind_std->execute([':sid' => $sid]);
        $std = $get_remind_std->fetchAll(PDO::FETCH_OBJ);
        if ($get_remind_std->rowCount() > 0) {

            foreach ($std as $key => $r_res) {

                $fn = $r_res->First_Name;
                $ln = $r_res->Last_Name;
                $pn = $r_res->Phone;
                $pc = $r_res->Payment_Code; 
                $adm = $r_res->Admission_No;



            }
        }


?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $fn; ?> <?php echo $ln; ?> - Personal information</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css"> 
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="../assets/fullcalendar/fullcalendar.min.css" />
    
    </head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- //Status Wrap -->
    <?php if($suc){?>
    <div onclick="this.style.display='none'" class="success_wrap">
        <?php echo htmlentities($suc); ?>
    </div><?php }elseif ($error) {?>

    <div onclick="this.style.display='none'" class="error_wrap">
        <?php echo htmlentities($error); ?>
    </div><?php }?>
    <!-- //status Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="pendRemove();" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>

    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa-solid fa-user"></i>
                <h3>Student Info</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <!-- top bar -->
            
            <!-- content header -->
            <div class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">            
                <div class="profile_container">
                    
                    <!-- ======= PROFILE LEFT======= -->
                    <div id="profile_left" class="profile_left">
                        <!-- PROFILE LEFT DATA HERE -->
                    </div>
                    <!-- ======= //PROFILE LEFT======= -->

                    <!-- ======= PROFILE RIGHT======= -->
                    <div class="profile_right">
                        <div class="personal_info">
                            <div class="tab">
                                <!-- ======= LEFT TABS ======= -->
                                <div class="tabs_left">
                                    <button id="defaultOpen" class="tab_links" onclick="openProfile(event, 'profile'); getProfile();">Profile</button>
                                    <button class="tab_links" onclick="openProfile(event, 'parent_info'); getParentInfo();">Parent Info</button>
                                    <button class="tab_links" onclick="openProfile(event, 'documents'); getDocuments()">Documents</button>
                                    <button class="tab_links" onclick="openProfile(event, 'timeline')">Timeline</button>
                                    <button id="collect_fees" class="tab_links" onclick="openProfile(event, 'fee')">Fees Payment</button>
                                    <button id="collect_fees" class="tab_links" onclick="openProfile(event, 'sibling');getSiblings();">Siblings</button>
                                </div>
                                <!-- ======= LEFT TABS======= -->

                                <!-- ======= EDIT STUDENT DETAILS======= -->
                                <div class="tabs_right">
                                    <!-- <a href="student-edit.php"> -->
                                        <button id="myBtn" class="btn">
                                            <i class="fa-solid fa-edit"></i>
                                            Edit
                                        </button>
                                    <!-- </a> -->
                                </div>
                                <!-- ======= EDIT STUDENT DETAILS======= -->
                            </div>

                            <!-- ======= STUDENT PERSONAL DETAILS======= -->
                            <div id="profile" class="tab_content profile_content">
                                <h4>Student Personal Info</h4>
                                <div class="profile_details_t" id="profile_view">
                                    <!-- profile info here -->
                                </div>
                            </div>
                            <!-- ======= STUDENT PERSONAL DETAILS======= -->

                            <!-- ======= PARENT DETAILS======= -->
                            <div id="parent_info" class="tab_content profile_content">
                                <h4>Parent Information</h4>
                                <div class="parent_info" id="parent_info_view">
                                    <!-- parent info here -->
                                </div>
                            </div>
                            <!-- ======= PARENT DETAILS======= -->

                            <!-- ======= DOCUMENTS======= -->
                            <div id="documents" class="tab_content profile_content">
                                <h4>Posted Documents</h4>
                                <div class="documents_info" id="docs_view">
                                   <!-- documents -->
                                </div>
                            </div>
                            <!-- ======= DOCUMENTS======= -->

                            <!-- ======= TIMELINE======= -->
                            <div id="timeline" class="tab_content profile_content">
                                <h4>Student's Timeline</h4>
                                <div class="timeline_info">
                                    This is where the content posted on this students timeline appears. Nothing to show in the moment.
                                </div>
                            </div>
                            <!-- ======= TIMELINE======= -->

                            <!-- ======= FEE SYSTEM======= -->
                            <div id="fee" class="tab_content profile_content">
                                <h4>Student's Fee Payment</h4>

                                <!-- ======= FEE BUTTONS======= -->
                                <div class="results_top">
                                    <button id="defaultFee" class="send_links" onclick="openSend(event, 'collect')">Collect Fee</button>

                                    <a href="collect-fee.php">
                                        <button id="defaultFee" class="send_links">
                                            Back to fee collection page
                                        </button>
                                    </a>

                                    <button id="fee_ht" class="send_links" onclick="openSend(event, 'fee_history');draw_histo();">Fee History</button>
                                </div>
                                <!-- ======= FEE BUTTONS======= -->

                                <!-- ======= COLLECT FEE======= -->
                                <div id="collect" class="timeline_info learning_content send_content">
                                    <h2>Collect fee for <? echo $fn;?> <? echo $ln;?>, make sure to enter the details correctly.</h2>

                                    <div class="fee_balance_p">
                                        <button id="payBtn" class="pay_btn">
                                            Enter Previous Term's Fee Balance
                                        </button>

                                        <button id="msBtn" class="pay_btn">
                                            Miscellaneous
                                        </button>

                                        <button id="mpesaBtn" class="pay_btn">
                                            Pay via M-Pesa
                                        </button>
                                    </div>
                                    <form id="collect_fee">
                                        
                                        <div class="upload_group">
                                            <label>Payment Mode</label>
                                            <small style="margin: 5px;">* Select the mode of payment below.</small>
                                            <select id="payment_mode" required>
                                                <option value="">--Select mode--</option>
                                                <option value="Bank Slip">Bank Receipt</option>
                                                <option value="Cash">Cash</option>
                                                <option value="Mpesa">Mpesa</option>
                                            </select>
                                        </div>

                                        <div class="upload_group">
                                            <label>Amount Paid</label>
                                            <small style="margin: 5px;">* Amount paid in Ksh.</small>
                                            <input type="text" id="amount_paid" placeholder="Note: No comas! Example: 12600" required>
                                        </div>

                                        <div class="upload_group">
                                            <label>Term</label>
                                            <small style="margin: 5px;">* Which term is the payment for?</small>
                                            <select id="term" required>
                                                <option value="">--Select Term--</option>
                                                <?
                                                $viewTerm = "SELECT * FROM tbl_term WHERE year = :y";
                                                $query = $dbh->prepare($viewTerm);
                                                $query->bindParam(':y', $year, PDO::PARAM_STR);
                                                $query->execute();
                                                $results = $query->fetchAll(PDO::FETCH_OBJ);
                                                if ($query->rowCount() > 0) {
                                                    foreach ($results as $key => $result) {
                                                ?>
                                                <option value="<? echo $result->term;?>">Term <? echo $result->term;?></option>
                                                <? }}?>
                                            </select>
                                        </div>

                                        <div class="upload_group">
                                            <label>Year</label>
                                            <small style="margin: 5px;">* The year which the payment is for.</small>
                                            <select id="year" required>
                                                <option value="">--Select Year--</option>
                                                <option><? echo $year;?></option>
                                                <option><? echo $year - 1;?></option>
                                                <option><? echo $year - 2;?></option>
                                                <option><? echo $year - 3;?></option>
                                                <option><? echo $year - 4;?></option>
                                            </select>
                                        </div>

                                        <button onclick="javascript:collectFee();" class="pay_btn" >
                                            Add Payment
                                            <img id="pay_loader" src="../assets/images/blank.gif">
                                        </button>
                                    </form>
                                </div>
                                <!-- ======= //COLLECT FEE======= -->

                                <!-- ======= FEE HISTORY======= -->
                                <div id="fee_history" class=" send_content">
                                    <div class="timeline_info">
                                        <p class="title">
                                            Fee Reports.
                                        </p>
                                        <table id="fee_history_list" class="display">
                                            <thead>
                                                <tr>
                                                    <td>Payement Id</td>
                                                    <td>Amount Paid</td>
                                                    <td>Payment Mode</td>
                                                    <td>Term</td>
                                                    <td>Year</td>
                                                    <td>Date Paid</td>
                                                    <td>Action</td>
                                                </tr>
                                            </thead>
                                            <tbody >
                                                <!-- fee history here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- ======= //FEE HISTORY======= -->
                            </div>
                            <!-- ======= //FEE SYSTEM======= -->

                            <!-- ======= SIBLINGS======= -->
                            <div id="sibling" class="tab_content profile_content">
                                <h4>Student's Siblings</h4>
                                <p class="title">List of siblings that this student has.</p>
                                <div class="documents_info" id="siblings_container">
                                   <!-- siblings here -->
                                </div>

                                <h4>Add Sibling</h4>
                                <p class="title">Add Siblings below</p>
                                <div class="timeline_info">
                                    <button class="btn" id="siblingBtn">Add Sibling</button>
                                </div>
                            </div>
                            <!-- ======= SIBLINGS======= -->

                        </div>
                    </div>
                    <!-- ======= //PROFILE RIGHT======= -->
                </div>
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div id="myModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php echo $fn; ?> 
                <?php echo $ln; ?>'s &mdash; Profile info!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <div class="edit_container">
                    <div class="edit_group">
                        <label>First Name</label>
                        <input value="<?php echo $fn; ?> " type="text" name="first_name" >
                    </div>

                    <div class="edit_group">
                        <label>Last Name</label>
                        <input value="<?php echo $ln; ?> " type="text" name="last_name" >
                    </div>

                    <div class="edit_group">
                        <label>Surname</label>
                        <input value="<?php echo $sn; ?>" type="text" name="surname" >
                    </div>

                     <div class="edit_group">
                        <label>Admission Number</label>
                        <input value="<?php echo $adm_no; ?>" type="text" name="adm_no" >
                    </div>

                    <div class="edit_group">
                        <label>Assessment Number</label>
                        <input value="<?php echo $ass_no; ?>" type="text" name="ass_no" >
                    </div>
                    <div class="edit_group">
                        <label>Gender</label>
                        <input value="<?php echo $gdr; ?>" type="text" name="gender" >
                    </div>
                    <div class="edit_group">
                        <label>D.O.B</label>
                        <input value="<?php echo $dob; ?>" type="text" name="dob" >
                    </div>
                    <div class="edit_group">
                        <label>UPI</label>
                        <input value="<?php echo $res->UPI; ?>" type="text" name="upi" >
                    </div>
                    <div class="edit_group">
                        <label>Payment Code</label>
                        <input value="<?php echo $res->Payment_Code; ?>" type="text" name="payment_code" >
                    </div>
                    <div class="edit_group">
                        <label>Admission Date</label>
                        <input value="<?php echo $res->Admission_Date; ?>" type="text" name="adm_date" >
                    </div>
                    <div class="edit_group">
                        <label>Residence</label>
                        <input value="<?php echo $res->Residence; ?>" type="text" name="residence" >
                    </div>
                    <div class="edit_group">
                        <label>Father Name</label>
                        <input value="<?php echo $res->Father_Name; ?>" type="text" name="father_name" >
                    </div>
                    <div class="edit_group">
                        <label>Mother Name</label>
                        <input value="<?php echo $res->Mother_Name; ?>" type="text" name="mother_name" >
                    </div>
                    <div class="edit_group">
                        <label>Phone(1)</label>
                        <input value="<?php echo $res->Phone; ?>" type="text" name="phone" >
                    </div>
                    <div class="edit_group">
                        <label>Phone(2)</label>
                        <input value="<?php echo $res->Sec_Phone; ?>" type="text" name="sec_phone" >
                    </div>
                    <div class="edit_group">
                        <label>Phone(3)</label>
                        <input value="<?php echo $res->Third_Phone; ?>" type="text" name="third_phone" >
                    </div>
                    <div class="edit_group">
                        <label>Phone(4)</label>
                        <input value="<?php echo $res->Fourth_Phone; ?>" type="text" name="fourth_phone" >
                    </div>
                    <div class="edit_group">
                        <label>Email</label>
                        <input value="<?php echo $res->Parent_Email; ?>" type="email" name="email" >
                    </div>
                    <div class="edit_group">
                        <label>Address</label>
                        <input value="<?php echo $res->Parent_Address; ?>" type="text" name="address" >
                    </div>
                    <div class="edit_group">
                        <label>Notes</label>
                        <input value="<?php echo $res->Notes; ?>" type="text" name="notes" >
                    </div>
                    <div style="display:none">
                        <input value="<?php echo $res->id; ?>" type="text" name="sid_edit">
                    </div>
                </div>
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editProfile();">
                        <i class="fa fa-add"></i>
                        Update
                        <img id="ajax_loader" src="../assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <!-- miscellaneous modal -->
    <div id="msModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Miscellaneous</h4>
                <span id="ms_span" class="close">&times;</span>
            </div>
            <div class="modal_form">
                <form id="msForm" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Amount</label>
                        <input type="text" id="amount" placeholder="Enter balance amount in ksh.">
                    </div>

                    <div class="pay_group">
                        <label>Details</label>
                        <input type="text" id="details" placeholder="Payment for.">
                    </div>                    

                    <div class="pay_group">
                        <label>Term</label>
                        <select id="msc_term">
                            <option value="">--Select Term--</option>
                            <?php 
                            $termSQL = "SELECT id,term, year FROM tbl_term ORDER BY id ASC";
                            $termQuery =$dbh->prepare($termSQL);
                            $termQuery->execute();
                            $termResult = $termQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($termResult)) {
                                foreach ($termResult as $key => $val) {
                            ?>
                            <option value="<?php echo $val->term; ?>">
                                [Term<?php echo $val->term; ?>] -
                                <?php echo $val->year; ?>
                            </option>
                            <?php }}?>
                        </select>
                    </div>

                    <div class="pay_group">
                        <label>Year</label>
                        <select id="msc_year">
                            <option value="">--Select Year--</option>
                            <option><? echo $year;?></option>
                            <option><? echo $year - 1;?></option>
                            <option><? echo $year - 3;?></option>
                            <option><? echo $year - 4;?></option>
                            <option><? echo $year - 5;?></option>
                            <option><? echo $year - 6;?></option>
                        </select>
                    </div>

                    <input style="display: none;" type="text" id="sid" value="<? echo $sid; ?>">
                    
                    <div style="display:none">
                        <input type="text" name="sid" value="<?php echo $sid; ?>">
                    </div>
                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:msPay();">
                            Add
                            <img id="ms_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- payment modal -->
    <div id="payModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Last Term's Fee Balance</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="payBal" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Balance Amount</label>
                        <input type="text" name="amount" placeholder="Enter balance amount in ksh.">
                    </div>

                    <div class="pay_group">
                        <label>Year</label>
                        <select name="year">
                            <option value="">--Select Year--</option>
                            <option><? echo $year;?></option>
                            <option><? echo $year - 1;?></option>
                            <option><? echo $year - 3;?></option>
                            <option><? echo $year - 4;?></option>
                            <option><? echo $year - 5;?></option>
                            <option><? echo $year - 6;?></option>
                        </select>
                    </div>

                    <div class="pay_group">
                        <label>Term</label>
                        <select name="term">
                            <option value="">--Select Term--</option>
                            <?php 
                            $termSQL = "SELECT id,term, year FROM tbl_term ORDER BY id ASC";
                            $termQuery =$dbh->prepare($termSQL);
                            $termQuery->execute();
                            $termResult = $termQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($termResult)) {
                                foreach ($termResult as $key => $val) {
                            ?>
                            <option value="<?php echo $val->term; ?>">
                                [Term<?php echo $val->term; ?>] -
                                <?php echo $val->year; ?>
                            </option>
                            <?php }}?>
                        </select>
                    </div>
                    
                    <div style="display:none">
                        <input type="text" name="sid" value="<?php echo $sid; ?>">
                    </div>
                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:paymentBal();" id="payBalBtn">
                            Update Balance
                            <img id="bal_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- mpesa modal -->
    <div id="mpesaModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Lipa Na M-Pesa</h4>
                <span class="close_mpesa">&times;</span>
            </div>
            <div class="modal_form">
                <form id="mpesa_form" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Phone</label>
                        <input type="text" id="mpesa_phone" name="mpesa_phone" placeholder="Enter phone in the format 254XXXXXXXXX.">
                    </div>

                    <div class="pay_group">
                        <label>Amount</label>
                        <input type="text" id="mpesa_amount" name="mpesa_amount" placeholder="Enter amount to pay.">
                    </div>

                    <div class="pay_group">
                        <label>Description</label>
                        <input type="text" id="mpesa_details" name="mpesa_desc" placeholder="Payment description.">
                    </div>                                    
                    
                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:payMpesa();" id="payMpesaBtn">
                            Pay
                            <img id="mpesa_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- siblings modal -->
    <div id="siblingModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Add Sibling</h4>
                <span id="close_sibling" class="close">&times;</span>
            </div>
            <div class="modal_form">
                <form id="siblingForm">

                    <div class="pay_group">

                        <label>
                            <i class="fa fa-building"></i>
                            Select Class
                        </label>

                        <select onchange="getSelectedClass(this.options[this.selectedIndex].value);">

                            <option value="">
                                --Select Class--
                            </option>
                            <?php 
                            $sql = "SELECT tbl_class.class_name, tbl_class.id FROM tbl_class";
                            $query = $dbh->prepare($sql);
                            $query->execute();
                            $res = $query->fetchAll(PDO::FETCH_OBJ);
                            if ($query->rowCount() > 0) {
                                foreach ($res as $key => $val) {
                            ?>
                            <option value="<?php echo $val->id?>">
                                <?php echo $val->class_name;?>      
                            </option>
                            <?php }}?>
                        </select>
                    </div>

                    <div  class="pay_group">
                        <label>
                            <i class="fa fa-user"></i>
                            Select Sibling
                        </label>
                        <select id="sibling_list">
                            <!-- display the students here -->
                            <option value="">
                                --Select a student--
                            </option>
                        </select>

                    </div>  

                    <div style="display: none;">
                        <input type="text" id="payment_code" value="<? echo $pc; ?>">
                    </div>                              
                    
                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:addSibling();">
                            Save
                            <img id="sibling_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="fancy_loader" id="mpesa_fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Working on it...</p>
    </div>

    <div class="fancy_loader" id="pay">
        <div></div>
        <div></div>
        <div></div>
        <p>Paying...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    
    <script src="../assets/js/jquery-3.6.0.js"></script>        
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>  
    <script src="../assets/fullcalendar/lib/moment.min.js"></script>
    <script src="../assets/fullcalendar/fullcalendar.min.js"></script>
    <script src="../assets/js/calendar.js"></script>
    <script type="text/javascript">

        $(document).ready(function(){
            getProfileLeft();
            $("#ajax_loader").hide();
            $("#bal_loader").hide();
            $("#ms_loader").hide();
            $("#pay_loader").hide();
            $("#pay").hide();
            $("#sibling_loader").hide();
            $("#mpesa_loader").hide();
            $("#mpesa_fancy_loader").hide();
        });

         // Get the element with id="defaultOpen" and click on it
        document.getElementById("defaultOpen").click();
        document.getElementById("defaultFee").click();

        function draw_histo() {

            feeHistTable.draw();
        }


        function getProfile() {

            let prof_container = document.querySelector("#profile_view");
            let sid = '<? echo $sid; ?>';
            let unique = 0;
            let output = "";

            let data = { unique, sid };

            // ajax
            $.ajax({
                url: 'includes/std-view.php',
                method: 'POST',
                data: data,
                success: function(data) { 

                    let response = JSON.parse(data);

                    output += `
                        
                        <span>
                            <h3>Student Name</h3>
                            <p>${response.First_Name}&nbsp;${response.Last_Name}&nbsp;${response.Surname}</p>
                        </span>
                        <span><h3>Gender</h3><p>${response.Gender}</p></span>
                        <span><h3>Date of Birth</h3><p>${response.Dob}</p></span>
                        <span><h3>Admission No</h3><p>${response.Adm_no}</p></span>
                        <span><h3>UPI</h3><p>${response.Upi}</p></span>
                        <span><h3>Assessment No</h3><p>${response.Ass_no}</p></span>
                        <span><h3>Admission Date</h3><p>${response.Adm_date}</p></span>
                        <span><h3>Residence</h3><p>${response.Residence}</p></span>


                    `;

                    prof_container.innerHTML = output;
                }
            });

            

            
        }


        function getParentInfo() {

            let parent_container = document.querySelector("#parent_info_view");
            let sid = '<? echo $sid; ?>';
            let unique = 1;
            let output = "";

            let data = { unique, sid };

            // ajax
            $.ajax({
                url: 'includes/std-view.php',
                method: 'POST',
                data: data,
                success: function(data) { 

                    let response = JSON.parse(data);

                    output += `
                        
                        <span>
                            <h3>Father Name</h3>
                            <p>${response.Father_Name}</p>
                        </span>
                        <span>
                            <h3>Mother Name</h3>
                            <p>${response.Mother_Name}</p>
                        </span>
                    

                        <span>
                            <h3>Guardian Name</h3>
                            <p>${response.Guardian}</p>
                        </span>


                        <span>
                            <h3>Phone</h3>
                            <p> +254${response.Phone}></p>
                        </span>                 

                        <span>
                            <h3>Second Phone</h3>
                            <p>+254${response.Sec_Phone}</p>
                        </span>

                        <span>
                            <h3>Third Phone</h3>
                            <p>+254${response.Third_Phone}</p>
                        </span>

                        <span>
                            <h3>Fourth Phone</h3>
                            <p>+254${response.Fourth_Phone}</p>
                        </span>
                        
                        <span>
                            <h3>Email</h3>
                            <p>${response.Parent_Email}</p>
                        </span>
                        <span>
                            <h3>Address</h3>
                            <p>${response.Parent_Address}</p>
                        </span>

                    `;

                    parent_container.innerHTML = output;
                }
            });
        }


        function getDocuments() {

            let docs_container = document.querySelector("#docs_view");
            let sid = '<? echo $sid; ?>';
            let unique = 2;
            let output = "";

            let data = { unique, sid };

            // ajax
            $.ajax({
                url: 'includes/std-view.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data); 

                    output += `
                         <span><h3>Profile Image</h3>
                            ${
                                response.Passport == null || response.Passport == 0 ? 
                                `<img src="../assets/images/icons/profile.svg">` : 
                                `<img src="../../uploads/student/${response.Passport}">`

                            }
                            
                        </span>

                        <span><h3>Birth Cert</h3>

                            ${
                                response.Birth_Image == null || response.Birth_Image == 0 ? 
                                `<img src="../assets/images/icons/profile.svg">` : 
                                `<img src="../../uploads/student/${response.Birth_Image}">`

                            }
                                
                        </span>
                    `;

                    docs_container.innerHTML = output;

                }
            });
        }


        function collectFee(){

            let suc = document.querySelector("#success"),
            collect_fee_form = document.querySelector("#collect_fee"),
            err = document.querySelector("#error");
            let sid = '<? echo $sid; ?>';
            let unique = 104;
            let amount_paid = $("#amount_paid").val();
            let payment_mode = $("#payment_mode").val();
            let term = $("#term").val();
            let year = $("#year").val();

            collect_fee_form.onsubmit = (e) => { e.preventDefault() }

            let data = { unique, sid, amount_paid, payment_mode, term, year };

            // ajax
            $.ajax({
                url: 'includes/std-view.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data); 

                    if (response.status == true ) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';
                        getProfileLeft();

                    }else if(response.status == false){

                        err.textContent = response.message;
                        err.style.display = "block";
                        suc.style.display = "none";

                    }else{

                        err.textContent = response;
                        err.style.display = "block";
                        suc.style.display = "none";

                    }                    

                },
                beforeSend: function() {

                    $("#pay_loader").show();
                    $("#pay").show();
                },
                complete: function() {

                    $("#pay_loader").hide();
                    $("#pay").hide();
                }
            });

        }

        //on load get students
        let feeHistTable = $('#fee_history_list').DataTable({
            'buttons': [ 'copy', 'csv', 'excel', 'pdf', 'print' ],
            'processing': false,
            'serverSide': true,
            'responsive': true,
            'serverMethod': 'POST',
            'searching': true,
            // ajax
            'ajax': {
                'url': 'includes/std-view.php',
                'data': function (data) {
                    // read value
                    let unique = 1016;
                    let sid = '<? echo $sid; ?>';

                    // apend data
                    data.unique = unique;
                    data.sid = sid;
                },
                beforeSend: function () {
                    $('#mpesa_fancy_loader').show();
                },
                complete: function () {
                    $('#mpesa_fancy_loader').hide();
                }
            },
            'columns': [
                { data: 'receipt_number', 'orderable': true },
                { data: 'amount_paid', 'orderable': true},
                { data: 'payment_mode', 'orderable': true},
                { data: 'payment_term', 'orderable': true},
                { data: 'payment_year', 'orderable': true },
                { data: 'payment_date', 'orderable': true },
                { data: "Action",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data) { // render event defines the markup of the cell text 

                        let a = `<p class="student_edit">

                                    <button class="delete" onclick="deleteFeeReceipt(this.value)" value="${data}">
                                        <i class="fa fa-trash"></i>
                                    </button>

                                </p>`; // row object contains the row data
                        return a;
                    }
                },
            ],
            'columnDefs': [{
                orderable: false,
                ordering: false,
                targets: [2,3,4,5]  //Here we disable sorting fearure for few cols
            }],
        });


        function getProfileLeft() {

            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");
            let student_id = '<? echo $sid; ?>';
            let profile_container = document.getElementById("profile_left");

            let data = { student_id }

            let output = "";
            let other_pay = "";
            let term_pay = "";
            let term_bal = "";

            // ajax
            $.ajax({
                url: 'includes/std-view-fee-payment.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    function getOtherPayments() {

                        $.each(response.Other_Fee, function (index, item) {

                            other_pay += `
                                <span>
                                    <h3>${item.Details}</h3>
                                    <h4>
                                        <p>Ksh&nbsp;${Intl.NumberFormat().format(item.Amount)}</p>
                                    </h4>
                                </span>

                            `; 
                        });

                        return other_pay;

                    };

                    function getTermPayment() {

                        $.each(response.Term_Payment, function (index, item) {

                            term_pay += `

                                <span>
                                    <h3>Term ${item.Term}</h3>
                                    <h4>
                                        <p style="font-size: 17px;color: var(--btn-blue); font-weight: 700;" class="student_edit">
                                            Ksh&nbsp;${Intl.NumberFormat().format(item.Amount)}                              
                                        </p>
                                    </h4>
                                </span>

                            `; 
                        });
                        return term_pay;

                    };

                    function getTermBal() {

                        $.each(response.Previous_Term_Bal, function (index, item) {

                            term_bal += `
                                <span>
                                    <h3>Term ${item.Term} &mdash; <? echo $year;?></h3>
                                    <h4>
                                        <p style="font-size: 17px;color: var(--danger); font-weight: 700;" class="student_edit">
                                            Ksh&nbsp;${Intl.NumberFormat().format(item.Amount)}                              
                                        </p>
                                    </h4>
                                </span>

                            `;
                        });

                        return term_bal;

                    };

                    output += `

                        <div class="profile_left_t">
                            <div class="profile_left_inner">                            
                                <div class="profile_top">
                                    <img src="../assets/images/5.jpg">
                                </div>    

                                <div class="profile_image">
                                    ${
                                        response.Passport == null ? 
                                        `<img src="../assets/images/icons/profile.svg">` : 
                                        `<img src="../../uploads/student/${response.Passport}">`

                                    }

                                                                     
                                </div>
                                
                                <div class="profile_details_left">                            
                                    <span>
                                        <h3>Name</h3>
                                        <p>${response.First_Name}&nbsp;${response.Last_Name}&nbsp;${response.Surname}</p>
                                    </span>
                                    <span>
                                        <h3>Admission No</h3>
                                        <p>
                                            ${response.Admission_No}
                                        </p>
                                    </span>
                                    <!-- -->
                                    <span>
                                        <h3>Section</h3>
                                        <p>
                                            ${response.Section}                                      
                                        </p>
                                    </span>
                                    <span>
                                        <h3>Class</h3>
                                        <p>${response.Class}</p>
                                    </span>
                                    <span>
                                        <h3>Subjects</h3>
                                        <p>Null</p>
                                    </span>  
                                </div>
                            </div>

                            <!-- FEES BALANCE -->
                            <div style="margin-top: 10px" class="timeline_info profile_details_left">
                                <span class="title">
                                    <h3 style="color:var(--btn-blue);font-weight: 700;">Fees Payment this year:</h3>
                                </span>
                                <span>
                                    <h3>Total Required <? echo $year; ?></h3>
                                    <p style="font-size: 17px;color:var(--white); font-weight: 700;" class="student_edit">
                                        Ksh&nbsp;${Intl.NumberFormat().format(response.Total_Required)}                              
                                    </p>
                                </span>

                                <span>
                                    <h3>Fees Paid <? echo $year; ?></h3>
                                    <p style="font-size: 17px;color:var(--bg-blue); font-weight: 700;" class="student_edit">
                                        Ksh&nbsp;${Intl.NumberFormat().format(response.Amount_Paid)}                              
                                    </p>
                                </span>                                

                                <!-- OTHER PAYMENTS -->
                                <span class="title">
                                    <h3 style="color:var(--btn-blue);font-weight: 700;">Other Fees:</h3>
                                </span>
                                ${getOtherPayments()}

                                <!-- OTHER PAYMENTS -->

                                <!-- TERM PAYMENTS -->
                                <span class="title">
                                    <h3 style="color:var(--btn-blue);font-weight: 700;">Fees paid Per Term:</h3>
                                </span>
                                ${getTermPayment()} 
                                <!-- TERM PAYMENTS -->                          


                                <!-- ///previous years balnces/// -->
                                <span class="title">
                                    <h3 style="color:var(--btn-blue);font-weight: 700;">Previous term balance:</h3>
                                    <i class="fa fa-chevron-down"></i>
                                </span>
                                ${getTermBal()} 

                                <span>
                                    <h3>Fees Balance:</h3>
                                    <h4>

                                        ${
                                            response.Total_Balance > 0 ? `
                                                <p style="font-size: 17px;color: var(--danger); font-weight: 700;" class="student_edit">
                                        
                                                    Ksh&nbsp; ${Intl.NumberFormat().format(response.Balance_Allocated)}                            
                                                </p>

                                            ` : `

                                                <p style="font-size: 17px;color: var(--white); font-weight: 700;" class="student_edit">
                                        
                                                    Ksh&nbsp; ${Intl.NumberFormat().format(response.Balance_Allocated)}                            
                                                </p>
                                            `
                                        }
                                    </h4>
                                </span>                               

                                <!-- ///previous years balnces/// -->

                                <!-- GRAND BALANCE THIS YEAR -->
                                <span>
                                    <h3>TOTAL BALANCE &mdash; <? echo $year; ?></h3>
                                    <h4>

                                        ${
                                            response.Total_Balance > 0 ? `
                                                <p style="font-size: 17px;color: var(--danger); font-weight: 700;" class="student_edit">
                                        
                                                    Ksh&nbsp; ${Intl.NumberFormat().format(response.Total_Balance)}                            
                                                </p>

                                            ` : `

                                                <p style="font-size: 17px;color: var(--white); font-weight: 700;" class="student_edit">
                                        
                                                    Ksh&nbsp; ${Intl.NumberFormat().format(response.Total_Balance)}                            
                                                </p>
                                            `
                                        }

                                    </h4>
                                    <h4>
                                        <button onclick="remindFee(${response.Total_Balance});" class="btn-s">Remind</button>
                                    </h4>
                                </span>
                                <!-- GRAND BALANCE THIS YEAR -->
                            </div>
                        </div>


                    `; 

                    profile_container.innerHTML = output;         

                    

                },
                beforeSend: function() {

                    $("#mpesa_fancy_loader").show();

                },
                complete: function() {

                    $("#mpesa_fancy_loader").hide();

                }
            });

        }

        function remindFee(value) {

            let balance = value; 
            let proceed_before = false;

            balance <= 0 ? proceed_before == false : proceed_before == true; 


            if (proceed_before == true) {

                alert(`This student has no balance, <? echo $fn;?> <? echo $ln; ?> has an overpayment of ${Intl.NumberFormat().format(balance)}`);

            }else{

                let proceed = confirm(`Are you sure you want to remind <? echo $fn;?> <? echo $ln; ?> to pay a balance of ${Intl.NumberFormat().format(balance)} ?`);           
            

                if (proceed) {

                    let suc = document.querySelector("#success"),
                    err = document.querySelector("#error");

                    // let item_id = value;
                    ;
                    let student_name = '<? echo $fn; ?> <? echo $ln; ?>';
                    let parent_phone = '<? echo $pn; ?>';


                    let data = { balance, student_name, parent_phone }

                    $.ajax({
                        url: 'includes/fee-balance-remind.php',
                        method: 'POST',
                        data: data,
                        success: function (data) {
                            //response

                            let response = JSON.parse(data);

                            if (response.status == true ) {

                                suc.textContent = response.message;
                                suc.style.display = 'block';
                                err.style.display = 'none'

                            }else if(response.status == 'false'){

                                err.textContent = response.message;
                                err.style.display = "block";
                                suc.style.display = "none";

                            }else{

                                err.textContent = response;
                                err.style.display = "block";
                                suc.style.display = "none";

                            }
                        },
                        beforeSend: function () {
                            
                            $('#mpesa_fancy_loader').show();

                        },
                        complete: function () {

                            $('#mpesa_fancy_loader').hide();

                        }
                    });
                }
            }
        }


        function deleteFeeReceipt(value) {

            let payment_id = value;
            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");

            let data = { payment_id }

            // ajax
            $.ajax({
                url: 'includes/remove-payment.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    if (response.status == true ) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                        feeHistTable.draw();
                        getProfileLeft();
                        

                    }else if(response.status == false){

                        err.textContent = response.message;
                        err.style.display = "block";
                        suc.style.display = "none";

                    }else{

                        err.textContent = response;
                        err.style.display = "block";
                        suc.style.display = "none";
                    }


                },
                beforeSend: function() {

                    $("#mpesa_fancy_loader").show();
                    $("#sibling_loader").show();

                },
                complete: function() {

                    $("#mpesa_fancy_loader").hide();
                    $("#sibling_loader").hide();

                }
            });

        }

        function getSiblings() {

            let sibling_container = document.querySelector("#siblings_container");
            let code = '<? echo $pc; ?>';
            let adm_no = '<? echo  $adm; ?>';

            let data = { code, adm_no };


            let sibling = " ";

            //ajax
            $.ajax({
                url: 'includes/get-sibling.php',
                method: 'POST',
                data: data,
                success: function(response) {

                    let data = JSON.parse(response);

                    if (data !== null && data !== undefined && data !== '') {

                        $.each(data, (index, item) => {


                            sibling += `

                                <span>
                                    <h3>${item.First_Name}&nbsp;${item.Last_Name}</h3>
                                    <h3>${item.Payment_Code}</h3>

                                    <h3>${item.class_name}  </h3>
                                    <h3>
                                        <button class="btn-s-d" onclick="javascript:removeSibling(${item.Admission_No})">Remove</button>
                                    </h3>
                                </span>

                            `;


                        });

                    }else{

                        sibling = `<span><h3>Nothing to show here. Add a sibling bellow for this student!</h3></span>`;
                    }

                    

                    sibling_container.innerHTML = sibling;


                },
                beforeSend: () => {$("#mpesa_fancy_loader").show();},
                complete: () => {$("#mpesa_fancy_loader").hide();}
            });
        }


        function removeSibling(value) {

            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");

            let adm_no = value;

            let data = { adm_no };

            // ajax
            $.ajax({
                url: 'includes/remove-sibling.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    if (response.status == true ) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                        getSiblings();

                    }else if(response.status == 'false'){

                        err.textContent = response.message;
                        err.style.display = "block";
                        suc.style.display = "none";

                    }else{

                        err.textContent = response;
                        err.style.display = "block";
                        suc.style.display = "none";
                    }


                },
                beforeSend: function() {

                    $("#mpesa_fancy_loader").show();
                    $("#sibling_loader").show();

                },
                complete: function() {

                    $("#mpesa_fancy_loader").hide();
                    $("#sibling_loader").hide();

                }
            });


        } 


        function addSibling() {

            let sibling_form = document.querySelector("#siblingForm"),
            suc = document.querySelector("#success"),
            err = document.querySelector("#error");

            sibling_form.onsubmit = (e) => { e.preventDefault() }

            let sibling = $("#sibling_list").val();
            let code = $("#payment_code").val();

            let data = { sibling, code };

            // ajax
            $.ajax({
                url: 'includes/add-sibling.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    if (response.status == true ) {

                        suc.textContent = response.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                        getSiblings();

                    }else if(response.status == false){

                        err.textContent = response.message;
                        err.style.display = "block";
                        suc.style.display = "none";

                    }else{

                        err.textContent = response;
                        err.style.display = "block";
                        suc.style.display = "none";
                    }


                },
                beforeSend: function() {

                    $("#mpesa_fancy_loader").show();
                    $("#sibling_loader").show();

                },
                complete: function() {

                    $("#mpesa_fancy_loader").hide();
                    $("#sibling_loader").hide();

                }
            });


        }


        


        function getSelectedClass(value) {

            let selectedClass = value;

            let holdContainer = document.querySelector("#sibling_list");

            let xhr = new XMLHttpRequest();

            xhr.onreadystatechange = function() {

                if (this.readyState !== 'complete') {

                    $("#mpesa_fancy_loader").show();

                }
                if (this.readyState == 4 && this.status == 200) {

                    $("#mpesa_fancy_loader").hide();

                    let response = JSON.parse(this.responseText);
                    let output = "";

                    if (response == null) {
                        output += `
                            <option value="">
                                --No students found--
                            </option>
                        `;
                    }else{

                        for(let item of response) {
                            output += `
                                <option value="${item.Admission_No}">
                                    ${item.First_Name} ${item.Last_Name}
                                </option>
                            `;
                        }
                    }

                    holdContainer.innerHTML = output;
                }
            }
            xhr.open("POST", "../includes/script.php");
            xhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            xhr.send("classId="+selectedClass);

        }        


        function msPay() {

            let ms_form = document.querySelector("#msForm"),
            suc = document.querySelector("#success"),
            err = document.querySelector("#error");


            let amount = $("#amount").val();
            let details = $("#details").val();
            let term = $("#msc_term").val();
            let year = $("#msc_year").val();
            let sid = $("#sid").val();

            let data = { amount, details, term, year, sid }

            ms_form.onsubmit = (e) => { e.preventDefault(); }

            // ajax
            $.ajax({
                url: 'includes/miscellaneous.php',
                method: 'POST',
                data: data,
                success: function(data) {

                    let response = JSON.parse(data);

                    $.each(response, function(index, item) {

                        if (item.status == 'true') {

                            suc.textContent = item.message;
                            suc.style.display = 'block';
                            err.style.display = 'none';

                        }else
                        {
                            err.textContent = item.message;
                            err.style.display = 'block';
                            suc.style.display = 'none';
                        }
                    })
                },
                beforeSend: function() {

                     $("#ms_loader").show();
                     $("#fancy_loader").show();

                },
                complete: function() {

                    $("#ms_loader").hide();
                    $("#fancy_loader").hide();

                }
            });

        }       

        const hash = document.location.hash;
        const routeIdJS = <?php echo $route_id;?> 
        if (hash) {
        if (routeIdJS == 1) {
            document.getElementById("collect_fees").click();
            document.getElementById("fee_ht").click();
        }else if (routeIdJS == 2) {
            document.getElementById("collect_fees").click();
        }
        }
         //get hash value

         //pay via mpesa
         function payMpesa() {

            let mpesa_form = document.querySelector("#mpesa_form");
            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");

            mpesa_form.onsubmit = (e) => {

                e.preventDefault();

            }

            let payment_code = '<? echo $pc; ?>';
            let sid = '<? echo $sid; ?>'

            let data = {
                mpesa_phone: $("#mpesa_phone").val(),
                mpesa_amount: $("#mpesa_amount").val(),
                mpesa_desc: $("#mpesa_details").val(),
                payment_code: payment_code,
                sid: sid
            }

            //ajax
            $.ajax({
                url: 'includes/mpesa-controller.php',
                method: 'POST',
                data: data,                
                success: function(data) {

                    $.each(JSON.parse(data), function(index, item) {

                        if (item.ResponseCode == "0") {

                            suc.textContent = item.ResponseDescription;
                            suc.style.display = 'block';
                            err.style.display = 'none'


                        }else if(item.errorCode !== " "){

                            err.textContent = item.errorMessage;
                            err.style.display = 'block';
                            suc.style.display = 'none';

                        }else{

                            err.textContent = item.ResponseDescription;
                            err.style.display = 'block';
                            suc.style.display = 'none';

                        }

                    });
                },
                beforeSend: function() {

                    $("#mpesa_fancy_loader").show();

                },
                complete: function() {

                    $("#mpesa_fancy_loader").hide();

                }
            });
        }

         //balance payment
        function paymentBal() {
        let bal_form = document.getElementById('payBal');
        let errorText = document.querySelector("#error");
        let sucText = document.querySelector("#success");
        let pendText = document.querySelector("#pending");

        bal_form.onsubmit = (e) => {
            e.preventDefault();
        }

        //lets start jquery ajax
        let balXhr = new XMLHttpRequest;

        balXhr.onreadystatechange = function(){

            if (this.readyState !== 'complete') {
                $("#bal_loader").show();
            }

            if (balXhr.readyState === XMLHttpRequest.DONE) {
                $("#bal_loader").hide();

                if (balXhr.status == 200) {
                    let response = JSON.parse(this.responseText);

                    if (response !== null && response !== undefined && response !== "") {
                        for(let item of response){
                            if (item.status == 'true') {
                                sucText.textContent = item.message;                                    
                                sucText.style.display = "block";
                                errorText.style.display = "none";
                                pendText.style.display = "none";
                                pay_modal.style.display = "none";
                            }else{
                                errorText.textContent = item.message;                                    
                                errorText.style.display = "block";
                                sucText.style.display = "none";
                                pendText.style.display = "none";
                            }
                        }
                    }else{
                        errorText.textContent = "Response is null or undefined!";                                   
                        errorText.style.display = "block";
                    }
                }else{
                    errorText.textContent = "Server Responded with 404!";                                    
                    errorText.style.display = "block";
                }
            }
        }
        balXhr.open("POST", "includes/bal.php");
        let balFormData = new FormData(bal_form);

        balXhr.send(balFormData);

        }
         //the end of this function
        
        var index = hash.indexOf("#");
        if (index !== -1)
        {
            var hash_val = hash.substring(index + 6);
        }

        // Get the modal
        let pay_modal = document.getElementById("payModal");

        // Get the button that opens the modal
        var pay_btn = document.getElementById("payBtn");

        // Get the <span> element that closes the modal
        var pay_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        pay_btn.onclick = function() {
          pay_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        pay_span.onclick = function() {
          pay_modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == pay_modal) {
            pay_modal.style.display = "none";
          }
        }

        let ms_modal = document.getElementById("msModal");

        // Get the button that opens the modal
        var ms_btn = document.getElementById("msBtn");

        // Get the <span> element that closes the modal
        var ms_span = document.getElementById("ms_span");

        // When the user clicks the button, open the modal 
        ms_btn.onclick = function() {
          ms_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        ms_span.onclick = function() {
          ms_modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == ms_modal) {
            ms_modal.style.display = "none";
          }
        }


        // Get the modal
        var modal = document.getElementById("myModal");

        // Get the button that opens the modal
        var btn = document.getElementById("myBtn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
        }

        // Get the mpesa modal
        var mpesa_modal = document.getElementById("mpesaModal");

        // Get the button that opens the modal
        var mpesa_btn = document.getElementById("mpesaBtn");

        // Get the <span> element that closes the modal
        var mpesa_span = document.getElementsByClassName("close_mpesa")[0];

        // When the user clicks the button, open the modal 
        mpesa_btn.onclick = function() {
          mpesa_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        mpesa_span.onclick = function() {
          mpesa_modal.style.display = "none";
        }



        // Get the siblings modal
        var sibling_modal = document.getElementById("siblingModal");

        // Get the button that opens the modal
        var sibling_btn = document.getElementById("siblingBtn");

        // Get the <span> element that closes the modal
        var sibling_span = document.getElementById("close_sibling");

        // When the user clicks the button, open the modal 
        sibling_btn.onclick = function() {
          sibling_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        sibling_span.onclick = function() {
          sibling_modal.style.display = "none";
        }

        window.onclick = function(event) {
          if (event.target == sibling_modal) {
            sibling_modal.style.display = "none";
          }
        }

        function editProfile(){
            const editForm = document.querySelector("#editStudent"),
            btn =  document.querySelector("#editProf"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");
            pendText = document.querySelector("#pending");

            editForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }

            //let's start ajax
            let stdEditXhr = new XMLHttpRequest(); //creating xml object

            stdEditXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                }

                if (stdEditXhr.readyState === XMLHttpRequest.DONE) {
                    $("#ajax_loader").hide();

                    if (stdEditXhr.status === 200) {                     

                        let response = JSON.parse(this.responseText);
                        if (response !== undefined && response !== null && response !== "") {

                            for(let item of response){
                                if (item.status == "true") {
                                    sucText.textContent = item.message;                                    
                                    sucText.style.display = "block";
                                    pendText.style.display = "none";
                                    // modal.style.display = "none";
                                    // errorText.style.display = "none";
                                }else{
                                    errorText.textContent = item.message;
                                    errorText.style.display = "block";
                                    sucText.style.display = "none";
                                }
                            }                            
                        }else{
                            errorText.textContent = "Response is null or undefined!";
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                        
                    }
                }
            }
            
  

            stdEditXhr.open("POST", "includes/student-edit.php");
            let stdFormData = new FormData(editForm);
           
            stdEditXhr.send(stdFormData);
        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function pendRemove() {
            pend = document.querySelector('#pending');

            pend.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
        function clearForm() {
            // sessionStorage.clear();
            $('#allocateForm').trigger("reset");
            // console.log("session cleared");
        }
        
    </script>


</body>
</html>

<?php  }}?>