<?php
session_start();
error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Attendance</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>
    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3>Student Attendance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <!-- body -->
                <div class="promote_container">
                    <div class="promote_header">
                        <h3>Select Criteria</h3>
                    </div>
                    <div class="promote_content" placeholder='Search Term..'>
                        <select id="promote_select" name="atd_term" onchange="getTerm();">
                            <option value="">--Select term --</option>
                            <?php 
                            $termSQL = "SELECT id,term, year FROM tbl_term ORDER BY id ASC";
                            $termQuery =$dbh->prepare($termSQL);
                            $termQuery->execute();
                            $termResult = $termQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($termResult)) {
                                foreach ($termResult as $key => $val) {
                                    // code...
                            ?>
                            <option value="<?php echo $val->year; ?>">
                                [Term<?php echo $val->term; ?>] -
                                <?php echo $val->year; ?>
                            </option>
                            <?php }}?>
                            
                        </select>

                        <select id="atd_class" name="atd_class" onchange="getTermClass();">
                            <?php 
                            $classSQL = "SELECT id, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->id; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>

                        

                        <select id="atd_sdt" name="atd_sdt" onchange="getTermSdt();">
                            <?php 
                            $stSQL = "SELECT id, First_Name, Last_Name FROM student ORDER BY id ASC";
                            $stQuery =$dbh->prepare($stSQL);
                            $stQuery->execute();
                            $stResult = $stQuery->fetchAll(PDO::FETCH_OBJ);
                            if (!empty($stResult)) {
                                foreach ($stResult as $key => $val) {
                                    // code...
                            ?>
                            <option value="<?php echo $val->id; ?>">
                                <?php echo $val->First_Name; ?>
                                <?php echo $val->Last_Name; ?>
                            </option>
                            <?php }}?>
                        </select>

                    </div>
                </div>
                
                <div class="student_list">
                    <div class="student_list_header">
                        <p class="title">Student attendance over the years.</p>
                        <a onclick="loader();" style="color:var(--sec-white);" href="mark-attendance.php">
                            <button id="m_btn">
                                <i class="fa fa-check"></i>
                                Mark Attendance
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </a>
                    </div>
                    <table id="student-list" class="display table">
                        <thead>
                            <tr>
                                <td>Adm No</td>
                                <td>Name</td>
                                <td>Class</td>
                                <td>Stream</td>
                                <td>Day Attended</td>
                                <td>Status</td>                                
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- TBODY //TABLE ROW  -->
                            <?php 
                            $atd = "SELECT attendance.student_id, 
                            attendance.status,
                            attendance.day_attended,
                            attendance.day_attended,
                            student.id,
                            student.First_Name,
                            student.Last_Name, 
                            student.Class_Id,
                            student.Section,
                            student.Admission_No,
                            student.disabled
                            FROM attendance JOIN student ON 
                            student.id = attendance.student_id WHERE disabled = 0
                            ";
                            $atdQuery = $dbh->prepare($atd);
                            $atdQuery->execute();
                            $atdResult = $atdQuery->fetchAll(PDO::FETCH_OBJ);
                            if (!empty($atdResult)) {
                                foreach ($atdResult as $key => $val) {

                            ?>
                            <tr>
                                <td><?php echo $val->Admission_No; ?></td>             
                                <td>
                                    <?php echo $val->First_Name; ?>
                                    <?php echo $val->Last_Name; ?>
                                </td>
                                <td>Grade <?php echo $val->Class_Id; ?></td>
                                <td><?php echo $val->Section; ?></td>
                                <td><?php echo $val->day_attended; ?></td>
                                <td class="atd_status">
                                    <?php if($val->status == 1){?>
                                    <p class="atd_status_ok">
                                        <i class="fa-solid fa-check"></i>Present
                                    </p>
                                    <?php }elseif($val->status == 3) {?>
                                    <p class="atd_status_er">
                                        <i class="fa-solid fa-xmark"></i>Absent
                                    </p>
                                    <?php }elseif($val->status == 2){?>
                                    <p class="atd_status_hlf">
                                        <i class="fa-solid fa-arrows-split-up-and-left"></i>Half-Day
                                    </p>
                                    <?php }?>
                                </td>

                                <td>Delete</td>        
                            </tr>
                            <?php }}?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script> 
    <script type="text/javascript">
        $(document).ready(function(){
            $("#ajax_loader").hide();
        });
        function loader() {
            $("#ajax_loader").show();
        }
    </script>   

</body>
</html>

<?php }}?>