<?php
session_start();
// error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $error = null;
        $suc = null;
        $r_id = 0;
        $r_id_c_f = 2; 

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Info</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">

    <script>
    if ( window.history.replaceState ) {
      window.history.replaceState( null, null, window.location.href );
    }
    </script>

</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="pendRemove();" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->
    

    <?php require('includes/header.php'); ?>

    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Student Information</h3>
            </div>
            <?php require 'side.php';?>

            
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, student list!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Student List</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="../assets/images/icons/list.svg">Student List</p> 

                    <div>
                        <select id="filterGrade">
                            <option value="" >--Filter by class--</option>
                            <?php 
                            $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->cid; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>

                        <select id="filterGender">
                            <option value="">--Filter by gender--</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>

                    <div class="top_action">
                        <button id="editBtn" class="btn">
                            <i class="fa fa-edit"></i>
                            Edit
                        </button>

                        <a href="create_student.php">
                            <button class="btn">
                                <i class="fa fa-add"></i>
                                Add
                            </button>
                        </a>
                    </div>
                </div>

                <div class="student_list">
                    <table id="student_table" class="display table">
                        <thead>
                            <tr>
                                <td>Adm No</td>
                                <td>Name</td>
                                <td>Phone</td>
                                <td>Class</td>
                                <td>Section</td>
                                <td>Gender</td>
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>                           
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>


     <!-- The Modal -->
    <div id="editModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php //echo $res->First_Name; ?> 
                <?php //echo $res->Last_Name; ?> &mdash; Students Information!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <!-- FILTER CLASSES FOR THE  STUDENT -->
                <div class="edit_all_container">
                    <div class="edit_group">
                        <label>Class</label>
                        <select id="class" onchange="getSelected(this.options[this.selectedIndex].value)">
                            <option value="">--Select Class--</option>
                            <?php 
                            $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->cid; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>
                    </div>
                    <div class="edit_group">
                        <label>Student</label>
                        <select id="sdt_class" onclick="getStudent(this.options[this.selectedIndex].value)">
                            <option value="" selected>--Select Student--</option>
                        </select>
                    </div>
                </div>
                <!-- FILTER CLASSES FOR THE  STUDENT -->

                <!-- FILTERED DATA APPEARS HERE -->
                <div id="filtered" class="filtered_data">
                    <!-- filtered data here -->
                    <div id="loader_fil" class="loader_fil">
                        <div class="filter_loader">
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>
                    </div>
                </div>
                <!-- SUBMIT BUTTON -->
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editProfile();">
                        <i class="fa fa-add"></i>
                        Update Student
                        <img id="ajax_loader" src="../assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <div onclick="this.style.display = 'none'" class="fancy_loader" id="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>   

    <script>

        $('#fancy_loader').show();

        //on load get students
        let studentTable = $('#student_table').DataTable({
            'buttons': [ 'copy', 'csv', 'excel', 'pdf', 'print' ],
            'processing': false,
            'serverSide': true,
            'serverMethod': 'POST',
            'searching': true,
            // ajax
            'ajax': {
                'url': 'includes/st_get.php',
                'data': function (data) {
                    // read value
                    let gender = $('#filterGender').val();
                    let grade = $('#filterGrade').val();

                    // apend data
                    data.gender = gender;
                    data.grade = grade;
                },
                beforeSend: function () {
                    $('#fancy_loader').show();
                },
                complete: function () {
                    $('#fancy_loader').hide();
                }
            },
            'columns': [
                { data: 'Admission_No', 'orderable': true },
                { data: 'Name', 'orderable': false },
                { data: 'Phone', 'orderable': false },
                { data: 'Grade', 'orderable': false },
                { data: 'Section' },
                { data: 'Gender' },
                { data: "View",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data) { // render event defines the markup of the cell text 

                        let a = `<p class="student_edit">
                                    <a style="color: #222; font-weight: 700;" class="edit" href="student-view.php?s_id=${data}&route_id=<?php echo $r_id;?>">
                                        <i class="fa fa-user"></i>
                                        Profile

                                    </a>
    
                                    <button class="delete" onclick="stDelete(this.value)" value="${data}">
                                        <i class="fa fa-trash"></i>
                                        Delete
                                    </button>
                                </p>`; // row object contains the row data
                        return a;
                    }
                },
            ],
            'columnDefs': [{
                orderable: false,
                ordering: false,
                targets: [2,3,4,5]  //Here we disable sorting fearure for few cols
            }],
        });

        $(document).ready(function(){
            $("#ajax_loader").hide();
            $("#std_loader").hide();
            $("#loader_fil").hide();

            //draw table on load
            studentTable.draw();            

            $('#filterGrade').change(function(){
                studentTable.draw();
            });

            $('#filterGender').change(function(){
                studentTable.draw();
            });
        });

        // function to delete student
        function stDelete(value) {

            $('#fancy_loader').show();

            let err = document.querySelector("#error"),
            suc = document.querySelector("#success");

            let proceed = confirm('Are you sure you want to delete this student?');
            let id = value;

            console.log(id);

            if (proceed) {
                // ajax
                $.ajax({
                    url: 'includes/st_del.php',
                    method: 'POST',
                    data: {id:id},
                    success: function (response) {
                        //response
                        $.each(JSON.parse(response), function(index, item){

                            if (item.status == 'true') {
                                suc.textContent = item.message;
                                suc.style.display = 'block';
                                err.style.display = 'none'
                                //redraw the table
                                studentTable.draw();
                            }else{
                                err.textContent = item.message;
                                err.style.display = 'block';
                                suc.style.display = 'none'
                            }

                        })
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown){
                        alert("Something is wrong!");
                    },
                    complete: function () {
                        $('#fancy_loader').hide();
                    }
                })
            }else{
                $('#fancy_loader').hide();
            }
        }

        // Get the modal
        var modal = document.getElementById("editModal");

        // Get the button that opens the modal
        var btn = document.getElementById("editBtn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
      }

      function editProfile(){
            const editForm = document.querySelector("#editStudent"),
            btn =  document.querySelector("#editProf"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");
            pendText = document.querySelector("#pending");

            editForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }

            //let's start ajax
            let stdEditXhr = new XMLHttpRequest(); //creating xml object

            stdEditXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                }

                if (stdEditXhr.readyState === XMLHttpRequest.DONE) {
                    $("#ajax_loader").hide();

                    if (stdEditXhr.status === 200) {                     

                        let response = JSON.parse(this.responseText);
                        if (response !== undefined && response !== null && response !== "") {

                            for(let item of response){
                                if (item.status == "true") {
                                    sucText.textContent = item.message;                                    
                                    sucText.style.display = "block";
                                    pendText.style.display = "none";
                                    // modal.style.display = "none";
                                    // errorText.style.display = "none";
                                }else{
                                    errorText.textContent = item.message;
                                    errorText.style.display = "block";
                                    sucText.style.display = "none";
                                }
                            }                            
                        }else{
                            errorText.textContent = "Response is null or undefined!";
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                        
                    }
                }
            }
            
  

            stdEditXhr.open("POST", "includes/student-edit.php");
            let stdFormData = new FormData(editForm);
           
            stdEditXhr.send(stdFormData);
        }

      function getSelected(value) {
        let selectedClass = value;

        let holdContainer = document.querySelector("#sdt_class");

        let xhr = new XMLHttpRequest();

        xhr.onreadystatechange = function() {

            if (this.readyState !== 'complete') {
                $('#fancy_loader').show();
            }

            if (this.readyState == 4 && this.status == 200) {

                $('#fancy_loader').hide();

                let response = JSON.parse(this.responseText);
                let output = "";

                if (response == null) {
                    output += `
                        <option value="">
                            --No students found--
                        </option>
                    `;
                }else{

                    for(let item of response) {
                        output += `
                            <option value="${item.s_id}">
                                ${item.First_Name} ${item.Last_Name}
                            </option>
                        `;
                    }
                }

                holdContainer.innerHTML = output;
            }
        }
        xhr.open("POST", "../includes/script.php");
        xhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
        xhr.send("classId="+selectedClass);

    }

    function getStudent(value) {
        let student = value;

        let store = document.querySelector("#filtered");

        let stXhr = new XMLHttpRequest();

        stXhr.onreadystatechange = function() {

            if (this.readyState !== 'complete') {

                $('#fancy_loader').show();
            }

            if (this.readyState == 4 && this.status == 200) {

                $('#fancy_loader').hide();

                let response = JSON.parse(this.responseText);
                let output = "";

                if (response == null) {
                    output += `
                        <div class="edit_group">
                            <label>Error</label>
                            <p>Something is wrong on the server side, cause you selected an existing student!</p>
                        </div>
                    `;
                }else{

                    for(let item of response) {
                        output += `
                            
                                <div class="edit_group">
                                    <label>First Name</label>
                                    <input value="${item.First_Name}" type="text" name="first_name" >
                                </div>

                                <div class="edit_group">
                                    <label>Last Name</label>
                                    <input value="${item.Last_Name} " type="text" name="last_name" >
                                </div>

                                <div class="edit_group">
                                    <label>Surname</label>
                                    <input value="${item.Surname}" type="text" name="surname" >
                                </div>
                                <div class="edit_group">
                                    <label>Admission Number</label>
                                    <input value="${item.Admission_No}" type="text" name="adm_no" >
                                </div>

                                <div class="edit_group">
                                    <label>Assessment Number</label>
                                    <input value="${item.Assessment_No}" type="text" name="ass_no" >
                                </div>
                                <div class="edit_group">
                                    <label>Gender</label>
                                    <input value="${item.Gender}" type="text" name="gender" >
                                </div>
                                <div class="edit_group">
                                    <label>D.O.B</label>
                                    <input value="${item.Dob}" type="text" name="dob" >
                                </div>
                                <div class="edit_group">
                                    <label>UPI</label>
                                    <input value="${item.UPI}" type="text" name="upi" >
                                </div>
                                <div class="edit_group">
                                    <label>Admission Date</label>
                                    <input value="${item.Admission_Date}" type="text" name="adm_date" >
                                </div>
                                <div class="edit_group">
                                    <label>Residence</label>
                                    <input value="${item.Residence}" type="text" name="residence" >
                                </div>
                                <div class="edit_group">
                                    <label>Father Name</label>
                                    <input value="${item.Father_Name}" type="text" name="father_name" >
                                </div>
                                <div class="edit_group">
                                    <label>Mother Name</label>
                                    <input value="${item.Mother_Name}" type="text" name="mother_name" >
                                </div>
                                <div class="edit_group">
                                    <label>Phone(1)</label>
                                    <input value="${item.Phone}" type="text" name="phone" >
                                </div>
                                <div class="edit_group">
                                    <label>Phone(2)</label>
                                    <input value="${item.Sec_Phone}" type="text" name="sec_phone" >
                                </div>
                                <div class="edit_group">
                                    <label>Email</label>
                                    <input value="${item.Parent_Email}" type="text" name="email" >
                                </div>
                                <div class="edit_group">
                                    <label>Address</label>
                                    <input value="${item.Parent_Address}" type="text" name="address" >
                                </div>
                                <div class="edit_group">
                                    <label>Notes</label>
                                    <input value="${item.Notes}" type="text" name="notes" >
                                </div>
                                <div style="display:none">
                                    <input value="${item.st_id}" type="text" name="sid_edit">
                                </div>
                            
                        `;
                    }
                }

                store.innerHTML = output;
            }
        }
        stXhr.open("POST", "../includes/script.php");
        stXhr.setRequestHeader("content-type", "application/x-www-form-urlencoded");
        stXhr.send("sid="+student);
    }

    function errRemove() {
        let err = document.querySelector('#error');
        

        err.style.display = "none";
    }
    function pendRemove() {
        pend = document.querySelector('#pending');

        pend.style.display = "none";
    }
    function sucRemove() {
        suc = document.querySelector('#success');

        suc.style.display = "none";
    }
    function clearForm() {
        // sessionStorage.clear();
        $('#allocateForm').trigger("reset");
        // console.log("session cleared");
    }
      
    </script>

</body>
</html>

<?php }}?>