<?php
session_start();
// error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>
    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3>Student Performance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, performance!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Performance</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="class_performance">
                    <div class="c_container_l_top">
                        <div class="c_container_left">
                            <span><p>Search Any class or admission number below.</p></span>
                        </div>
                        <button>Print Results</button>
                    </div>
                    <div class="student_list">
                        <div class="student_list_header">
                            <h4>Results for all the students.</h4>
                        </div>
                        <table id="performance-list" class="display">
                            <thead>
                                <tr>
                                    <td>Student Id</td>
                                    <td>Adm No</td>
                                    <td>Student Name</td>
                                    <td>Class</td>
                                    <td>Section</td>
                                    <td>View</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                 
                                $retriveResults = $dbh->query("SELECT student.First_Name, student.Last_Name,student.Surname, student.Class_Id, student.Section, student.Admission_No, student.id as s_id,tbl_class.id, tbl_class.class_name FROM student JOIN tbl_class on student.Class_Id = tbl_class.id ORDER BY tbl_class.id");

                                $result=$retriveResults->fetchAll(PDO::FETCH_OBJ);

                                if ($retriveResults->rowCount()) {
                                    foreach ($result as $key => $value) {                                 
                                            
                                ?>
                                <!-- beginning of table row -->
                                <tr>
                                    <td>#<?php echo htmlentities($value->s_id); ?></td>
                                    <td><?php echo htmlentities($value->Admission_No); ?></td>
                                    <td>
                                        <?php echo htmlentities($value->First_Name); ?>&nbsp;
                                        <?php echo htmlentities($value->Surname); ?>&nbsp;
                                        <?php echo htmlentities($value->Last_Name); ?>&nbsp;
                                    </td>
                                    <td><?php echo htmlentities($value->class_name); ?></td>
                                    <td><?php echo htmlentities($value->Section); ?></td>
                                    <td>
                                        <p class="student_edit">
                                            <a style="background: var(--bg-blue) !important;color: white;" class="edit" href="view_performance.php?&s_id=<?php echo htmlentities($value->s_id); ?>&c=<?php echo htmlentities($value->class_name); ?>&s=<?php echo htmlentities($value->Section); ?>">
                                                <img src="../admin/assets/images/icons/white/view.svg">View Results 
                                            </a>
                                        </p>
                                    </td>
                                </tr>
                                <? }} ?>
                                <!-- end of table row -->

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>    
 

</body>
</html>

<?php }}?>