<?php
session_start();
error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        // implement results upload
        if (isset($_POST['marks_upload'])) {

            $s_id = $_POST['std_id'];
            $sbj_id = $_POST['sbj_id'];
            $ts_id = $_POST['ts_id'];
            $marks = $_POST['marks'];
            $grade = $_POST['grade'];
            $term = $_POST['term'];
            $y = $_POST['year'];
            $comment = $_POST['comment'];

            $insert = "INSERT INTO results(student_id, subject_id, teacher_id, marks, grade, term, year, teacher_comment)
                       VALUES(:sid, :sbj, :tsid, :marks, :grade, :term, :y, :c)";
            $insert_q = $dbh->prepare($insert);
            $insert_q->bindParam(':sid', $s_id, PDO::PARAM_STR);
            $insert_q->bindParam(':sbj', $sbj_id, PDO::PARAM_STR);
            $insert_q->bindParam(':tsid', $ts_id, PDO::PARAM_STR);
            $insert_q->bindParam(':marks', $marks, PDO::PARAM_STR);
            $insert_q->bindParam(':grade', $grade, PDO::PARAM_STR);
            $insert_q->bindParam(':term', $term, PDO::PARAM_STR);
            $insert_q->bindParam(':y', $y, PDO::PARAM_STR);
            $insert_q->bindParam(':c', $comment, PDO::PARAM_STR);
            $insert_q->execute();

            $last_insert = $dbh->lastInsertId();

            if ($last_insert) {
                $suc = "Results uploaded successfully";
            }else{
                $error = "Something went wrong";
            }
        }elseif (isset($_POST['upload_content'])) {
            $posted_by = $_SESSION['alogin'];
            $class = $_POST['class'];
            $subject = $_POST['subject'];
            $title = $_POST['title'];
            $content = $_FILES['content']['name'];

            // files encoding before upload
            $temp_file = $_FILES['content']['tmp_name'];
            $newfile = explode('.', $content);

            //generate a random string for the image
            $rand_val = date('YMDHIS') . rand(11, 999999);

            $filename = 'downloads_' .md5($rand_val). '.' .end($newfile);
            // move upload the file
            move_uploaded_file($temp_file, "../assets/images/student/downloads/" .$filename);

            $insert_file = "INSERT INTO downloads(subject_id, class, title, content, posted_by)VALUES(:s, :c, :t, :ct, :pb)";

            $file_q = $dbh->prepare($insert_file);
            $file_q->bindParam(':s', $subject, PDO::PARAM_STR);
            $file_q->bindParam(':c', $class, PDO::PARAM_STR);
            $file_q->bindParam(':t', $title, PDO::PARAM_STR);
            $file_q->bindParam(':ct', $filename, PDO::PARAM_STR);
            $file_q->bindParam(':pb', $posted_by, PDO::PARAM_STR);
            $file_q->execute();
            $last_inset_file = $dbh->lastInsertId();
            if ($last_inset_file) {
                $suc = "File uploaded successfully";
            }else{
                $error = "Something Went wrong";
            }

        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Center</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->


    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-upload"></i>
                <h3>Portfolio Upload</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, upload student content!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Upload</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="upload_container">
                    <div class="upload_top">
                        <h3>Upload Student Content</h3>
                    </div>
                    <div class="upload_content">
                        <div class="upload_content_left">
                            <h3>Upload content here below!</h3>
                            <div class="upload_tabs">
                                <button id="defaultUploadOpen" class="upload_links" onclick="openUpload(event, 'results')">Student Results</button>
                                <button class="upload_links" onclick="openUpload(event, 'learning')">Learning Content</button>
                                <button id="add_event" class="upload_links" onclick="openUpload(event, 'events')">Events</button>
                                <button class="upload_links" onclick="openUpload(event, 'notice_board')">Notice Board</button>
                            </div>

                            <!-- UPLOAD TAB CONTENT -->
                            <div id="results" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <h5>Upload Results</h5>
                                    <button>Upload Bulk</button>
                                </div>
                                <div class="results_content">
                                    <form action="" method="post" >
                                        <div class="upload_group_container">
                                            <div class="upload_group">
                                                <label>Student Name</label>
                                                <select name="std_id">
                                                    <option value="" disabled>
                                                        --Choose Student--
                                                    </option>

                                                    <?php $std = "SELECT id as stid, First_Name, Last_Name FROM student where disabled = 0";

                                                    $std_query = $dbh->prepare($std);
                                                    $std_query->execute();
                                                    $std_resp = $std_query->fetchAll(PDO::FETCH_OBJ);
                                                    $std_cnt = $std_query->rowCount() > 0;
                                                    if ($std_cnt) {
                                                        foreach ($std_resp as $key => $s_val) {
                                                            // code...
                                                    ?>
                                                    <option value="<?php echo $s_val->stid;?>"><?php echo $s_val->First_Name;?>&nbsp;<?php echo $s_val->Last_Name;?>
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                            </div>
                                            <div class="upload_group">
                                                <label>Subject</label>
                                                <select name="sbj_id">
                                                    <option disabled value="">--Choose Subject--</option>
                                                    <?php 
                                                    $sbj = "SELECT id as sbj_id, subject_name FROM subjects";
                                                    $sbj_query = $dbh->prepare($sbj);
                                                    $sbj_query->execute();
                                                    $sbj_res = $sbj_query->fetchAll(PDO::FETCH_OBJ);
                                                    $sbj_cnt = $sbj_query->rowCount() > 0;

                                                    if ($sbj_query) {
                                                        foreach ($sbj_res as $key => $sbj_val) {


                                                    ?>
                                                    <option value="<?php echo $sbj_val->sbj_id; ?>"><?php echo $sbj_val->subject_name; ?>
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                            </div>
                                            <div class="upload_group">
                                                <label>Teacher</label>
                                                <select name="ts_id">
                                                    <option disabled value="">--Select subject teacher--</option>
                                                    <?php 
                                                    $tchrs = "SELECT id as ts_id, first_name, last_name FROM staff where role = 'Teacher'";
                                                    $tchrs_query = $dbh->prepare($tchrs);
                                                    $tchrs_query->execute();
                                                    $tchrs_res =  $tchrs_query->fetchAll(PDO::FETCH_OBJ);
                                                    $tchrs_cnt = $tchrs_query->rowCount() > 0;

                                                    if ($tchrs_cnt) {
                                                        foreach ($tchrs_res as $key => $tc_val) {

                                                    ?>
                                                    <option value="<?php echo $tc_val->ts_id; ?>"><?php echo $tc_val->first_name; ?>&nbsp;<?php echo $tc_val->last_name; ?>
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                            </div>
                                            <div class="upload_group">
                                                <label>Marks</label>
                                                <input min="1" max="100" placeholder="Subject Marks" type="number" name="marks">
                                            </div>
                                            <div class="upload_group">
                                                <label>Grade</label>
                                                <input placeholder="Subject Grade" type="text" name="grade">
                                            </div>
                                            <div class="upload_group">
                                                <label>Term</label>
                                                <input min="1" max="3" placeholder="Term" type="number" name="term">
                                            </div>
                                            <div class="upload_group">
                                                <label>Year</label>
                                                <input placeholder="Year" min="2020" max="<?php echo $year; ?>" type="number" name="year">
                                            </div>  
                                        </div>
                                        <div class="upload_group_container_btm">
                                            <div class="upload_group">
                                                <label>Comment</label>
                                                <small style="margin-bottom:10px;font-weight: 600"><code>The comment is about how the student has done, example; Good, Excellent, Fair, Tried. <p style="color: red;">NOTE:</p> DO NOT GIVE NEGATIVE COMMENTS WHICH WILL DEMORALIZE THE STUDENT.</code></small>
                                                <textarea placeholder="Teachers comment" type="text" name="comment" rows="5"></textarea>
                                            </div>
                                            <button type="submit" name="marks_upload">Upload</button>    
                                        </div>                                         
                                    </form>
                                </div>
                            </div>
                            <div id="learning" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <h5>Learning Content for Download</h5>
                                </div>
                                <div class="learning_content">
                                    <form action="" method="post" enctype="multipart/form-data">
                                        <div class="upload_group">
                                            <label>Choose Subject</label>
                                            <select name="subject">
                                                    <option value="">--Choose Subject--</option>
                                                    <?php 
                                                    $sbj = "SELECT id as sbj_id, subject_name FROM subjects";
                                                    $sbj_query = $dbh->prepare($sbj);
                                                    $sbj_query->execute();
                                                    $sbj_res = $sbj_query->fetchAll(PDO::FETCH_OBJ);
                                                    $sbj_cnt = $sbj_query->rowCount() > 0;

                                                    if ($sbj_query) {
                                                        foreach ($sbj_res as $key => $sbj_val) {


                                                    ?>
                                                    <option value="<?php echo $sbj_val->sbj_id; ?>"><?php echo $sbj_val->subject_name; ?>
                                                    </option>
                                                    <?php }}?>
                                                </select>
                                        </div>

                                        <div class="upload_group">
                                            <label>Class</label>
                                            <select name="class">
                                                <option>--Select target Class--</option>
                                                <?php 
                                                $class = "SELECT class_name FROM class";
                                                $c_q = $dbh->prepare($class);
                                                $c_q->execute();
                                                $c_res = $c_q->fetchAll(PDO::FETCH_OBJ);
                                                $c_cnt = $c_q->rowCount() > 0;

                                                if ($c_cnt) {
                                                    foreach ($c_res as $key => $c_val) {
                                                ?>
                                                <option value="<?php echo $c_val->class_name; ?>"><?php echo $c_val->class_name; ?></option>
                                                <?php }}?>
                                            </select>
                                        </div>  

                                        <div class="upload_group">
                                            <label>Description</label>
                                            <textarea placeholder="Describe the material for upload. Include examples..." type="text" name="title" rows="5"></textarea>
                                        </div>
                                        <div class="upload_group">
                                            <label>Upload Content</label>
                                            <small style="margin-bottom:10px;font-weight: 500;"><code><p style="color: red;">NOTE:</p> Select the pdf or word document from where you have saved it. This is for the notes that students can download or read from the site.</code></small>
                                            <input type="file" name="content">
                                        </div>
                                        <button type="submit" name="upload_content">Save Content</button>
                                    </form>
                                </div>
                            </div>
                            <div id="events" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <h5>Update Events</h5>
                                </div>
                                <div class="learning_content">
                                    <form action="" method="post">
                                        <div class="upload_group">
                                            <label>Event Title</label>
                                            <input type="text" name="" placeholder="event title...">
                                        </div>
                                        
                                        <div class="upload_group">                      
                                            <label>Start Date</label>
                                            <?php echo json_encode(date("MDY"));?>
                                            <input min="<?php echo date("MDY");?>" id="start_date" type="text" name="" placeholder="event starts on...">
                                        </div>

                                        <div class="upload_group">
                                            <label>End Date</label>
                                            <input id="end_date" type="text" name="" placeholder="when does the event end?">
                                        </div>

                                        <div class="upload_group">
                                            <label>Event</label>
                                            <textarea type="text" name="" rows="5" placeholder="about the event"></textarea>
                                        </div>
                                        <button type="submit">Add Event</button>
                                    </form>
                                </div>
                            </div>
                            <div id="notice_board" class="upload_tab_content results_container">
                                <div class="results_top">
                                    <h5>Add to the Notice Board</h5>
                                </div>
                                <div class="learning_content">
                                    <form action="" method="post">
                                        <div class="upload_group">
                                            <label>Notice Title</label>
                                            <input type="text" name="" placeholder="Notice title">
                                        </div>
                                        <div class="upload_group">
                                            <label>Notice</label>
                                            <small style="margin-bottom:10px;font-weight: 500;"><code><p style="color: red;">NOTE:</p> Include all the vital information about the notice to the students, all students.</code></small>
                                            <textarea type="text" name="" placeholder="the notice..." rows="5"></textarea>
                                        </div>
                                        <button>Upload to Notice board</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="upload_content_right">
                            <div class="upload_top">
                                <h5>All my uplaods</h5>
                            </div>
                            <div class="uploads">
                                <p>This is a list of all the uploads that you have made.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>
    <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>
      
    <script type="text/javascript">
        $(function() {
            $( "#start_date" ).datepicker();
            $( "#end_date" ).datepicker();

          });
        // click on the the button with defaultOpen on page load
        document.getElementById('defaultUploadOpen').click();
    </script>  

</body>
</html>

<?php }}?>