<?php
session_start();
// error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{
        //get all the id which have been passed through the url
        $sid = $_GET['s_id'];
        $class = $_GET['c'];
        $stream = $_GET['s'];
        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }


        //student details
        $s_sql = "SELECT First_Name, Last_Name FROM student WHERE id = :sid";
        $s_q = $dbh->prepare($s_sql);
        $s_q->bindParam(':sid', $sid, PDO::PARAM_STR);
        $s_q->execute();
        $s_res = $s_q -> fetchAll(PDO::FETCH_OBJ);
        if ($s_q->rowCount() > 0) {
            foreach ($s_res as $key => $res) {
            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?php echo $res->First_Name; ?> <?php echo $res->Last_Name; ?>'s Performance
        <?php echo $year; ?>
    </title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="../assets/fullcalendar/fullcalendar.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>
    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3><?php echo $res->Last_Name; ?>'s Performance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, performance!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>View Performance</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="performance_container">
                    
                    <div class="performance_container_left">
                        <div class="p_container_l_top">
                            <?php 

                            $agpQuery = $dbh->prepare("SELECT student_id, SUM(results.marks) AS agp_r, COUNT(DISTINCT subject_id) as sbj_id FROM results where student_id = :sid");
                            $agpQuery->bindParam(':sid', $sid, PDO::PARAM_STR);
                            $agpQuery->execute();
                            $agpResult = $agpQuery->fetchAll(PDO::FETCH_OBJ);
                            $cnt = $agpQuery->rowCount() > 0;
                            if ($cnt) {
                                foreach ($agpResult as $key => $val) {
                                    $marks = $val->agp_r;
                                    $sbjs = $val->sbj_id;
                                    $overall = $sbjs * 100;
                            ?>
                            <?php if($marks > 0){?>
                            <span><p>Marks</p><p class="grade"><?php echo htmlentities($marks); ?>/<?php echo htmlentities($overall); ?></p> </span>
                            <?php }else{ ?>
                            <span><p>Marks</p><p class="grade">No exams done!</p> </span>
                            <?php
                                    }
                                }
                            }
                            ?>
                            <!-- section agp in percentage -->
                            <?php 
                            $classAgp = "SELECT results.student_id,student.id,student.Class_Id, tbl_class.class_name, tbl_class.id, SUM(marks) as class_marks, COUNT(DISTINCT subject_id) as sbj_id, COUNT(DISTINCT student_id) as st_id FROM results JOIN student ON results.student_id = student.id JOIN tbl_class ON student.Class_Id = tbl_class.id WHERE tbl_class.class_name = :class AND results.year = :y";

                            $class_q = $dbh->prepare($classAgp);
                            $class_q->bindParam(':class', $class, PDO::PARAM_STR);
                            $class_q->bindParam(':y', $year, PDO::PARAM_STR);
                            $class_q->execute();
                            $class_result = $class_q->fetchAll(PDO::FETCH_OBJ);
                            $class_cnt = $class_q->rowCount() > 0;

                            if ($class_cnt) {
                                foreach($class_result as $key => $c_val) {

                                    //class marks is
                                    $total_students = $c_val->st_id;
                                    $total_marks = $c_val->class_marks;
                                    $total_subjects = $c_val->sbj_id;

                                    if ($total_students = null) {
                                        $total_students = 1;
                                    }elseif($total_marks = null) {
                                        $total_marks = 1;
                                    }elseif ($total_subjects = null) {
                                        $total_subjects = 1;
                                    }

                                    $final_agp = ($total_marks / $total_students) / $total_subjects;
                                }
                            }else{
                                $total_students = 0;
                                $total_marks = 0;
                                $total_subjects = 0;

                                $final_agp = 0;
                            }


                            ?>

                            <span><p>Class AGP</p><p class="grade"><?php echo sprintf('%0.2f', round($final_agp, 2)); ?>%</p> </span>
                    

                            <!-- SECTION AGP FOR THIS A PARTICULAR TERM in percent -->
                            <?php 
                            $streamAgp = "SELECT results.student_id,student.id,student.Section,student.Class_Id, tbl_class.class_name, SUM(marks) as section_marks, COUNT(DISTINCT subject_id) as sbj_id, COUNT(DISTINCT student_id) as st_id FROM results JOIN student ON results.student_id = student.id JOIN tbl_class ON student.Class_Id = tbl_class.id WHERE student.Section = :s AND results.year = :y AND class_name = :c";

                            $stream_q = $dbh->prepare($streamAgp);
                            $stream_q->bindParam(':s', $stream, PDO::PARAM_STR);
                            $stream_q->bindParam(':c', $class, PDO::PARAM_STR);
                            $stream_q->bindParam(':y', $year, PDO::PARAM_STR);
                            $stream_q->execute();
                            $stream_result = $stream_q->fetchAll(PDO::FETCH_OBJ);
                            $stream_cnt = $stream_q->rowCount() > 0;

                            if ($stream_cnt) {
                                foreach($stream_result as $key => $s_val) {

                                    //class marks is
                                    $total_students = $s_val->st_id;
                                    $total_marks = $s_val->section_marks;
                                    $total_subjects = $s_val->sbj_id;

                                    if ($total_students = null) {
                                        $total_students = 1;
                                    }elseif($total_marks = null) {
                                        $total_marks = 1;
                                    }elseif ($total_subjects = null) {
                                        $total_subjects = 1;
                                    }

                                    $final_agp = ($total_marks / $total_students) / $total_subjects;
                                }
                            }else{
                                $final_agp = 0;
                            }
                            ?>
                            <span><p>Section AGP</p><p class="grade"><?php echo sprintf('%0.2f', round($final_agp, 2)); ?>%</p> </span>

                            <!-- CLASS AND STREAM NAMES -->
                            <span><p>Class: <?php echo $class; ?></p><p>Section: <?php echo $stream; ?></p> </span>
                        </div>
                        <div class="student_list">
                            <table id="performance-list" class="display table">
                                <thead>
                                    <tr>
                                        <td>Subject</td>
                                        <td>Marks</td>
                                        <td>Grade</td>
                                        <td>Teacher</td>
                                        <td>Teacher's Comment</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                                                                                                        
                                        $viewResult = "SELECT subjects.*, results.*,staff.first_name,staff.last_name,staff.role, student.First_Name, student.Last_Name,student.Surname, student.Section, student.Admission_No, student.id  FROM results JOIN student ON results.student_id = student.id JOIN staff ON results.teacher_id = staff.id JOIN subjects ON results.subject_id = subjects.id WHERE results.student_id = :s_id AND results.year = :y ";

                                        $query = $dbh->prepare($viewResult);
                                        $query->bindParam(':s_id', $sid, PDO::PARAM_STR);
                                        $query->bindParam(':y', $year, PDO::PARAM_STR);
                                        $query->execute();
                                        $results = $query->fetchAll(PDO::FETCH_OBJ);
                                        if ($query->rowCount() > 0) {
                                            foreach ($results as $key => $res) {
                                                
                                    ?>
                                    <tr>
                                        <td><?php echo htmlentities($res->subject_name); ?></td>
                                        <td><?php echo htmlentities($res->marks); ?></td>
                                        <td><?php echo htmlentities($res->grade); ?></td>
                                        <td style="text-transform: capitalize;">
                                            <?php echo htmlentities($res->first_name); ?>
                                            <?php echo htmlentities($res->last_name); ?>
                                                
                                        </td>
                                        <td><?php echo htmlentities($res->teacher_comment); ?></td>
                                    </tr>
                                    <?         // code...
                                            }
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="performance_container_right">
                        <div class="p_container_r_top">
                            <div class="chart_box">
                                <span style="text-align: center;color: var(--bg-blue);font-weight: 600;text-decoration: underline;">
                                    <p><?php echo htmlentities($res->First_Name); ?>
                                        <?php echo htmlentities($res->Last_Name); ?>'s  Performance chart per term.
                                    </p>
                                </span>
                                <!-- ======== PERFORMANCE PER TERM CHART====== -->
                                <?php 
                                $p_chart = "SELECT student_id, COUNT(DISTINCT subject_id) as sbj_id_count, SUM(marks) as chart_marks, term, year FROM results WHERE student_id = :sid and year = :y group by term";
                                $chart_q = $dbh->prepare($p_chart);
                                $chart_q->bindParam(':sid', $sid, PDO::PARAM_STR);
                                $chart_q->bindParam(':y', $year, PDO::PARAM_STR);
                                $chart_q->execute();
                                $chart_rest = $chart_q->fetchAll(PDO::FETCH_OBJ);
                                $chart_cnt = $chart_q->rowCount() > 0;

                                if ($chart_cnt) {
                                    foreach ($chart_rest as $key => $chart_val) {
                                        
                                        //values here
                                        $c_marks = $chart_val->chart_marks;
                                        $c_subjects = $chart_val->sbj_id_count;
                                        $termArray[] = $chart_val->term;

                                        // calculations
                                        $totalPercentArray[] = $c_marks / $c_subjects;


                                    }
                                }else{
                                    $termArray[] =  null;
                                    $totalPercentArray[] = null;
                                }
                                ?>
                                <canvas id="myPerformance"></canvas>
                            </div>
                        </div>
                        <div class="p_container_r_btm">
                            <h3>Actions on the report</h3>
                            <span>Export to PDF <a href=""><img src="../assets/images/icons/db.svg"></a></span>
                            <span>Download Report <a href=""><img src="../assets/images/icons/download-fill.svg"></a></span>
                            <span>Export Report to Excel <a href=""><img src="../assets/images/icons/excel.svg"></a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="../assets/js/jquery-3.6.0.js"></script>         
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/chart.js"></script>
    <!-- <script src="../assets/js/studentChartData.js"></script> -->
    <script src="../assets/js/table.js"></script>  
    <script src="../assets/fullcalendar/lib/moment.min.js"></script>
    <script src="../assets/fullcalendar/fullcalendar.min.js"></script>
    <script src="../assets/js/calendar.js"></script>

    <script type="text/javascript">
    let termArrayJS = <?php echo json_encode($termArray);?>;
    let percentArrayJS = <?php echo json_encode($totalPercentArray); ?>;

    const myPerformance = {
    labels: termArrayJS,
    datasets: [{
      label: 'Performance Per Term',
      data: percentArrayJS,
      backgroundColor: [
        'rgba(255, 26, 104, 0.2)',
        'rgba(54, 162, 235, 0.2)',
        'rgba(255, 206, 86, 0.2)',
      ],
      borderColor: [
        'rgba(255, 26, 104, 1)',
        'rgba(54, 162, 235, 1)',
        'rgba(255, 206, 86, 1)',
      ],
      borderWidth: 1
    }]
    };

    // config 
    const configPerformance = {
    type: 'bar',
    data: myPerformance,
    options: {
      scales: {
        y: {
          beginAtZero: true
        }
      }
    }
    };


    // render init block for performance
    const performance = new Chart(
    document.getElementById('myPerformance'),
    configPerformance
    );
    </script>

</body>
</html>

<?php print_r($termArray);}}?>