<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }



?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suppliers</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Suppliers</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="assets/images/icons/list.svg">Supplier List</p>        

                    <div class="top_action">
                        <button title="Add item category" id="catBtn" class="btn" title="Edit" >
                            <i class="fa-solid fa-plus"></i>
                        </button>
                    </div>
                </div>

                <div class="upload_content">
                    <div class="fee_content_left">
                        <div class="timeline_info">
                            <h3 style="color:var(--bg-purple);">Add Supplier</h3>

                            <div class="category">
                                <form id="supplierForm">
                                    <div class="category_group">
                                        <label>Company Name</label>
                                        <p class="title">* Company where you source the item.</p>
                                        <input type="text" id="company_name" placeholder="Company name or business name">
                                    </div>

                                    <div class="category_group">
                                        <label>Company Address</label>
                                        <p class="title">* Company address.</p>
                                        <input type="text" id="company_address" placeholder="Address">
                                    </div>                                    

                                    <div class="category_group">
                                        <label>Contact Person Name</label>
                                        <input type="text" id="contact_person" placeholder="Name">
                                    </div>

                                    <div class="category_group">
                                        <label>Mobile</label>
                                        <p class="title">* contact person phone.</p>
                                        <input type="text" id="phone" placeholder="Phone">
                                    </div>

                                    <div class="category_group">
                                        <label>Email</label>
                                        <p class="title">* contact person email.</p>
                                        <input type="text" id="email" placeholder="Email">
                                    </div>

                                    <div class="category_group">
                                        <label>Description</label>
                                        <p class="title">* describe supplier.</p>
                                        <textarea rows="5" type="text" id="details" placeholder="Description about supplier"></textarea>
                                    </div>

                                    <div class="category_group">
                                        <button onclick="addSupplier();">
                                            <i class="fa fa-check"></i>
                                            Save
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="fee_content_right">
                        <div class="timeline_info">
                            <table id="student-list" class="display">
                                <thead>
                                    <tr>
                                        <td>#</td>
                                        <td>Company Name</td>
                                        <td>Company Address</td>
                                        <td>Contact Person</td>
                                        <td>Phone</td>
                                        <td>Email</td>
                                        <td>Details</td>
                                        <td>Action</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $fetchSuplier = "SELECT suppliers.* FROM suppliers  order by suppliers.id";
                                    $fetchQ = $dbh->prepare($fetchSuplier);
                                    $fetchQ->execute();
                                    $res = $fetchQ->fetchAll(PDO::FETCH_OBJ);                                    
                                    $cnt = 1;
                                    if ($fetchQ->rowCount() > 0) {
                                        foreach ($res as $key => $r) {
                                    ?>
                                    <tr>
                                        <td><?php echo $cnt; ?></td>
                                        <td><?php echo $r->company_name; ?></td>
                                        <td><?php echo $r->company_address; ?></td>
                                        <td><?php echo $r->contact_person; ?></td>
                                        <td><?php echo $r->phone; ?></td>
                                        <td><?php echo $r->email; ?></td>
                                        <td><?php echo $r->details; ?></td>
                                        <td>
                                            <p class="student_edit">                                        

                                                <button title="Contact This supplier" class="edit" onclick="itemRemove(this.value)" value="<?php echo $r->id; ?>">
                                                    <i class="fa fa-phone"></i>
                                                </button>

                                                <button title="Delete this supplier" class="delete" onclick="itemDelete(this.value)" value="<?php echo $r->id; ?>">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </p>
                                        </td>
                                    </tr>

                                    <?php $cnt += 1; }}?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            </div>
        </div>
    </div>

    <!-- item category modal -->
    <div id="catModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Add Items Category</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="catForm">

                    <div class="pay_group">
                        <label>Category Name</label>
                        <input id="cat_name" type="text" />
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:addCategory();" id="import_btn">
                            Save Category
                            <img id="item_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <div id="cat_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Adding...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  

    <script>

        $(document).ready(function(){

            $("#fancy_loader").hide();
            $("#cat_fancy_loader").hide();
            $("#student_loader").hide();
            $("#ajax_loader").hide();
            $("#teacher_t").hide();
            $("#class_t").hide();


        });

        // Get the modal
        let cat_modal = document.getElementById("catModal");

        // Get the button that opens the modal
        var cat_btn = document.getElementById("catBtn");

        // Get the <span> element that closes the modal
        var cat_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        cat_btn.onclick = function() {
          cat_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        cat_span.onclick = function() {
          cat_modal.style.display = "none";
        }


        function addSupplier() {
            let suc = document.querySelector("#success"),
            supplier_form = document.querySelector("#supplierForm");

            err = document.querySelector("#error");

            supplier_form.onsubmit = (e) => { e.preventDefault() }

            let company_name = $("#company_name").val();
            let company_address = $("#company_address").val();
            let contact_person = $("#contact_person").val();
            let email = $("#email").val();
            let phone = $("#phone").val();
            let details = $("#details").val();

            let data = { company_name, company_address, contact_person, email, phone, details }

                //ajax
            $.ajax({
                url: 'includes/add-supplier.php',
                method: 'POST',
                data: data,
                success: function(data) {  

                    let res = JSON.parse(data);                  

                    if (res.status == true) 
                    {
                        suc.textContent = res.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else 
                    {
                        err.textContent = res.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#cat_fancy_loader").show();

                }, 
                complete: function() {

                    $("#cat_fancy_loader").hide();

                }
            });
        }


        function addCategory() {

            let suc = document.querySelector("#success"),
            cat_form = document.querySelector("#catForm");

            err = document.querySelector("#error");

            cat_form.onsubmit = (e) => { e.preventDefault() }

            let category_name = $("#cat_name").val();

            let data = { category_name }

                //ajax
            $.ajax({
                url: 'includes/add-inventory-category.php',
                method: 'POST',
                data: data,
                success: function(data) {  

                    let res = JSON.parse(data);                  

                    if (res.status == true) 
                    {
                        suc.textContent = res.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';

                    }else 
                    {
                        err.textContent = res.message;
                        err.style.display = 'block';
                        suc.style.display = 'none';

                    }

                },
                beforeSend: function() {

                    $("#cat_fancy_loader").show();

                }, 
                complete: function() {

                    $("#cat_fancy_loader").hide();

                }
            });

        }
       
    </script>
    
</html>

<?php }}?>