<?php
session_start();
// error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{ 

        $error = NULL;

        $suc = NULL; 

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

        

        
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Staff Page</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>
    <!-- //Status Wrap -->
    <?php if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?></div><?php }elseif ($error) {?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }?>
    <!-- //status Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <img src="../assets/images/icons/students.svg">
                <h3>Student Information</h3>
            </div>
            <?php require 'side.php';?>
        </div>
        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query -> fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, welcome to create Staff!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="../dashboard.php">Dashboard</a> | </span>
                    <span><a href="staff_list.php">Staff Info</a> | </span>
                    <span>Add</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="container_top" style="margin-bottom:10px">
                    <p><img src="../assets/images/icons/list.svg">Add Staff Page</p>

                    <div class="top_action">
                        <button id="importBtn">
                            <i class="fa fa-cloud-upload" aria-hidden="true"></i>
                            Import
                        </button>

                        <button class="btn">
                            Add Admin
                            <img id="add_admin_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </div>

                <!-- CREATE STUDENT FORM -->
                <div class="create_form">
                    <form id="staff_form" method="post" >
                        <div class="content_wrap">
                            <p class="category">Role of the Staff</p>
                            <!-- ROLE OF THE STAFF -->
                            <div class="form_content">
                                <div class="form_group">
                                    <select name="role">
                                        <option value="">--Select Role--</option>
                                        <?php 
                                        $sql = "SELECT tbl_roles.role, tbl_roles.id FROM tbl_roles";
                                        $query = $dbh->prepare($sql);
                                        $query->execute();
                                        $res = $query->fetchAll(PDO::FETCH_OBJ);
                                        if ($query->rowCount() > 0) {
                                            foreach ($res as $key => $val) {
                                        ?>
                                        <option value="<?php echo $val->role?>"><?php echo $val->role;?></option>
                                        <?php }}?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="content_wrap">
                            <p class="category">Personal Info:</p>
                            <!-- PERSONAL INFO -->
                            <div class="form_content">
                                <div class="form_group">
                                    <label>First Name</label>
                                    <input type="text" name="first_name" placeholder="First Name" >
                                </div>

                                <div class="form_group">
                                    <label>Last Name</label>
                                    <input type="text" name="last_name" placeholder="Last Name" >
                                </div>

                                <!-- <div class="form_group">
                                    <label>Employee No</label>
                                    <input type="number" name="emp_no" placeholder="Employee No..." >
                                </div> -->

                                <div class="form_group">
                                    <label>Employment Year</label>
                                    <input type="number" name="emp_year" placeholder="Started on..." >
                                </div>

                                <div class="form_group">
                                    <label>Residence</label>
                                    <input type="text" name="residence" placeholder="Area of Residence" >
                                </div>

                                <div class="form_group">
                                    <label>Username</label>
                                    <input type="text" name="username" placeholder="Username..." >
                                </div>

                                <div class="form_group">
                                    <label>Gender</label>
                                    <select name="gender" >
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <!-- <option>Other</option> -->
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- PARENTS/GURDIAN INFO -->
                        <div class="content_wrap">
                            <p class="category">Other Details:</p>
                            <div class="form_content">
                                <div class="form_group">
                                    <label>Staff Email</label>
                                    <input type="email" name="email" placeholder="Enter staff email..." >
                                </div>

                                <div class="form_group">
                                    <label>Phone No</label>
                                    <input type="number" name="phone" placeholder="Enter staff phone" >
                                </div>

                                <div class="form_group">
                                    <label>Address</label>
                                    <input type="text" name="address" placeholder="Enter staff Address" >
                                </div>
                                
                            </div>
                        </div>

                        <!-- OTHER INFO -->
                        <div class="content_wrap">
                            <p class="category">Additional Details:</p>
                            <div class="form_content">
                                <!-- <div class="form_group">
                                    <label>Passport</label>
                                    <input type="text" name="passport" placeholder="Enter class" >
                                </div> -->
                                <div class="form_group">
                                    <label>Additional Notes</label>
                                    <input type="text" name="notes" placeholder="Add notes..." >
                                </div>
                            </div>
                        </div>

                        <!-- FORM BUTTON GROUP -->
                        <div class="btn_group">
                            <button id="staffBtn" type="submit" onclick="addStaff();">
                                <i class="fa-solid fa-check"></i>
                                <p class="ajax_text">Add Staff</p>
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </div>
                    </form>    
                </div>
            </div>
        </div>
    </div>

    <!-- payment modal -->
    <div id="importModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Import Staff</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="importStaff" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Select File</label>
                        <input id="file" type="file" name="file" accept=".csv" />
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:importStaff();" id="import_btn">
                            Import Staff
                            <img id="staff_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- loader -->
    <div id="import_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Importing...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

     <?php include '../includes/footer.php';?>


    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script> 

    <script>
        $(document).ready(function(){
            $("#ajax_loader").hide();
            $("#staff_loader").hide();
            $("#import_loader").hide();
            $("#add_admin_loader").hide();
        });


        // Get the modal
        let staff_modal = document.getElementById("importModal");

        // Get the button that opens the modal
        var staff_btn = document.getElementById("importBtn");

        // Get the <span> element that closes the modal
        var staff_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        staff_btn.onclick = function() {
          staff_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        staff_span.onclick = function() {
          staff_modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == staff_modal) {
            staff_modal.style.display = "none";
          }
        }

        function importStaff() {

            let staff_form = document.querySelector("#importStaff");
            let suc = document.querySelector("#success");
            let err = document.querySelector("#error");


            staff_form.onsubmit = (e) => {

                e.preventDefault();

            }

            //ajax 

            $.ajax({
                url: 'includes/import_staff.php',
                method: 'POST',
                data: new FormData(staff_form),
                contentType:false,          // The content type used when sending data to the server.  
                cache:false,                // To unable request pages to be cached  
                processData:false, 
                success: function(data) {
                    //do something 
                    $.each(JSON.parse(data), function(index, item){
                        suc.textContent = item.message;
                        suc.style.display = 'block';
                        err.style.display = 'none';
                    });
                },
                beforeSend: function() {

                    $("#import_loader").show();
                    $("#staff_loader").show();

                },
                complete: function() {
                    //hide loaders 

                    $("#import_loader").hide();
                    $("#staff_loader").hide();
                }

            });
        }



        function addStaff(){
            const staffForm = document.querySelector("#staff_form"),
            staffBtn =  document.querySelector("#staffBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");

            staffForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let staffXhr = new XMLHttpRequest(); //creating xml object

            staffXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                }

                if (staffXhr.readyState === XMLHttpRequest.DONE) {
                    if (staffXhr.status === 200) {

                        $("#ajax_loader").hide();

                        let response = JSON.parse(this.responseText);                        

                        if (response !== undefined && response !== null && response !== "") {
                            for(let item of response){
                                if (item.status == 'true') {
                                    sucText.textContent = item.message;
                                    sucText.style.display = "block";
                                    errorText.style.display = "none";
                                    clearForm();
                                }else{
                                    errorText.textContent = item.message;
                                    errorText.style.display = "block";
                                    sucText.style.display = "none";
                                    
                                }
                            }
                            
                        }else{
                            errorText.textContent = response;
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                    }
                }
            }
            
  

            staffXhr.open("POST", "includes/staff.php");
            let staffFormData = new FormData(staffForm);
           
            staffXhr.send(staffFormData);

        }
        function clearForm() {
            $('#staff_form').trigger("reset");
            console.log("session cleared");
        }
        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
    </script> 
     
</body>
</html>

<?php }}?>