<?
session_start();

if (empty($_POST['first_name'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Staff first name is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['last_name'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Staff last name is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['emp_year'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Employment year is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['username'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Username is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['email'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Email is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['phone'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Phone is required!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['address'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Address is required!"
    ); 
    echo json_encode(array($error)); 
}elseif(    
    strlen($_POST['phone']) !== 9 &&
    strlen($_POST['phone']) !== 10 &&
    strlen($_POST['phone']) !== 12
){
    $error = array(
        "status" => "false",
        "message" => "Error: This ".$_POST['phone']." is not a valid mobile number!!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['role'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: You must select a role from the dropdown!"
    ); 
    echo json_encode(array($error)); 
}elseif (empty($_POST['gender'])) {
    $error = array(
        "status" => "false",
        "message" => "Error: Gender is required!"
    ); 
    echo json_encode(array($error)); 
}else{
    addStaff();
}



function genRand($len='2')
{
    $cntr = '';
    $chr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $chrLen = strlen($chr);
    for ($i=0; $i < $len; $i++) { 
        $cntr .= $chr[rand(0, $chrLen - 1)];
    }
    return $cntr;
}


function addStaff(){
    require '../../../includes/config.php';

    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    // $emp_no = $_POST['emp_no'];
    $emp_year = $_POST['emp_year'];
    $residence = $_POST['residence'];
    $username = $_POST['username'];
    $gender = $_POST['gender'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $role = $_POST['role'];
    $notes = $_POST['notes'];

    $sdtSql = "SELECT id FROM staff ORDER BY id DESC LIMIT 1";
    $sdtQ= $dbh->prepare($sdtSql);
    $sdtQ-> execute();
    $sdtRes = $sdtQ->fetchAll(PDO::FETCH_OBJ);
    if ($sdtQ->rowCount() > 0) {
        foreach ($sdtRes as $key => $id_val) {
            $id =  $id_val->id;
        }
    }    

    $emp = $id + 1;
    $emp_no = genRand() . $emp;
    $password = md5($first_name.$emp_no);

    if ($_POST['role'] !== '') {

        $sql = "SELECT phone, email, address, username  FROM staff WHERE phone=:p";
        $query= $dbh -> prepare($sql);
        $query->bindParam(':p',$phone,PDO::PARAM_STR);
        $query-> execute();
        if ($query->rowCount() > 0) {
            //throw an err//the user already exists
            $error = array(
                "status" => "false",
                "message" => "Error: This ".$phone." is already taken!"
            ); 
            echo json_encode(array($error)); 
        }else{

            $insertStaff = "INSERT INTO staff(first_name, last_name, username, phone, gender, employee_no, email, address, notes, role, password)values(:fn, :ln,:usr, :p, :g, :en, :e,:a, :n, :r, :ps)";
            $iTq = $dbh->prepare($insertStaff);
            $iTq->bindParam(':fn', $first_name, PDO::PARAM_STR);
            $iTq->bindParam(':ln', $last_name, PDO::PARAM_STR);
            $iTq->bindParam(':usr', $username, PDO::PARAM_STR);
            $iTq->bindParam(':p', $phone, PDO::PARAM_STR);
            $iTq->bindParam(':g', $gender, PDO::PARAM_STR);
            $iTq->bindParam(':en', $emp_no, PDO::PARAM_STR);
            $iTq->bindParam(':e', $email, PDO::PARAM_STR);
            $iTq->bindParam(':a', $address, PDO::PARAM_STR);
            $iTq->bindParam(':n', $notes, PDO::PARAM_STR);
            $iTq->bindParam(':r', $role, PDO::PARAM_STR);
            $iTq->bindParam(':ps', $password, PDO::PARAM_STR);
            
            $iTq->execute();
            $lastInsertId = $dbh->lastInsertId();
            if ($lastInsertId) {
                $error = array(
                    "status" => "true",
                    "message" => "Success: ".$role." created successfully"
                ); 
                echo json_encode(array($error));    
            }else{
                $error = array(
                    "status" => "false",
                    "message" => "Error: Something went wrong. Please Check the fields and try again!"
                ); 
                echo json_encode(array($error));   
            }
        }
    }else{
        $error = "ERROR: Could not determine the role of the staff. Please select a role and try again!";
        $error = array(
            "status" => "false",
            "message" => "ERROR: Could not determine the role of the staff. Please select a role and try again!!"
        ); 
        echo json_encode(array($error));

    }

}

?>