<?
session_start();

if(empty($_POST['status'])) {
	$error = array(
        "status" => "false",
        "message" => "Error: You submited empty fields! Sign-in or Sign-out a staff and try again."
    ); 
    echo json_encode(array($error));
}else{
	attendance();
}
 function attendance() {
 	require_once '../../../includes/config.php';

 	date_default_timezone_set('Africa/Nairobi');

 	$status = $_POST['status'];
 	$staff_id = $_POST['atd_stf_id'];
 	$suc = 0;
 	$error = 0;
 	$year = date("Y");
 	$time = date('h:i:s a');
 	$day = date("D"). " " .date('d-M-Y');
	
	if ($_POST['status'] == "in") {

		$checkSignIn = "SELECT staff_id, signin, creation_day, year FROM staff_attendance WHERE year = :y AND signin IS NOT NULL AND creation_day = :d AND staff_id = :sid";
		$checkSignInQ = $dbh->prepare($checkSignIn);
		$checkSignInQ->execute(array(
			':d' => $day,
			':y' => $year,
			':sid' => $staff_id
		));
		if ($checkSignInQ->rowCount() > 0) {
			$error = array(
		        "status" => "false",
		        "message" => "You can't sign-in a staff twice. Looks like this staff was already signed in today - ".$day."!"
		    );
		    echo json_encode(array($error));
		}else{
			$insert = "INSERT INTO staff_attendance(staff_id, signin, year,creation_day)VALUES(:sid, :si, :y, :d)";
	 		$query = $dbh->prepare($insert);
	        $query->execute(
	            array(
	                ':sid'=> $staff_id, 
	                ':si'=> $time,
	                ':y'=> $year,
	                ':d'=> $day
	            )
	        );
	        $lastInsertId = $dbh->lastInsertId();
	        if ($lastInsertId) {
	        	$suc = array(
			        "status" => "true",
			        "message" => "Staff with ID of ".$staff_id." signed-in at ".$time."!"
			    );
			    echo json_encode(array($suc));
	        }else{
	        	$error = array(
			        "status" => "false",
			        "message" => "Something went wrong!"
			    );
			    echo json_encode(array($error));
	        }
	    }		      

    }else{
    	$checkSignOut = "SELECT staff_id, signout, creation_day, year FROM staff_attendance WHERE year = :y AND signout IS NOT NULL AND creation_day = :d AND staff_id = :sid";
		$checkSignOutQ = $dbh->prepare($checkSignOut);
		$checkSignOutQ->execute(array(
			':d' => $day,
			':y' => $year,
			':sid' => $staff_id
		));
		if ($checkSignOutQ->rowCount() > 0) {
			$error = array(
		        "status" => "false",
		        "message" => "You can't sign-out a staff twice. Looks like this staff was already signed out today - ".$day."!"
		    );
		    echo json_encode(array($error));
		}else{
	 		$insert = "UPDATE staff_attendance SET signout = :so WHERE creation_day = :d AND staff_id = :sid AND year = :y AND signin IS NOT NULL";
	 		$query = $dbh->prepare($insert);
	        $query->execute(
	            array(
	                ':so'=> $time, 
	                ':d'=> $day,
	                ':sid'=> $staff_id,
	                ':y'=> $year
	            )
	        );
	        $lastInsertId = $query->rowCount() > 0;
	        if ($lastInsertId) {
	        	$suc = array(
			        "status" => "true",
			        "message" => "Staff with ID of ".$staff_id." signed-out at ".$time."!"
			    );
			    echo json_encode(array($suc));
	        }else{
	        	$error = array(
			        "status" => "false",
			        "message" => "Looks like you didn't sign-in today!"
			    );
			    echo json_encode(array($error));
	        }
	    }
    }

 }
?>