<?php
session_start();
error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $date = date('m/d/Y h:i:s a', time());

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mark Staff Attendance</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display='none'" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display='none'" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display='none'" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3>Mark Attendance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <div class="promote_container">
                    <div class="promote_header">
                        <h3>Select Criteria</h3>
                    </div>
                    <div class="promote_content">
                        <div class="select_group">
                            <label>Select Staff</label>
                            <code>Select Teacher to update Attendance.</code>
                            <select id="list" onchange="getSelected(this.options[this.selectedIndex].value);">

                                <option disabled selected>--Select Staff--</option>


                                <?php 
                                $classSQL = "SELECT id as cid, first_name, last_name, role FROM staff ORDER BY id ASC";
                                $classQuery =$dbh->prepare($classSQL);
                                $classQuery->execute();
                                $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($classResult)) {
                                    foreach ($classResult as $key => $value) {
                                        // code...
                                ?>
                                <option value="<?php echo $value->cid; ?>">
                                    <? echo $value->first_name; ?>
                                    <? echo $value->last_name; ?>
                                    &mdash;
                                    <? echo $value->role; ?>

                                </option>
                                <?php }}?>
                            </select>
                        </div>
                    </div>
                </div>
                <!-- body -->                
                <div class="student_list">
                    <div class="student_list_header">
                        <p class="title">Sign in out as staff.</p>
                        <button>
                            <i class="fa fa-download"></i>
                            Export
                            <? echo date('y-m-d');?>
                        </button>
                    </div>
                    <form id="atd_form" method="post" enctype="multipart/form-data">
                        <table id="student-list" class="display table">
                            <?php                                            
                                $signin = "in";
                                $signout = "out";                         

                                ?>  
                            <thead>
                                <tr>
                                    <td>Employee No</td>
                                    <td>Name</td>
                                    <td>Phone</td>
                                    <td>Role</td>                              
                                    <td>Sign In/ Out</td>
                                </tr>
                            </thead>
                            <!-- TABLE BODY -->
                            <tbody class="classRow">
                                <!-- AJAX content here -->
                            </tbody> 
                        </table>
                        <div class="allocate_container">
                            <button id="markAtdBtn" type="submit" onclick="markAtdAjax();">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                <p id="ajax_text">Update Attendance</p>
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#ajax_loader").hide();
        });

        function getSelected(value) {

            let staffFilter = value;
            // console.log(value);
            let container = document.querySelector(".classRow");

            let http = new XMLHttpRequest();

            http.onload = function() {
                if (this.readyState == 4 && this.status == 200) {

                    let response = JSON.parse(this.responseText);
                    let resOut = '';

                    if (response === null) {
                        resOut += `
                            <tr class = "odd">
                                <td valign="top" colspan="5" class= "dataTables_empty">
                                    No staff in the database yet!
                                </td>
                            </tr>
                        `;
                    }else{     
                        for(let item of response) {
                            resOut += `
                                <tr>
                                    <td>${item.employee_no}</td>
                                    <td>${item.first_name} ${item.last_name}</td>
                                    <td>${item.phone}</td>
                                    <td>${item.role}</td>
                                    <td class='atd_status1'>
                                        <label>
                                            <input value='<? echo $signin; ?>'  type='radio' name='status'>
                                            <span class'atd_hd'>
                                                <i class="fa fa-sign-in"></i>
                                                <p class="atd_p">Sign-In</p>
                                            </span>
                                        </label>

                                        <label>
                                            <input value='<? echo $signout; ?>'  type='radio' name='status'>
                                            <span class'atd_ab'>
                                                <i class="fa fa-sign-out"></i>
                                                <p class="atd_p">Sign-Out</p>
                                            </span>
                                        </label>
                                        <div style='display:none;'>
                                            <input name='atd_stf_id' value='${item.staff_id}' />
                                        </div>
                                    </td>
                                </tr>      
                                
                            `;
                        }
                        
                    }   
                    container.innerHTML = resOut;                     
                    
                }
                
            }

            http.open("POST", "includes/script.php");
            http.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            http.send("staffId="+staffFilter);           
        }

        function markAtdAjax() {
            let atd_form = document.querySelector("#atd_form"),
            succ = document.querySelector("#success"),
            error = document.querySelector("#error"),
            pend = document.querySelector("#pending");

            atd_form.onsubmit = (e) => {
                e.preventDefault();
            }

            let atdXhr = new XMLHttpRequest;

            atdXhr.onreadystatechange = function() {
                if (this.readyState !== "complete") {
                    $("#ajax_loader").show();
                    $("#ajax_text").hide();
                }

                if (atdXhr.readyState === XMLHttpRequest.DONE) {
                    $("#ajax_loader").hide();
                    $("#ajax_text").show();

                    if (atdXhr.status == 200) {
                        let response = JSON.parse(this.responseText);

                        if (response !== null && response !== undefined && response !== "") {

                            for(let item of response){
                                if (item.status == "true") {

                                    succ.textContent = item.message;
                                    succ.style.display = "block";
                                    error.style.display = "none"
                                }else{
                                    error.textContent = item.message;
                                    error.style.display = "block";
                                    succ.style.display = "none";
                                    pend.style.display = "none";
                                }
                            }

                        }else{
                            error.textContent = "Response is undefined or null!";
                            error.style.display = "block";
                            succ.style.display = "none";
                        }
                    }else{
                        error.textContent = "Responded with a status of 404";
                        error.style.display = "block";
                        succ.style.display = "none";
                    }

                }
            }

            atdXhr.open("POST", "includes/staff_attendance.php");
            let atdFormData = new FormData(atd_form);
            atdXhr.send(atdFormData);
        }

        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function pendRemove() {
            pend = document.querySelector('#pending');

            pend.style.display = "none";
        }
        function clearForm() {
            // sessionStorage.clear();
            $('#atd_form').trigger("reset");
            // console.log("session cleared");
        }
    </script>    
</body>
</html>

<?php }}?>