<?php
session_start();
error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }
        
        $staff_id = $_GET['staff-id'];
        $sql = "SELECT * FROM staff WHERE id = :stfid";
        $query = $dbh->prepare($sql);
        $query->bindParam(':stfid', $staff_id, PDO::PARAM_STR);
        $query->execute();
        $results = $query -> fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $result) {

                $first_name = $result->first_name;
                $last_name = $result->last_name;
                $emp_no = $result->employee_no;
                $username = $result->username;
                $email = $result->email;
                $phone = $result->phone;
                $address = $result->address;
                $gender = $result->gender;
                $notes = $result->notes;
                $role = $result->role;
                $logins = $result->total_logins;
                $reg_date = $result->reg_date;
                $id = $result->id;

            }
        }

?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><? echo $first_name; ?> <? echo $last_name; ?> &mdash; Profile</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="../assets/fullcalendar/fullcalendar.min.css" />
</head>
<body>
    <!-- <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div> -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display='none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display='none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display='none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->


    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <img src="../assets/images/icons/home.svg">
                <h3>Staff Profile</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div class="content_header">
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>View Profile </span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">            
                <div class="profile_container">
                    <div class="profile_left">
                        <div class="profile_top">
                            <img src="../assets/images/5.jpg">
                        </div>
                        <div class="profile_image">
                            <img src="../assets/images/icons/profile.svg">
                        </div>
                        <div class="profile_details_left">                           
                            <span><h3>Staff Role</h3><p> <? echo $role; ?></p></span>
                            <span><h3>Name</h3>
                                <p>
                                    <?php echo htmlentities($first_name);?>&nbsp;
                                    <?php echo htmlentities($last_name);?>
                                </p>
                            </span>       
                            <span><h3>Location</h3>
                                <p>Null</p>
                            </span>                 
                        </div>
                    </div>
                    <div class="profile_right">
                        <div class="personal_info">
                            <div class="tab">
                                <div class="tabs_left">
                                    <button id="defaultOpen" class="tab_links" onclick="openProfile(event, 'profile')">Profile</button>
                                    <button class="tab_links" onclick="openProfile(event, 'documents')">Documents</button>
                                    <button class="tab_links" onclick="openProfile(event, 'timeline')">Timeline</button>
                                </div>
                                <div class="tabs_right">
                                    <button class="btn" id="profileBtn" onclick="javascript:profileEdit();">
                                        <i class="fa fa-edit"></i>
                                        Edit
                                    </button>
                                </div>
                            </div>

                            <!-- PROFILE  -->
                            <div id="profile" class="tab_content profile_content">
                                <h4>Personal Information</h4>
                                <div class="profile_details_t">
                                    <span><h3>First Name</h3>
                                        <p><?php echo htmlentities($first_name);?></p>
                                    </span>
                                    <span><h3>Last Name</h3>
                                        <p><?php echo htmlentities($last_name);?></p>
                                    </span>
                                    <span><h3>Staff Role</h3><p><? echo $role; ?></p></span>
                                    <span><h3>Gender</h3>
                                        <p><?php echo htmlentities($gender);?></p>
                                    </span>
                                    <span><h3>Employee No</h3>
                                        <p><?php echo htmlentities($emp_no);?></p>
                                    </span>
                                    <span><h3>Residence</h3>
                                        <p>Null</p>
                                    </span>
                                    <span><h3>Enrollment Date</h3>
                                        <p><?php echo htmlentities($reg_date);?></p>
                                    </span>                                    
                                </div>
                            </div>
                            <!-- DOCUMENTS-->
                            <div id="documents" class="tab_content profile_content">
                                <h4>My Documents</h4>
                                <div class="documents_info">
                                    <span><h3>Profile Image</h3><img src="../assets/images/icons/profile.svg"></span>
                                    <span><h3>Other</h3><p> No records</p></span>
                                </div>
                            </div>
                            <!-- TIMELINE-->
                            <div id="timeline" class="tab_content profile_content">
                                <h4>My Timeline</h4>
                                <div class="timeline_info">
                                    Nothing to show in the timeline.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- profile edit -->
    <!-- The Modal -->
    <div id="myModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php echo $first_name; ?> 
                <?php echo $last_name; ?>'s &mdash; Profile Info!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStaff" method="post" enctype="multipart/form-data">
                <div class="edit_container">
                    <div class="edit_group">
                        <label>Staff First Name</label>
                        <input value="<?php echo $first_name; ?> " type="text" name="f_name" >
                    </div>

                    <div class="edit_group">
                        <label>Staff Last Name</label>
                        <input value="<?php echo $last_name; ?> " type="text" name="l_name" >
                    </div>

                    <div class="edit_group">
                        <label>Staff Username</label>
                        <input value="<?php echo $username; ?> " type="text" name="username" >
                    </div>

                    <div class="edit_group">
                        <label>Gender</label>
                        <input value="<?php echo $gender; ?>" type="text" name="gender" >
                    </div>

                    <div class="edit_group">
                        <label>Role</label>
                        <input value="<? echo $role?>" type="text" name="role" >
                    </div>
                    <div class="edit_group">
                        <label>Phone</label>
                        <input value="<?php echo $phone; ?>" type="text" name="phone" >
                    </div>
                    <div class="edit_group">
                        <label>Email</label>
                        <input value="<?php echo $email; ?>" type="email" name="email" >
                    </div>

                    <input style="display: none" value="<?php echo $id; ?>" type="text" name="id" >

                </div>
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editStaffProfile();">
                        <i class="fa fa-add"></i>
                        Update Staff
                        <img id="staff_loader" src="../assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <div></div>
        <p>Updating...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>
    
    
    <script src="../assets/js/jquery-3.6.0.js"></script>         
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>  
    <script src="../assets/fullcalendar/lib/moment.min.js"></script>
    <script src="../assets/fullcalendar/fullcalendar.min.js"></script>
    <script src="../assets/js/calendar.js"></script>
    
    <script type="text/javascript">
         // Get the element with id="defaultOpen" and click on it
        document.getElementById("defaultOpen").click();

        // Get the modal
        var modal = document.getElementById("myModal");

        // Get the button that opens the modal
        var btn = document.getElementById("profileBtn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
        }

        $(document).ready(function() {
            
            $("#staff_loader").hide();
            $("#fancy_loader").hide();

        });


        // editstaffProfile()

        function editStaffProfile() {

            let staff_form = document.querySelector("#editStaff");
            let suc = document.querySelector("#success");
            let err = document.querySelector("#error");

            staff_form.onsubmit = (e) => {

                e.preventDefault();
            }

            let staffXhr = new XMLHttpRequest;

            staffXhr.onreadystatechange = function () {
                if (this.readyState !== 'complete') {

                    $("#staff_loader").show();
                    $("#fancy_loader").show();
                }

                if (this.readyState === XMLHttpRequest.DONE) {

                    $("#staff_loader").hide();
                    $("#fancy_loader").hide();

                    if (staffXhr.status == 200) {

                        // let response = staffXhr.response;
                        let data = JSON.parse(this.responseText);

                        if (data !== null && data !== undefined && data !== "") {

                            for(let item of data){                        

                                if (item.status == "true") {
                                    suc.textContent = item.message;
                                    suc.style.display = "block";
                                    err.style.display = "none";

                                }else{
                                    err.textContent = item.message;
                                    err.style.display = "block";
                                    suc.style.display = "none";
                                }
                            }
                        }else{
                            err.textContent = "Response is null or undefined!";
                            err.style.display = "block";
                        }
                    }else{
                        err.textContent = "Server responded with a status of 404!";
                        err.style.display = "block";
                    }
                }
            }

            staffXhr.open("POST", "includes/profile.php");
            let staffData = new FormData(staff_form);
            staffXhr.send(staffData);
        }


    </script>
</body>
</html>

<?php }}?>