<?php
session_start();
error_reporting(0);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{

    $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }


?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Info</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>

    <!-- Error Wrap -->
    <?php if($error){?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }else if($suc){?>
    <div class="success_wrap"><?php echo htmlentities($suc); ?> </div><?php }?>
    <!-- //Error Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Staff Information</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, staff list!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Staff List</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="../assets/images/icons/list.svg">Staff List</p>        
                    
                    <div>
                        <select id="filterRole">
                            <option value="">--Filter by role--</option>
                            <?php 
                            $roleSQL = "SELECT id as cid, role FROM tbl_roles ORDER BY id ASC";
                            $roleQuery =$dbh->prepare($roleSQL);
                            $roleQuery->execute();
                            $roleResult = $roleQuery->fetchAll(PDO::FETCH_OBJ);
                            // $roleCNT = $roleQuery->rowCount() > 0;
                            if (!empty($roleResult)) {
                                foreach ($roleResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->role; ?>">
                                <?php echo $value->role; ?>
                            </option>
                            <?php }}?>
                        </select>
                        <select id="filterGender">
                            <option value="">--filter by gender--</option>
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>
                    

                    <div class="top_action">

                        <a href="add_staff.php">
                            <button class="btn">
                                <i class="fa-solid fa-plus"></i>
                                Add
                            </button>
                        </a>

                        <button id="my_modal_btn" class="btn" title="Edit" >
                            <i class="fa-solid fa-edit"></i>
                            edit
                        </button>
                        
                        <button class="btn" id="importBtn">
                            <i class="fa fa-cloud-upload" aria-hidden="true"></i>
                            Import
                        </button>
                    </div>
                </div>

                <div class="student_list">
                    <table id="staff_table" class="display table">
                        <thead>
                            <tr>
                                <td>Employee No</td>
                                <td>First Name</td>
                                <td>Last Name</td>
                                <td>Gender</td>
                                <td>Phone</td>
                                <td>Email</td>
                                <td>Role</td>
                                <td>Action</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- staff here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- The Modal -->
    <div id="editModal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Edit 
                <?php //echo $res->First_Name; ?> 
                <?php //echo $res->Last_Name; ?> &mdash; Staff Information!
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <!-- FILTER CLASSES FOR THE  STUDENT -->
                <div class="edit_all_container">
                    <div class="edit_group">
                        <label>Class</label>
                        <select id="class" onchange="getSelected(this.options[this.selectedIndex].value)">
                            <option value="">--Select Class--</option>
                            <?php 
                            $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->cid; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>
                    </div>
                    <div class="edit_group">
                        <label>Student</label>
                        <select id="sdt_class" onclick="getStudent(this.options[this.selectedIndex].value)">
                            <option value="" selected>--Select Student--</option>
                        </select>
                    </div>
                </div>
                <!-- FILTER CLASSES FOR THE  STUDENT -->

                <!-- FILTERED DATA APPEARS HERE -->
                <div id="filtered" class="filtered_data">
                    <!-- filtered data here -->
                </div>
                <!-- SUBMIT BUTTON -->
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editProfile();">
                        <i class="fa fa-add"></i>
                        Update Staff
                        <img id="ajax_loader" src="../assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <!-- payment modal -->
    <div id="importModal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Import Staff</h4>
                <span class="close_bal">&times;</span>
            </div>
            <div class="modal_form">
                <form id="importStaff" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Select File</label>
                        <input id="file" type="file" name="file" accept=".csv" />
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:importStaff();" id="import_btn">
                            Import Staff
                            <img id="staff_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- loader -->
    <div id="import_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Importing...</p>
    </div>

    <div id="delete_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Deleting...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script>  

    <script>
        // Get the modal
        var modal = document.getElementById("editModal");

        // Get the button that opens the modal
        var btn = document.getElementById("my_modal_btn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal 
        btn.onclick = function() {
          modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
          modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
          if (event.target == modal) {
            modal.style.display = "none";
          }
      }

      // Get the modal
        let staff_modal = document.getElementById("importModal");

        // Get the button that opens the modal
        var staff_btn = document.getElementById("importBtn");

        // Get the <span> element that closes the modal
        var staff_span = document.getElementsByClassName("close_bal")[0];

        // When the user clicks the button, open the modal 
        staff_btn.onclick = function() {
          staff_modal.style.display = "block";
        }

        // When the user clicks on <span> (x), close the modal
        staff_span.onclick = function() {
          staff_modal.style.display = "none";
        }



      //on load get staffs
        let staffTable = $('#staff_table').DataTable({
            'buttons': [ 'copy', 'csv', 'excel', 'pdf', 'print' ],
            'processing': false,
            'serverSide': true,
            'serverMethod': 'POST',
            'searching': true,
            // ajax
            'ajax': {
                'url': 'includes/get-staff.php',
                'data': function (data) {
                    // read value
                    let gender = $('#filterGender').val();
                    let role = $('#filterRole').val();

                    // apend data
                    data.gender = gender;
                    data.role = role;
                },
                beforeSend: function () {
                    $('#fancy_loader').show();
                },
                complete: function () {
                    $('#fancy_loader').hide();
                }
            },
            'columns': [
                { data: 'employee_no' },
                { data: 'first_name', 'orderable': false },
                { data: 'last_name', 'orderable': false },
                { data: 'gender' },
                { data: 'phone', 'orderable': false },                
                { data: 'email' },
                { data: 'role' },
                { data: "action",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data) { // render event defines the markup of the cell text 

                        let a = `<p class="student_edit">
                                    <a style="color: #222; font-weight: 700;" class="edit" href="staff-profile.php?staff-id=${data}">
                                        <i class="fa fa-eye"></i>
                                        View
                                    </a>
    
                                    <button class="delete" onclick="staffDelete(this.value)" value="${data}">
                                        <i class="fa fa-trash"></i>
                                        Delete
                                    </button>
                                </p>`; // row object contains the row data
                        return a;
                    }
                },
            ],
            'columnDefs': [{
                orderable: false,
                ordering: false,
                targets: [2,3,4,5]  //Here we disable sorting fearure for few cols
            }],
        });

        // onload
        $(document).ready(function() {

            // staffTable.draw();

            $("#filterRole").change(function()
            {
                staffTable.draw();
            });

            $("#filterGender").change(function() 
            {
                staffTable.draw();
            });

            $("#delete_fancy_loader").hide();            
            $("#ajax_loader").hide();            
            $("#staff_loader").hide();
            $("#import_loader").hide();            

        });

        // function delete
        function staffDelete(value) 
        {
            let id = value;
            let suc = document.querySelector("#success"),
            err = document.querySelector("#error");

            let proceed = confirm('Deleting this staff may have adverse effects on the data. Especially if the staff is linked to the student activities. DO YOU STILL WISH TO CONTINUE?');

            if (proceed) {

                //ajax
            $.ajax({
                url: 'includes/staff-delete.php',
                method: 'POST',
                data: { id:id },
                success: function(data) {

                    $.each(JSON.parse(data), function(index, item) {

                        if (item.status == "true") 
                        {
                            suc.textContent = item.message;
                            suc.style.display = 'block';
                            err.style.display = 'none';

                            staffTable.draw();

                        }else 
                        {
                            err.textContent = item.message;
                            err.style.display = 'block';
                            suc.style.display = 'none';

                        }

                    });

                },
                beforeSend: function() {

                    $("#delete_fancy_loader").show();

                }, 
                complete: function() {

                    $("#delete_fancy_loader").hide();

                }
            });

            }

            
        }

        function importStaff() {

            let staff_form = document.querySelector("#importStaff");
            let suc = document.querySelector("#success");
            let err = document.querySelector("#error");


            staff_form.onsubmit = (e) => {

                e.preventDefault();

            }

            //ajax 

            $.ajax({
                url: 'includes/import_staff.php',
                method: 'POST',
                data: new FormData(staff_form),
                contentType:false,          // The content type used when sending data to the server.  
                cache:false,                // To unable request pages to be cached  
                processData:false, 
                success: function(data) {
                    //do something 
                    $.each(JSON.parse(data), function(index, item){

                        if (item.status == "true") 
                        {
                            suc.textContent = item.message;
                            suc.style.display = 'block';
                            err.style.display = 'none';

                            staffTable.draw();

                        }else 
                        {
                            err.textContent = item.message;
                            err.style.display = 'block';
                            suc.style.display = 'none';

                        }
                        
                    });
                },
                beforeSend: function() {

                    $("#import_loader").show();
                    $("#staff_loader").show();

                },
                complete: function() {
                    //hide loaders 

                    $("#import_loader").hide();
                    $("#staff_loader").hide();
                    
                }

            });
        }

    </script>
    
</html>

<?php }}?>