<?php
session_start();
error_reporting(E_ALL);
include('../../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../../login.php?error=Your Session Has Expired, Login again!');
    }else{
        $year = date("Y");

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Attendance</title>
    
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="../assets/css/theme.css">
    <link rel="stylesheet" href="../assets/css/student.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
    <link rel="stylesheet" href="../assets/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" />
</head>
<body>
    <div class="page_loader">
        <img src="../assets/images/blank.gif"> LOADING...
    </div>
    <?php require('includes/header.php'); ?>
    <script src="../assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-book"></i>
                <h3>Staff Attendance</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="../assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="../assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- STUDENT INFORMATION -->
            <div class="student_container">
                <!-- body -->
                <div class="student_list">
                    <div class="student_list_header">
                        <p class="title">Staff attendance over the years.</p>
                        <a onclick="loader();" style="color:var(--sec-white);" href="mark-staff-attendance.php">
                            <button id="m_btn">
                                <i class="fa fa-check"></i>
                                Mark Attendance
                                <img id="ajax_loader" src="../assets/images/blank.gif">
                            </button>
                        </a>
                    </div>
                    <table id="student-list" class="display table">
                        <thead>
                            <tr>
                                <td>Emp No</td>
                                <td>Name</td>
                                <td>Phone</td>
                                <td>Sign-In</td>                                
                                <td>Sign-Out</td>
                                <td>Date</td>
                            </tr>
                        </thead>
                        <!-- TABLE BODY -->
                        <tbody>
                            <!-- TBODY //TABLE ROW  -->
                            <?php 

                            $atd = "SELECT staff_attendance.staff_id, 
                            staff_attendance.creation_day,
                            staff_attendance.signout,
                            staff_attendance.signin,
                            staff.id,
                            staff.first_name,
                            staff.last_name, 
                            staff.employee_no,
                            staff.phone
                            FROM staff_attendance JOIN staff ON 
                            staff.id = staff_attendance.staff_id WHERE staff_attendance.year = :y
                            ";
                            $atdQuery = $dbh->prepare($atd);
                            $atdQuery->execute(array(':y' => $year));
                            $atdResult = $atdQuery->fetchAll(PDO::FETCH_OBJ);
                            if (!empty($atdResult)) {
                                foreach ($atdResult as $key => $val) {

                            ?>
                            <tr>
                                <td><? echo $val->employee_no; ?></td>             
                                <td>
                                    <? echo $val->first_name; ?>
                                    <? echo $val->last_name; ?>
                                </td>
                                <td>254<? echo $val->phone; ?></td>
                                <td style="font-weight: 800;color:var(--success)"><? echo $val->signin; ?></td>
                                <td style="font-weight: 800;color:var(--danger);"><? echo $val->signout; ?></td>
                                <td style="font-weight: 800"><? echo $val->creation_day; ?></td>      
                            </tr>
                            <? }}?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require '../includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="../assets/js/jquery-3.6.0.js"></script>       
    <script src="../assets/js/jquery.dataTables.min.js"></script>
    <script src="../assets/js/dataTables.buttons.min.js"></script>
    <script src="../assets/js/buttons.print.min.js"></script>
    <script src="../assets/js/sidebar.js"></script>
    <script src="../assets/js/app.js"></script>
    <script src="../assets/js/table.js"></script> 
    <script type="text/javascript">
        $(document).ready(function(){
            $("#ajax_loader").hide();
        });
        function loader() {
            $("#ajax_loader").show();
        }
    </script>   

</body>
</html>

<?php }}?>