<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }



?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Timetable</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Timetable</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, timetable!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Timetable</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="assets/images/icons/list.svg">Main Timetable</p>        

                    <div class="top_action">
                        <button id="my_modal_btn" class="btn" title="Edit" >
                            <i class="fa-solid fa-edit"></i>
                            edit
                        </button>
                    </div>
                </div>

                <div class="student_list">
                    <h3>Main Timetable</h3>

                    <div class="options_top_bar">
                        <div class="slct_options_left">
                            <select id="role" onchange="getSelected(this.options[this.selectedIndex].value)">
                                <option value="">--Filter Timetable by Role--</option>
                                <option value="student">Student</option>
                                <option value="teacher">Teacher</option>
                            </select>

                            <select id="class_t" onchange="getClassTimetable(this.options[this.selectedIndex].value)">
                                <option value="">--Select Class--</option>
                                <?php 
                                $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                                $classQuery =$dbh->prepare($classSQL);
                                $classQuery->execute();
                                $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($classResult)) {
                                    foreach ($classResult as $key => $value) {
                                        // code...
                                ?>
                                <option value="<?php echo $value->cid; ?>">
                                    <?php echo $value->class_name; ?>
                                </option>
                                <?php }}?>
                            </select>

                            <select id="teacher_t" onchange="getTeacherTimetable(this.options[this.selectedIndex].value)">
                                <option value="">--Select Class--</option>
                                <?php 
                                $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                                $classQuery =$dbh->prepare($classSQL);
                                $classQuery->execute();
                                $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($classResult)) {
                                    foreach ($classResult as $key => $value) {
                                        // code...
                                ?>
                                <option value="<?php echo $value->cid; ?>">
                                    <?php echo $value->class_name; ?>
                                </option>
                                <?php }}?>
                            </select>
                        </div>
                        <div class="slct_options_right">
                            <button onclick="getTimetableModal();" class="btn">Student Timetable</button>
                            <button onclick="getTeacherModal();" class="btn">Teacher Timetable</button>
                        </div>
                    </div>

                    <div class="st_timetable" id="timetable">
                        <table>
                            <thead>
                                <tr>
                                    <td>Time</td>
                                    <td>Monday</td>
                                    <td>Tuesday</td>
                                    <td>Wednesday</td>
                                    <td>Thursday</td>
                                    <td>Friday</td>
                                </tr>
                            </thead>
                            <tbody id="table">                               
                                
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- The Modal -->
    <div id="modal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Student Timetable
            </h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <!-- FILTER CLASSES FOR THE  STUDENT -->
                <div class="edit_all_container">
                    <div class="edit_group">
                        <label>Class</label>
                        <select id="class_id">
                            <option value="">--Select Class--</option>
                            <?php 
                            $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->cid; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>

                        </select>
                    </div>
                </div>
                <!-- FILTER CLASSES FOR THE  STUDENT -->

                <!-- FILTERED DATA APPEARS HERE -->
                <div id="filtered" class="filtered_data">
                    <!-- filtered data here -->
                    <div class="edit_group">
                        <label>Start Time</label>
                        <input type="text" id="start"  placeholder="example 8.00 Am">
                    </div>

                    <div class="edit_group">
                        <label>End Time</label>
                        <input type="text" id="end" placeholder="example 9.00 Am" >
                    </div>

                    <div class="edit_group">
                        <label>Monday</label>
                        <input type="text" id="monday" placeholder="example Arts">
                    </div>

                    <div class="edit_group">
                        <label>Tuesday</label>
                        <input type="text" id="tuesday" placeholder="example Maths">
                    </div>

                    <div class="edit_group">
                        <label>Wedneday</label>
                        <input type="text" id="wednesday" placeholder="example English" >
                    </div>

                    <div class="edit_group">
                        <label>Thursday</label>
                        <input type="text" id="thursday" placeholder="example Social Studies">
                    </div>

                    <div class="edit_group">
                        <label>Friday</label>
                        <input type="text" id="friday" placeholder="example CRE">
                    </div>
                </div>
                <!-- SUBMIT BUTTON -->
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editTimetable();">
                        <i class="fa fa-add"></i>
                        Add
                        <img id="student_loader" src="assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>

    <!-- Teacher Modal -->
    <div id="tmodal" class="modal">
      <!-- Modal content -->
      <div class="modal-content">
        <div class="modal-top">
            <h3>
                <i class="fa fa-edit"></i>
                Teacher Timetable
            </h3>
            <span id="tclose" class="close">&times;</span>
        </div>
        <div class="modal_event">
            <form id="editStudent" method="post" enctype="multipart/form-data">
                <!-- FILTER CLASSES FOR THE  STUDENT -->
                <div class="edit_all_container">
                    <div class="edit_group">
                        <label>Select Class</label>
                        <select id="sdt_class" onclick="getStudent(this.options[this.selectedIndex].value)">
                            <option value="" selected>--Select Student--</option>
                        </select>
                    </div>
                    <div class="edit_group">
                        <label>Select Section</label>
                        <select id="sdt_class" onclick="getStudent(this.options[this.selectedIndex].value)">
                            <option value="" selected>--Select Section--</option>
                        </select>
                    </div>
                </div>
                <!-- FILTER CLASSES FOR THE  STUDENT -->

                <!-- FILTERED DATA APPEARS HERE -->
                <div id="filtered" class="filtered_data">
                    <!-- filtered data here -->
                </div>
                <!-- SUBMIT BUTTON -->
                <div class="edit_btn">
                    <button type="submit" id="editProf" onclick="editTimetable();">
                        <i class="fa fa-add"></i>
                        Add
                        <img id="ajax_loader" src="assets/images/blank.gif">
                    </button>
                </div>
            </form>
        </div>
      </div>

    </div>


    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <div id="timetable_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Adding...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  

    <script>

        $(document).ready(function(){

            $("#fancy_loader").hide();
            $("#timetable_fancy_loader").hide();
            $("#student_loader").hide();
            $("#ajax_loader").hide();
            $("#teacher_t").hide();
            $("#class_t").hide();


        });

        function getTimetableModal() {
         let md = document.querySelector("#modal");

            md.style.display = 'block';

        }

        function getTeacherModal() {

            let md = document.querySelector("#tmodal");

            md.style.display = 'block';

            
        }

        let md_close = document.querySelector(".close");
        let md = document.querySelector("#modal");

        md_close.onclick = () => {
            md.style.display = 'none';
        }

        // teacher modal
        let t_close = document.querySelector("#tclose");
        let t = document.querySelector("#tmodal");

        t_close.onclick = () => {
            t.style.display = 'none';
        }


        function editTimetable(value) {
            let student_timetable = document.querySelector("#editStudent");
            let suc = document.getElementById('success'),
            err = document.getElementById('error');

            student_timetable.onsubmit = (e) => { e.preventDefault(); }


            let class_id = $("#class_id").val();
            let start_time = $("#start").val();
            let end_time = $("#end").val();
            let monday = $("#monday").val();
            let tuesday = $("#tuesday").val();
            let wednesday = $("#wednesday").val();
            let thursday = $("#thursday").val();
            let friday = $("#friday").val();

            let form_data = {
                class_id, start_time, end_time, monday, tuesday, wednesday, thursday, friday 
            };

            console.log(form_data);

            // ajax
            $.ajax({
                url: 'includes/add-timetable.php',
                method: 'POST',
                data: form_data,
                success: function(data) {
                    // do something
                    $.each(JSON.parse(data), function (index, item) {
                        
                        if (item.status == 'true') {

                            suc.textContent = item.message;
                            suc.style.display = 'block';
                            err.style.display = 'none';

                            $("#editStudent").trigger('reset');

                        }else{

                            err.textContent = item.message;
                            err.style.display = 'block';
                            suc.style.display = 'none';
                        }

                    });
                },
                beforeSend: function() {

                    $("#timetable_fancy_loader").show();
                    $("#student_loader").show();

                },
                complete: function() {

                    $("#timetable_fancy_loader").hide();
                    $("#student_loader").hide();

                }
            });
        }

        function getSelected(value) {

            let role = value;

            if (role == 'teacher') {

                $("#teacher_t").show();
                $("#class_t").hide();

            }else{

                $("#teacher_t").hide();
                $("#class_t").show();


            }

        }

        //funtion to get timetable
        function getClassTimetable(value) {

            let table_container = document.getElementById('table');

            let class_id = value;
            let role = $("#role").val();
            let timetable = " ";

            let data = { class_id, role };

            //ajax
            $.ajax({
                url: 'includes/get-main-timetable.php',
                method: 'POST',
                data: data,
                success: function(response) {

                    let data = JSON.parse(response);

                    $.each(data, (index, item) => {


                        timetable += `

                            <tr>
                                <td class="${item.class}">${item.start_time} - ${item.end_time}</td>
                                <td>${item.monday}</td>
                                <td>${item.tuesday}</td>
                                <td>${item.wednesday}</td>
                                <td>${item.thursday}</td>
                                <td>${item.friday}</td>
                            </tr>

                        `;


                    });

                    table_container.innerHTML = timetable;


                },
                beforeSend: () => {$("#fancy_loader").show();},
                complete: () => {$("#fancy_loader").hide();}
            });
        }

        function getTeacherTimetable(value) {

            let table_container = document.getElementById('table');

            let class_id = value;
            let role = $("#role").val();
            let timetable = " ";

            let data = { class_id, role };

            //ajax
            $.ajax({
                url: 'includes/get-main-timetable.php',
                method: 'POST',
                data: data,
                success: function(response) {

                    let data = JSON.parse(response);

                    $.each(data, (index, item) => {


                        timetable += `

                            <tr>
                                <td class="${item.class}">${item.start_time} - ${item.end_time}</td>
                                <td>${item.monday}</td>
                                <td>${item.tuesday}</td>
                                <td>${item.wednesday}</td>
                                <td>${item.thursday}</td>
                                <td>${item.friday}</td>
                            </tr>

                        `;


                    });

                    table_container.innerHTML = timetable;


                },
                beforeSend: () => {$("#fancy_loader").show();},
                complete: () => {$("#fancy_loader").hide();}
            });
        }
       
    </script>
    
</html>

<?php }}?>