<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }



?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Classes</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="this.style.display = 'none';" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="this.style.display = 'none';" class="suc_header"></div>
    </div>
    <div class="suc_container">
        <div id="pending" onclick="this.style.display = 'none';" class="pend_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>

    <? include 'includes/top-bar.php';?>
    
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <i class="fa fa-users"></i>
                <h3>Classes</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <?php 
                    $username = $_SESSION['alogin'];
                    $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':username', $username, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $key => $result) {

                ?>
                <p class="welcome">Hi  &#128075; 
                    <?php echo htmlentities($result->f_name);?>&nbsp;
                    <?php echo htmlentities($result->l_name);?>, staff list!
                </p>
                <?php 
                        }
                    }
                ?>
                <p class="breadcrumb">                    
                    <span><a href="dashboard.php">Dashboard</a> | </span>
                    <span>Classes</span>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="../dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- Staff INFORMATION -->
            <div class="student_container">
                <div class="container_top">
                    <p><img src="assets/images/icons/list.svg">Classes</p>        
                    
                    <div>
                        <select id="filterRole" onchange="
                        getClassInfo(this.options[this.selectedIndex].value);
                        getTimetable(this.options[this.selectedIndex].value);">
                            <option value="">--Select Class--</option>
                            <?php 
                            $classSQL = "SELECT id as cid, class_name FROM tbl_class ORDER BY id ASC";
                            $classQuery =$dbh->prepare($classSQL);
                            $classQuery->execute();
                            $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                            // $classCNT = $classQuery->rowCount() > 0;
                            if (!empty($classResult)) {
                                foreach ($classResult as $key => $value) {
                                    // code...
                            ?>
                            <option value="<?php echo $value->cid; ?>">
                                <?php echo $value->class_name; ?>
                            </option>
                            <?php }}?>
                        </select>
                    </div>
                    

                    <div class="top_action">
                        <button id="my_modal_btn" class="btn" title="Edit" >
                            <i class="fa-solid fa-edit"></i>
                            edit
                        </button>
                    </div>
                </div>

                <div class="timeline_info" style="margin-top: 10px;">
                    <div id="class_info">
                        <div class="class_info_bfr">
                            <p>To view class info, select a class from the dropdown</p>
                        </div>
                    </div>

                    <!-- fee info -->
                    <div id="fee_info">
                        <div class="class_fee_info">
                            <h4>Fees Payment</h4>
                            <div class="fee_info_view">
                                <div id="fee_info_left" class="fee_info_left">
                                    <!-- fee info left here -->
                                </div>
        
                                 <div class="canva_fee_status">
                                    <canvas id="feeStatus"></canvas>
                                </div>
                            </div>

                        </div>
                    </div>


                    <!-- timetable -->
                    <div class="class_timetable">               

                        <h4>Timetable</h4>

                        <div class="st_timetable" id="timetable">
                            <table>
                                <thead>
                                    <tr>
                                        <td>Time</td>
                                        <td>Monday</td>
                                        <td>Tuesday</td>
                                        <td>Wednesday</td>
                                        <td>Thursday</td>
                                        <td>Friday</td>
                                    </tr>
                                </thead>
                                <tbody id="table">
                                                                       
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- payment modal -->
    <div id="modal" class="pay_modal">
        <div class="pay_modal_content">
            <div class="pay_modal_top">
                <h4>Assign Class Teacher</h4>
                <span class="close_assign">&times;</span>
            </div>
            <div class="modal_form">
                <form id="assignTeacher" method="post" enctype="multipart/form-data">
                    <div class="pay_group">
                        <label>Select Teacher</label>
                        <select id="teacher_id">
                            <option value="">--Select Teacher--</option>
                            <?php 
                                $classSQL = "SELECT id as cid, first_name, last_name, role FROM staff WHERE role = 'Teacher' ORDER BY id ASC";
                                $classQuery =$dbh->prepare($classSQL);
                                $classQuery->execute();
                                $classResult = $classQuery->fetchAll(PDO::FETCH_OBJ);
                                // $classCNT = $classQuery->rowCount() > 0;
                                if (!empty($classResult)) {
                                    foreach ($classResult as $key => $value) {
                                        // code...
                                ?>
                                <option value="<?php echo $value->cid; ?>">
                                    <? echo $value->first_name; ?>
                                    <? echo $value->last_name; ?>
                                    &mdash;
                                    <? echo $value->role; ?>

                                </option>
                                <?php }}?>
                        </select>
                    </div>
                    
                    <div id="cont_class_id" style="display: none;">
                        <!-- class_id here -->
                    </div>

                    <div class="pay_group pay_group_btn">
                        <button onclick="javascript:assignClassTeacher();" id="assign_btn">
                            Assign to this class
                            <img id="assign_loader" src="../assets/images/blank.gif">
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- loader -->
    <div id="assign_fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Assigning...</p>
    </div>


    <div id="fancy_loader" class="fancy_loader">
        <div></div>
        <div></div>
        <div></div>
        <p>Loading...</p>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>  

    <script>

        $(document).ready(function(){

            $("#fancy_loader").hide();
            $("#assign_loader").hide();
            $("#assign_fancy_loader").hide();

        });


        function getClassInfo(value) {
            let class_info = document.getElementById("class_info"),
            class_id = value;

            let output = " ";            
            let sbj_list = document.querySelector("#sbj_id");
            let graphArea = document.getElementById('feeStatus');
            let feeStatus = null;

            // ajax 
            $.ajax({
                url: 'includes/get_class_info.php',
                method: 'POST',
                data: { class_id: class_id },
                success: function(data) {

                    let response = JSON.parse(data);   


                    // function to return chart
                    function feeChart() {

                        let amountDue = response.amount_due;
                        let amountPaid = response.amount_paid;           

                        var datadough = {
                          labels: [
                            'Amount-Paid',
                            'Amount-Due'
                          ],
                          datasets: [{
                            label: 'FEES FOR THIS CLASS',
                            data: [amountPaid, amountDue],
                            backgroundColor: [
                              '#198754',
                              '#dc3251'
                              
                            ],
                            hoverOffset: 4
                          }]
                        };
                        var configdough = {
                          type: 'doughnut',
                          data: datadough,
                        };

                        let graphArea = document.getElementById('feeStatus').getContext('2d');

                        //before redering the chart
                        if (Chart.getChart("feeStatus")){
                          Chart.getChart("feeStatus").destroy();
                        }
                        // render init block
                        feeStatus = new Chart(graphArea, configdough);                        

                        
                      //gender count data
                    }

                    //function to get all the students in the selected class
                    function students() {
                        let std = "";

                        $.each(response.stdRecords, function(index, item) {

                            std += `
                                <tr>
                                    <td>${item.first_name}</td>                                
                                    <td>${item.last_name}</td>                                
                                    <td>${item.surname}</td>                                
                                    <td>${item.phone}</td>                                
                                    <td>${item.email}</td>                                
                                    <td>${item.section}</td>                                
                                </tr>
                            `;
                        });

                        return std; 
                    }


                    function subjects() {

                        let sbj = " ";

                        $.each(response.sbj_assigned, function (index, item) {

                          sbj += `
                                <p>
                                    ${item.subject_name}
                                </p>
                            `;

                        });

                        return sbj;
                    }


                    function feeLeft() {

                        let fee = '';

                        let fee_info_left = document.querySelector("#fee_info_left");
                        
                        fee = `

                             <div class="fee_list">
                                <h5>Fee Allocated</h5>
                                <p class="allocated">Ksh. ${Intl.NumberFormat().format(response.amount_allocated)}</p>
                            </div>
                            <div class="fee_list">
                                <h5>Paid</h5>
                                <p class="paid" >Ksh. ${Intl.NumberFormat().format(response.amount_paid)}</p>
                            </div>
                            <div class="fee_list">
                                <h5>Due</h5>
                                <p class="due" >Ksh. ${Intl.NumberFormat().format(response.amount_due)}</p>
                            </div>

                        `;

                        return fee;

                        
                    }

                    output = `

                        <div class="class_info">
                            <p>Class Information</p>
                        </div>
                        <div class="class_info_view">
                            <div class="class_info_list">
                                <h5>Class</h5>
                                <p class="class_cnt">${response.class}</p>
                            </div>
                            
                            <div class="class_info_list">
                                <h5>Number of subjects</h5>
                                <p class="class_cnt">${response.sbj_cnt}</p>
                            </div>
                            <div class="class_info_list">
                                <h5>Total number of students</h5>
                                <p class="class_cnt class_std">${response.std_cnt}</p>
                                <div class="gender_filter">
                                    <div class="g_fil">
                                        <h5>Male</h5>
                                        <p>${response.std_male_cnt}</p>
                                    </div>
                                    <div class="g_fil">
                                        <h5>Female</h5>
                                        <p>${response.std_female_cnt}</p>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="students_view st_timetable">
                            <h4>Students List</h4>
                            <table>
                                <thead>
                                    <tr>
                                        <td>First Name</td>
                                        <td>Last Name</td>
                                        <td>Surname</td>
                                        <td>Phone</td>
                                        <td>Email</td>
                                        <td>Section</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${students()}
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="class_info_sbj">
                            <div class="sbjs">
                                <h4>Subjects Assigned</h4>
                                <div id="sbj_id" class="sbj_list">
                                    ${subjects()}
                                </div>
                            </div>
                            <div class="sbj_right">
                                <h5>Class Teacher</h5>
                                <p>${response.class_teacher == null ? `<button value='${response.class_id}' onclick='getModal(this.value);' class='assign'>Assign Class Teacher</button>` : response.class_teacher }</p>
                            </div>
                        </div>
                    `;

                    class_info.innerHTML = output;
                    fee_info_left.innerHTML = feeLeft();
                    graphArea.innerHTML  = feeChart();
                    // console.log(output);
                    

                },
                beforeSend: function() {

                    $("#fancy_loader").show();

                },
                complete: function() {

                    $("#fancy_loader").hide();

                }
            });
        }


        function getModal(value) {

            let md = document.querySelector("#modal");

            md.style.display = 'block';

            let class_id = value;
            let class_id_cont = document.querySelector("#cont_class_id");

            let input = '';

            if(class_id != '') {
                input = `<input type="text" id="a_class_id" value="${class_id}" >`;
            }

            class_id_cont.innerHTML = input;
        }

        let md_close = document.querySelector(".close_assign");
        let md = document.querySelector("#modal");

        md_close.onclick = () => {
            md.style.display = 'none';
        }

        //funtion to get timetable
        function getTimetable(value) {

            let table_container = document.getElementById('table');

            let class_id = value;
            let timetable = " ";

            //ajax
            $.ajax({
                url: 'includes/get-timetable.php',
                method: 'POST',
                data: { class_id: class_id },
                success: function(response) {

                    let data = JSON.parse(response);

                    if (data !== null && data !== undefined && data !== '') {

                        $.each(data, (index, item) => {


                            timetable += `

                                <tr>
                                    <td class="${item.class}">${item.start_time} - ${item.end_time}</td>
                                    <td>${item.monday}</td>
                                    <td>${item.tuesday}</td>
                                    <td>${item.wednesday}</td>
                                    <td>${item.thursday}</td>
                                    <td>${item.friday}</td>
                                </tr>

                            `;


                        });

                    }else{

                        timetable = `<tr>
                            <td>Nothing to show in the table!</td>
                        </tr>`;
                    }

                    

                    table_container.innerHTML = timetable;


                },
                beforeSend: () => {$("#fancy_loader").show();},
                complete: () => {$("#fancy_loader").hide();}
            });
        }

        //assign class teacher
        function assignClassTeacher() {
            let assignTeacher_form = document.getElementById("assignTeacher");
            let err = document.querySelector("#error"),
            suc = document.querySelector("#success");

            assignTeacher_form.onsubmit = (e) => {

                e.preventDefault();

            }

            let class_id = $("#a_class_id").val();
            let t_id = $("#teacher_id").val();

            let form_data = { class_id, t_id };

            // ajax
            $.ajax({
                url: 'includes/assign-class-teacher.php',
                method: 'POST',
                data: form_data,
                success: function (data) {
                
                    $.each(JSON.parse(data), function (index, item) {
                        
                        if (item.status == 'true') {

                            suc.textContent = item.message;
                            suc.style.display = 'block';
                            err.style.display = 'none';

                            $("#assignTeacher").trigger('reset');

                            md.style.display = 'none';

                            value = class_id;

                            getClassInfo(value);

                        }else{

                            err.textContent = item.message;
                            err.style.display = 'block';
                            suc.style.display = 'none';
                        }

                    });
                },
                beforeSend: function() {

                    $("#assign_fancy_loader").show();
                    $("#assign_loader").show();
                },
                complete: function() {

                    $("#assign_fancy_loader").hide();
                    $("#assign_loader").hide();

                }
            });
        }
       
    </script>
    
</html>

<?php }}?>