<?php
session_start();
error_reporting(0);
include('../includes/config.php');
if(strlen($_SESSION['alogin']) == 0)
    {
header('location:../login.php');
}
else{
    $now = time();

    if ($now > $_SESSION['expire']) {
        //destroy session and redirect to the login page
        session_destroy();
        header('Location: ../login.php?error=Your Session Has Expired, Login again!');
    }else{

        $statusMsg = NULL;
        $error = NULL;

        $username = $_SESSION['alogin'];
        
        $sql = "SELECT f_name, l_name FROM admin WHERE username = :username";
        $query = $dbh->prepare($sql);
        $query->bindParam(':username', $username, PDO::PARAM_STR);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        if ($query->rowCount() > 0) {
            foreach ($results as $key => $name_res) {

                $first_name = $name_res->f_name;
                $last_name = $name_res->l_name;
            }
        }

         
?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit School Website</title>
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" type="text/css">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="stylesheet" href="assets/css/student.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/jquery.dataTables.min.css">
    <script>
        if ( window.history.replaceState ) {
            window.history.replaceState( null, null, window.location.href );
        }
    </script>
    <script>
    // Run on page load
    window.onload = function() {

        // If sessionStorage is storing default values (ex. name), exit the function and do not restore data
        if (sessionStorage.getItem('name') == "name") {
            return;
        }

        // If values are not blank, restore them to the fields
        var name = sessionStorage.getItem('files[]');
        if (name !== null) $('#files').val(name);

    }

    // Before refreshing the page, save the form data to sessionStorage
    window.onbeforeunload = function() {
        sessionStorage.setItem("files[]", $('#files').val());
        
    }
    </script>
</head>

<body>
    <div class="page_loader">
        <img src="assets/images/blank.gif"> LOADING...
    </div>
    
    <!-- //Status Wrap -->
    <?php if($statusMsg){?>
    <div class="success_wrap"><?php echo htmlentities($statusMsg); ?></div><?php }elseif ($error) {?>
    <div class="error_wrap"><?php echo htmlentities($error); ?></div><?php }?>
    <!-- //status Wrap -->

    <!-- ajax error_wrap -->
    <div class="err_container">
        <div id="error" onclick="errRemove();" class="err_header"></div>
    </div>
    <div class="suc_container">
        <div id="success" onclick="sucRemove();" class="suc_header"></div>
    </div>
    <!-- ajax error_wrap -->

    <?php require('includes/header.php'); ?>
    <script src="assets/js/theme-switch.js"></script>
    <? include 'includes/top-bar.php';?>
    <div class="dashboard_container">
        <!-- DASHBOARD LEFT SIDEBAR -->
        <div class="dashboard_sidebar">
            <div class="side_header side_student">
                <img src="assets/images/icons/students.svg">
                <h3>Student Information</h3>
            </div>
            <?php require 'side.php';?>
        </div>

        <!-- DASHBOARD RIGHT CONTENT -->
        <div class="dashboard_content">
            <div style="display: hidden;" class="content_header">
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="dashboard.php">
                        <img src="assets/images/icons/white/home1.svg">
                    </a>
                </p>
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/comment.svg">
                    </a>
                </p>        
                       
                <p class="controls_mobile std_chat">
                    <a class="nav_grid" href="#">
                        <img src="assets/images/icons/white/bell1.svg">
                    </a>
                </p>                  
                <div class="hamburger">
                    <div class="bar-x"></div>
                    <div class="bar-y"></div>
                    <div class="bar-z"></div>
                </div>
            </div>

            <!-- WEBSITE EDIT -->
            <div class="student_container">
                <!-- body -->
                <div class="web_page">
                    <div class="web_form">
                        <h3 >
                            School Website Edit
                        </h3>
                        <form id="web_form" action="" method="post" enctype="multipart/form-data">
                            <div class="edit_web_container_home">
                                <h3>Home Page</h3>
                                <div class="nav_group">
                                    <div class="nav_item">
                                        <label>Mobile phone</label>
                                        <input type="text" name="phone">
                                    </div>
                                    <div class="nav_item">
                                        <label>Email</label>
                                        <input type="text" name="email">
                                    </div>
                                </div>
                            </div>

                            <div class="edit_web_container_about">
                                <h3>About School Page</h3>
                                <div class="about_group">
                                    <label>Description</label>
                                    <p class="desc">
                                        NOTE: Describe the school's mission and ambitions in less than 50 words! 
                                    </p>
                                    <textarea name="details" rows="5"></textarea>
                                </div>

                                <div class="about_group">
                                    <label>Director Image</label>
                                    <p class="title">
                                        NOTE: This is the school directors image! 
                                    </p>
                                    <input type="file" name="d_image">
                                </div>

                                <div class="about_group">
                                    <label>School History</label>
                                    <p class="title">Short History of the school</p>
                                    <textarea  name="hist_det" rows="5"></textarea>
                                </div>
                            </div>

                            <div class="field" align="left">
                                <h3>Upload home slide images</h3>
                                <p class="title">
                                    Upload Images for home slider in the welcoming page for the website.
                                </p>
                                <input type="file" id="files" name="files[]" multiple />
                            </div>

                            <div id="webBtn" class="upload_btn">
                                <button id="btn" type="submit" onclick="updateWeb();">
                                    <i class="fa fa-paper-plane"></i>
                                    <p class="ajax_text">Update</p>
                                    <img id="ajax_loader" src="assets/images/blank.gif">
                                </button>
                            </div>
                        </form>
                    </div>

                    <div class="div_form_right">
                        <h3>Uploaded Content for the website!</h3>
                        <p class="form_title">Home Slider Images</p>
                        <div class="home_slider_img">
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                                <p>                                    
                                    Delete
                                    <i class="fa fa-trash"></i>
                                </p>
                            </div>
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                            </div>
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                            </div>
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                            </div>
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                            </div>
                            <div class="img_card">
                                <img src="assets/images/5.jpg">
                            </div>
                        </div>

                        <div class="about_content">
                            <div class="about_c">
                                <label>School Phone</label>
                                <p>+254758200125</p>
                            </div>
                            <div class="about_c">
                                <label>School Email</label>
                                <p>info@pineview.somalink.org</p>
                            </div>
                            <div class="about_c">
                                <label>Description</label>
                                <p>Our Campus Suite team is comprised of designers, developers, project leaders, and support specialists who all come together to create better ways for schools to communicate via the web.

                                We're in this together. Among our team members are former school PR professionals and former teachers, many of whom are parents themselves. You might say we take our work home with us, living and knowing firsthand the importance of school-parent engagement.</p>
                                <p class="about_title">Director's Image</p>
                                <img src="assets/images/5.jpg">
                            </div>
                            <div class="about_c">
                                <label>History</label>
                                <p>Our Campus Suite team is comprised of designers, developers, project leaders, and support specialists who all come together to create better ways for schools to communicate via the web.

                                We're in this together. Among our team members are former school PR professionals and former teachers, many of whom are parents themselves. You might say we take our work home with us, living and knowing firsthand the importance of school-parent engagement.</p>
                            </div> 
                            <div class="about_c">
                                <button>
                                    <i class="fa fa-edit"></i>
                                    Edit content
                                </button>
                            </div>                   
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <button class="b_history" onclick="history.back();">
        <i class="fa fa-chevron-left"></i>
        Back
    </button>

    <? require 'includes/footer.php'; ?>


    <!-- SCRIPTS -->
    
    <script src="assets/js/jquery-3.6.0.js"></script>       
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/js/table.js"></script>   

    <script type="text/javascript">
        $(document).ready(function() {
          $('#ajax_loader').hide();
          if (window.File && window.FileList && window.FileReader) {
            $("#files").on("change", function(e) {
              var files = e.target.files,
                filesLength = files.length;
              for (var i = 0; i < filesLength; i++) {
                var f = files[i]
                var fileReader = new FileReader();
                fileReader.onload = (function(e) {
                  var file = e.target;
                  $("<span class=\"pip\">" +
                    "<img class=\"imageThumb\" src=\"" + e.target.result + "\" title=\"" + file.name + "\"/>" +
                    "<br/><span class=\"remove\">Delete</span>" +
                    "</span>").insertAfter("#files");
                  $(".remove").click(function(){
                    $(this).parent(".pip").remove();
                  });
                  
                  // Old code here
                  /*$("<img></img>", {
                    class: "imageThumb",
                    src: e.target.result,
                    title: file.name + " | Click to remove"
                  }).insertAfter("#files").click(function(){$(this).remove();});*/
                  
                });
                fileReader.readAsDataURL(f);
              }
            });
          } else {
            alert("Your browser doesn't support to File API")
          }
        });

        function updateWeb() {

            const webForm = document.querySelector("#web_form"),
            webBtn =  document.querySelector("#webBtn"),
            errorText = document.querySelector("#error"),
            sucText = document.querySelector("#success");

            web = $('#webBtn').val();

            webForm.onsubmit = (e) => {
                e.preventDefault(); //prevents the form from submitting

            }
            //let's start ajax
            let webXhr = new XMLHttpRequest(); //creating xml object

            webXhr.onreadystatechange = function() {
                if (this.readyState !== "complete"){
                  $("#ajax_loader").show();
                  $("#ajax_text").hide();
                }

                if (webXhr.readyState === XMLHttpRequest.DONE) {
                    if (webXhr.status === 200) {

                        $("#ajax_loader").hide();
                        $("#ajax_text").show();

                        let response = JSON.parse(this.responseText);                        

                        if (response !== undefined && response !== null && response !== "") {
                            for(let item of response){
                                if (item.status == 'true') {
                                    sucText.textContent = item.message;
                                    sucText.style.display = "block";
                                    errorText.style.display = "none";
                                    clearForm();
                                }else{
                                    errorText.textContent = item.message;
                                    errorText.style.display = "block";
                                    sucText.style.display = "none";
                                    
                                }
                            }
                            
                        }else{
                            errorText.textContent = response;
                            errorText.style.display = "block";
                            sucText.style.display = "none";
                                                        
                        }
                    }
                }
            }
            
  

            webXhr.open("POST", "includes/web.php");
            let webFormData = new FormData(webForm);
           
            webXhr.send(webFormData);

        }
        function clearForm() {
            $('#web_form').trigger("reset");
            console.log("session cleared");
        }
        function errRemove() {
            let err = document.querySelector('#error');
            

            err.style.display = "none";
        }
        function sucRemove() {
            suc = document.querySelector('#success');

            suc.style.display = "none";
        }
    </script>
    

</body>
</html>

<?php 
    }
} 
?>